/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.bean;

import flexjson.BeanAnalyzer;
import flexjson.BeanProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaRelationship;
import ro.go.kpaxplanet.jsonpersister.exception.IntrospectionException;
import ro.go.kpaxplanet.jsonpersister.exception.InvocationTargetExceptionWrapper;

public class BeanIntrospector {
    private static final ThreadLocal<Map<Class<?>, BeanIntrospector>> _CACHE = new ThreadLocal();
    private BeanAnalyzer beanAnalyzer;
    private Map<String, BeanProperty> properties;

    private BeanIntrospector(Class<?> clazz) {
        this.beanAnalyzer = BeanAnalyzer.analyze(clazz);
        this.properties = new HashMap<String, BeanProperty>();
        for (BeanProperty property : this.beanAnalyzer.getProperties()) {
            this.properties.put(property.getName(), property);
        }
        this.properties.remove("class");
    }

    public static final BeanIntrospector introspect(Class<?> clazz) {
        Map<Class<?>, BeanIntrospector> cacheMap = _CACHE.get();
        if (cacheMap == null) {
            cacheMap = new HashMap();
            _CACHE.set(cacheMap);
        }
        if (cacheMap.containsKey(clazz)) {
            return cacheMap.get(clazz);
        }
        BeanIntrospector beanWrapper = new BeanIntrospector(clazz);
        cacheMap.put(clazz, beanWrapper);
        return beanWrapper;
    }

    public Map<String, BeanProperty> getProperties() {
        return this.properties;
    }

    public BeanProperty findProperty(String name) {
        return this.properties.get(name);
    }

    public <T extends Annotation> Map<String, BeanProperty> findAllAnnotatedProperty(Class<T> annotationClass) {
        HashMap<String, BeanProperty> annotatedProperties = new HashMap<String, BeanProperty>();
        for (BeanProperty property : this.properties.values()) {
            if (!BeanIntrospector.hasAnnotation(property, annotationClass)) continue;
            annotatedProperties.put(property.getName(), property);
        }
        return annotatedProperties;
    }

    public <T extends Annotation> BeanProperty findAnyAnnotatedProperty(Class<T>[] annotations) {
        for (BeanProperty property : this.properties.values()) {
            if (BeanIntrospector.findAnyAnnotation(property, annotations) == null) continue;
            return property;
        }
        return null;
    }

    public <T extends Annotation> BeanProperty findAnnotatedProperty(Class<T> annotationClass, String mappedBy) {
        for (BeanProperty property : this.properties.values()) {
            Method mappedByMethod;
            T annotation = BeanIntrospector.findAnnotation(property, annotationClass);
            if (annotation == null || (mappedByMethod = BeanIntrospector.getMethod(annotation.annotationType(), "mappedBy", new Class[0])) == null || !BeanIntrospector.invokeMethod(annotation, mappedByMethod, new Object[0]).equals(mappedBy)) continue;
            return property;
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(BeanProperty property, Class<T> annotationClass) {
        Method getter = property.getReadMethod();
        if (getter.isAnnotationPresent(annotationClass)) {
            return getter.getAnnotation(annotationClass);
        }
        Field field = property.getProperty();
        return field != null ? (T)field.getAnnotation(annotationClass) : null;
    }

    public static Annotation findAnyAnnotation(BeanProperty property, Class<? extends Annotation>[] annotationClasses) {
        Method getter = property.getReadMethod();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (!getter.isAnnotationPresent(annotationClass)) continue;
            return getter.getAnnotation(annotationClass);
        }
        Field field = property.getProperty();
        if (field != null) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                Annotation annotation = field.getAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    public static <T extends Annotation> boolean hasAnnotation(BeanProperty property, Class<T> annotationClass) {
        return BeanIntrospector.findAnnotation(property, annotationClass) != null;
    }

    public static Object invokeGetter(Object target, BeanProperty beanProperty) {
        Method getter = beanProperty.getReadMethod();
        if (getter != null) {
            return BeanIntrospector.invokeMethod(target, getter, new Object[0]);
        }
        throw new IllegalArgumentException("No getter found in [" + target.getClass().getName() + "] for property [" + beanProperty.getName() + "]");
    }

    public static void invokeSetter(Object target, BeanProperty beanProperty, Object arg) {
        Method setter = beanProperty.getWriteMethod();
        if (setter == null) {
            throw new IllegalArgumentException("No setter found in [" + target.getClass().getName() + "] for property [" + beanProperty.getName() + "]");
        }
        BeanIntrospector.invokeMethod(target, setter, arg);
    }

    public static void copyValue(Object from, Object to, BeanProperty property) {
        BeanIntrospector.invokeSetter(to, property, BeanIntrospector.invokeGetter(from, property));
    }

    public static Method getMethod(Class<?> ownerType, String name, Class<?> ... parameterTypes) {
        try {
            return ownerType.getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IntrospectionException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetExceptionWrapper(e.getTargetException());
        }
        catch (Exception e) {
            throw new IntrospectionException(e);
        }
    }

    public static boolean isJpaNullable(BeanProperty property) {
        JoinColumn annotation = BeanIntrospector.findAnnotation(property, JoinColumn.class);
        if (annotation != null) {
            Method nullable = BeanIntrospector.getMethod(JoinColumn.class, "nullable", new Class[0]);
            return nullable == null || (Boolean)BeanIntrospector.invokeMethod(annotation, nullable, new Object[0]) != false;
        }
        return true;
    }

    public static JpaRelationship findJpaRelatioship(BeanProperty property) {
        Annotation relation = BeanIntrospector.findAnyAnnotation(property, new Class[]{OneToOne.class, ManyToOne.class, OneToMany.class, ManyToMany.class});
        if (relation != null) {
            if (OneToOne.class.equals(relation.annotationType())) {
                OneToOne oneToOne = (OneToOne)relation;
                return new JpaRelationship(JpaRelationship.Type.ONETOONE, property.getName(), oneToOne.mappedBy(), oneToOne.cascade(), oneToOne.fetch());
            }
            if (ManyToOne.class.equals(relation.annotationType())) {
                ManyToOne manyToOne = (ManyToOne)relation;
                return new JpaRelationship(JpaRelationship.Type.MANYTOONE, property.getName(), null, manyToOne.cascade(), manyToOne.fetch());
            }
            if (OneToMany.class.equals(relation.annotationType())) {
                OneToMany oneToMany = (OneToMany)relation;
                return new JpaRelationship(JpaRelationship.Type.ONETOMANY, property.getName(), oneToMany.mappedBy(), oneToMany.cascade(), oneToMany.fetch());
            }
            if (ManyToMany.class.equals(relation.annotationType())) {
                ManyToMany manyToMany = (ManyToMany)relation;
                return new JpaRelationship(JpaRelationship.Type.MANYTOMANY, property.getName(), manyToMany.mappedBy(), manyToMany.cascade(), manyToMany.fetch());
            }
        }
        return null;
    }

    public static void clearCache() {
        _CACHE.remove();
    }
}

