/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.bean.jpa;

import flexjson.BeanProperty;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaRelationship;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersisterContext;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityPersistListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityRemoveListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.ListenerManager;
import ro.go.kpaxplanet.jsonpersister.util.StringUtils;

public class JpaHelper {
    private static final Logger logger = LoggerFactory.getLogger(JpaHelper.class);

    public static void persistEntity(Object entity) {
        JsonPersisterContext context = JsonPersisterContext.getContext();
        logger.debug("Persist entity on path [" + context.currentPath + "]");
        ListenerManager listeners = context.getListenerManager();
        EntityPersistListener entityPersistListener = listeners.getEntityPersistListener(context.currentSimplePath(), entity.getClass());
        EntityManager entityManager = context.getEntityManager();
        if (entityPersistListener == null || entityPersistListener.beforePersist(entity, entityManager)) {
            entityManager.persist(entity);
        } else {
            logger.debug("Persisting entity on path [" + context.currentPath + "] has been cancelled.");
        }
    }

    public static void removeEntity(Object entity) {
        JsonPersisterContext context = JsonPersisterContext.getContext();
        logger.debug("Remove entity on path [" + context.currentPath + "]");
        ListenerManager callbacks = context.getListenerManager();
        EntityRemoveListener entityRemoveListener = callbacks.getEntityRemoveListener(context.currentSimplePath(), entity.getClass());
        EntityManager entityManager = context.getEntityManager();
        if (entityRemoveListener == null || entityRemoveListener.beforeRemove(entity, entityManager)) {
            entityManager.remove(entity);
        } else {
            logger.debug("Removing entity on path [" + context.currentPath + "] has been cancelled.");
        }
    }

    public static void removeAllEntities(Collection entities, Class<?> clazz) {
        JsonPersisterContext context = JsonPersisterContext.getContext();
        logger.debug("Remove all entities on path [" + context.currentPath + "]");
        ListenerManager callbacks = context.getListenerManager();
        EntityRemoveListener entityRemoveListener = callbacks.getEntityRemoveListener(context.currentSimplePath(), clazz);
        JpaHelper.removeEntities(entityRemoveListener, context.getEntityManager(), entities);
    }

    public static void removeEntities(EntityRemoveListener entityRemoveListener, EntityManager entityManager, Collection entities) {
        for (Object entity : entities) {
            if (entityRemoveListener != null && !entityRemoveListener.beforeRemove(entity, entityManager)) continue;
            entityManager.remove(entity);
        }
    }

    public static void removeContainerRelationship(Collection toBeRemoved, Node nodeData) {
        Class<?> clazz = toBeRemoved.iterator().next().getClass();
        BeanIntrospector beanWrapper = BeanIntrospector.introspect(clazz);
        BeanProperty property = StringUtils.hasText(nodeData.getNodeContext().getJpaRelationship().getMappedBy()) ? beanWrapper.findProperty(nodeData.getNodeContext().getJpaRelationship().getMappedBy()) : beanWrapper.findAnnotatedProperty(nodeData.getNodeContext().getJpaRelationship().getType().oppositeRelationshipClass(), nodeData.getNodeContext().getProperty().getName());
        if (nodeData.getNodeContext().getJpaRelationship().getType() == JpaRelationship.Type.ONETOMANY && !BeanIntrospector.isJpaNullable(property)) {
            JpaHelper.removeAllEntities(toBeRemoved, clazz);
        } else {
            for (Object removed : toBeRemoved) {
                Object obj = BeanIntrospector.invokeGetter(removed, property);
                if (obj instanceof Collection) {
                    ((Collection)obj).remove(nodeData.getNodeContext().getOwner());
                    continue;
                }
                if (obj instanceof Map) {
                    ((Map)obj).remove(nodeData.getNodeContext().getOwner());
                    continue;
                }
                BeanIntrospector.invokeSetter(removed, property, null);
            }
        }
    }
}

