/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder;

import flexjson.BeanProperty;
import java.util.Map;
import javax.persistence.Id;
import javax.persistence.IdClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.PrimaryKeyFinder;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.SinglePrimaryKeyFinder;
import ro.go.kpaxplanet.jsonpersister.exception.IntrospectionException;

public class MultiplePrimaryKeyFinder
implements PrimaryKeyFinder {
    public static final MultiplePrimaryKeyFinder INSTANCE = new MultiplePrimaryKeyFinder();
    private final Logger logger = LoggerFactory.getLogger(SinglePrimaryKeyFinder.class);

    private MultiplePrimaryKeyFinder() {
    }

    @Override
    public Object findPrimaryKey(BeanIntrospector beanWrapper, Object target) {
        this.logger.debug("Find by multiple primary key on entity: " + target.getClass().getName());
        try {
            Class idClass = target.getClass().getAnnotation(IdClass.class).value();
            BeanIntrospector idClassWrapper = BeanIntrospector.introspect(idClass);
            Object primaryKey = idClass.newInstance();
            Map<String, BeanProperty> compositePkProperties = beanWrapper.findAllAnnotatedProperty(Id.class);
            for (BeanProperty idProperty : idClassWrapper.getProperties().values()) {
                BeanIntrospector.invokeSetter(primaryKey, idProperty, BeanIntrospector.invokeGetter(target, compositePkProperties.get(idProperty.getName())));
            }
            return primaryKey;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IntrospectionException(e);
        }
    }
}

