/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.flexjson;

import flexjson.ClassLocator;
import flexjson.ObjectBinder;
import flexjson.ObjectFactory;
import flexjson.Path;
import flexjson.factories.ClassLocatorObjectFactory;
import flexjson.locators.StaticClassLocator;
import java.util.HashMap;
import java.util.Map;

public class JSONDeserializer<T> {
    private Map<Class, ObjectFactory> typeFactories = new HashMap<Class, ObjectFactory>();
    private Map<Path, ObjectFactory> pathFactories = new HashMap<Path, ObjectFactory>();

    public T deserializeToken(Object input) {
        ObjectBinder binder = this.createObjectBinder();
        return (T)binder.bind(input);
    }

    public JSONDeserializer<T> use(String path, ClassLocator locator) {
        this.pathFactories.put(Path.parse((String)path), (ObjectFactory)new ClassLocatorObjectFactory(locator));
        return this;
    }

    public JSONDeserializer<T> use(String path, Class<?> clazz) {
        return this.use(path, (ClassLocator)new StaticClassLocator(clazz));
    }

    public JSONDeserializer<T> use(Class<?> clazz, ObjectFactory factory) {
        this.typeFactories.put(clazz, factory);
        if (clazz == Boolean.class) {
            this.typeFactories.put(Boolean.TYPE, factory);
        } else if (clazz == Integer.class) {
            this.typeFactories.put(Integer.TYPE, factory);
        } else if (clazz == Short.class) {
            this.typeFactories.put(Short.TYPE, factory);
        } else if (clazz == Long.class) {
            this.typeFactories.put(Long.TYPE, factory);
        } else if (clazz == Byte.class) {
            this.typeFactories.put(Byte.TYPE, factory);
        } else if (clazz == Float.class) {
            this.typeFactories.put(Float.TYPE, factory);
        } else if (clazz == Double.class) {
            this.typeFactories.put(Double.TYPE, factory);
        } else if (clazz == Character.class) {
            this.typeFactories.put(Character.TYPE, factory);
        }
        return this;
    }

    public JSONDeserializer<T> use(String path, ObjectFactory factory) {
        this.pathFactories.put(Path.parse((String)path), factory);
        return this;
    }

    public JSONDeserializer<T> use(ObjectFactory factory, String ... paths) {
        for (String p : paths) {
            this.use(p, factory);
        }
        return this;
    }

    private ObjectBinder createObjectBinder() {
        ObjectBinder binder = new ObjectBinder();
        for (Class clazz : this.typeFactories.keySet()) {
            binder.use(clazz, this.typeFactories.get(clazz));
        }
        for (Path p : this.pathFactories.keySet()) {
            binder.use(p, this.pathFactories.get(p));
        }
        return binder;
    }
}

