/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister;

import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersisterContext;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.ListenerManager;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.NodeVisitorListener;

public abstract class AbstractNodeVisitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNodeVisitor.class);

    public final void visitNode(Node node) {
        JsonPersisterContext context = JsonPersisterContext.getContext();
        context.registerNextNode(node);
        logger.debug("About to visit node on path [" + context.currentPath + "]");
        this.doVisit(context);
        context.deregisterNode();
    }

    public static final void delegateVisit(AbstractNodeVisitor visitor) {
        JsonPersisterContext context = JsonPersisterContext.getContext();
        logger.debug("About to revisit node on path [" + context.currentPath + "]");
        visitor.doVisit(context);
    }

    private void doVisit(JsonPersisterContext context) {
        Node nodeData = context.getNextNode();
        ListenerManager callbacks = context.getListenerManager();
        if (!callbacks.isExcluded(context.currentSimplePath())) {
            EntityManager entityManager = context.getEntityManager();
            NodeVisitorListener nodeVisitorListener = callbacks.getNodeVisitorListener(context.currentSimplePath());
            if (nodeVisitorListener != null) {
                if (nodeVisitorListener.beforeVisit(entityManager, nodeData)) {
                    this.onVisit(entityManager, nodeData);
                }
                nodeVisitorListener.afterVisit(entityManager, nodeData);
            } else {
                this.onVisit(entityManager, nodeData);
            }
        } else {
            logger.debug("Node excluded from visiting");
        }
    }

    protected abstract void onVisit(EntityManager var1, Node var2);
}

