/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister;

import javax.persistence.EntityManager;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.path.JsonPath;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.ListenerManager;

public final class JsonPersisterContext {
    private static final ThreadLocal<JsonPersisterContext> _THREAD_LOCAL = new ThreadLocal();
    public final JsonPath currentPath;
    private final ListenerManager listenerManager;
    private final EntityManager entityManager;
    private Node nextNode;

    private JsonPersisterContext(EntityManager entityManager, ListenerManager listenerManager) {
        this.entityManager = entityManager;
        this.listenerManager = listenerManager;
        this.currentPath = new JsonPath();
    }

    static JsonPersisterContext newContext(EntityManager entityManager, ListenerManager listenerManager) {
        JsonPersisterContext context = new JsonPersisterContext(entityManager, listenerManager);
        _THREAD_LOCAL.set(context);
        return context;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public static JsonPersisterContext getContext() {
        return _THREAD_LOCAL.get();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public String currentSimplePath() {
        return this.currentPath.toSimpleString();
    }

    public Node getNextNode() {
        return this.nextNode;
    }

    void registerNextNode(Node nextNode) {
        String label = null;
        if (nextNode.getNodeContext().getProperty() != null) {
            label = nextNode.getNodeContext().getProperty().getName();
        }
        this.currentPath.next(label, nextNode.getIndex());
        this.nextNode = nextNode;
    }

    void deregisterNode() {
        this.currentPath.back();
        this.nextNode = null;
    }

    static void clear() {
        _THREAD_LOCAL.remove();
    }
}

