/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister;

import flexjson.ClassLocator;
import flexjson.JSONException;
import flexjson.JSONTokener;
import flexjson.ObjectFactory;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.exception.JsonPersisterException;
import ro.go.kpaxplanet.jsonpersister.flexjson.JSONDeserializer;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersister;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersisterContext;
import ro.go.kpaxplanet.jsonpersister.persister.listener.DeserializationCallback;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.node.NodeContext;
import ro.go.kpaxplanet.jsonpersister.persister.selector.ClassSelector;
import ro.go.kpaxplanet.jsonpersister.persister.selector.PathSelector;
import ro.go.kpaxplanet.jsonpersister.persister.selector.impl.ClassSelectorImpl;
import ro.go.kpaxplanet.jsonpersister.persister.selector.impl.PathSelectorImpl;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.NodeVisitorFactory;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.ListenerManager;
import ro.go.kpaxplanet.jsonpersister.util.AssertUtils;

public class JsonPersisterImpl<T>
implements JsonPersister<T> {
    private final Logger logger = LoggerFactory.getLogger(JsonPersisterImpl.class);
    private EntityManager entityManager;
    private final ListenerManager listenerManager;
    private JSONDeserializer<T> deserializer;
    private DeserializationCallback<T> deserializationCallback;

    public JsonPersisterImpl(EntityManager entityManager) {
        AssertUtils.notNull(entityManager, "entityManager cannot be null");
        this.entityManager = entityManager;
        this.listenerManager = new ListenerManager();
        this.deserializer = new JSONDeserializer();
    }

    @Override
    public PathSelector paths(String ... paths) {
        return new PathSelectorImpl(paths, this.listenerManager);
    }

    @Override
    public ClassSelector classes(Class<?> ... classes) {
        if (classes.length == 0) {
            AssertUtils.notEmpty(classes, "classes cannot be empty");
        } else {
            for (Class<?> clazz : classes) {
                if (clazz.isAnnotationPresent(Entity.class)) continue;
                throw new IllegalArgumentException("Not an entity class [" + clazz.getName() + "]");
            }
        }
        return new ClassSelectorImpl(classes, this.listenerManager);
    }

    @Override
    public JsonPersister<T> use(String path, ClassLocator locator) {
        this.deserializer.use(path, locator);
        return this;
    }

    @Override
    public JsonPersister<T> use(String path, Class<?> clazz) {
        this.deserializer.use(path, clazz);
        return this;
    }

    @Override
    public JsonPersister<T> use(Class<?> clazz, ObjectFactory factory) {
        this.deserializer.use(clazz, factory);
        return this;
    }

    @Override
    public JsonPersister<T> use(String path, ObjectFactory factory) {
        this.deserializer.use(path, factory);
        return this;
    }

    @Override
    public JsonPersister<T> use(ObjectFactory factory, String ... paths) {
        this.deserializer.use(factory, paths);
        return this;
    }

    @Override
    public JsonPersister<T> on(DeserializationCallback<T> callback) {
        AssertUtils.notNull(callback, "callback cannot be null");
        this.deserializationCallback = callback;
        return this;
    }

    @Override
    public T persist(String json) {
        this.logger.info("Prepare for persisting JSON");
        try {
            Object token = new JSONTokener(json).nextValue();
            T obj = this.deserializer.deserializeToken(token);
            this.logger.info("JSON deserialized, now call deserialization callback");
            boolean canProceed = true;
            if (this.deserializationCallback != null) {
                canProceed = this.deserializationCallback.afterDeserialization(obj);
            }
            if (canProceed) {
                this.logger.info("Start persisting JSON");
                return this.visitRootNode(token, obj);
            }
            this.logger.info("JSON persisting stopped by deserialization callback");
            return obj;
        }
        catch (JSONException | EntityNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonPersisterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T visitRootNode(Object rootNode, Object dto) {
        JsonPersisterContext.newContext(this.entityManager, this.listenerManager);
        try {
            Node nodeData = new Node(dto.getClass(), rootNode, dto, null, new NodeContext());
            NodeVisitorFactory.createNodeVisitor(nodeData.getTypeCls()).visitNode(nodeData);
            this.logger.info("JSON persisted");
            if (nodeData.getManagedObj() != null) {
                Object object = nodeData.getManagedObj();
                return (T)object;
            }
            Object object = nodeData.getDataObj();
            return (T)object;
        }
        finally {
            JsonPersisterContext.clear();
            BeanIntrospector.clearCache();
        }
    }
}

