/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.selector.impl;

import ro.go.kpaxplanet.jsonpersister.persister.selector.PathSelector;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EmptyManagedNodeListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityPersistListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityRemoveListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.ListenerManager;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.NodeVisitorListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.PhantomEntityListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.strategy.PersistPhantomEntityStrategy;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.strategy.RemoveIfEmptyStrategy;

public class PathSelectorImpl
implements PathSelector {
    private final String[] paths;
    private final ListenerManager callbacks;

    public PathSelectorImpl(String[] paths, ListenerManager callbacks) {
        this.paths = paths;
        this.callbacks = callbacks;
    }

    @Override
    public PathSelector removeEmpty() {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEmptyManagedNodeListener(RemoveIfEmptyStrategy.INSTANCE);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEmptyManagedNodeListener(path, RemoveIfEmptyStrategy.INSTANCE);
            }
        }
        return this;
    }

    @Override
    public void exclude() {
        this.callbacks.exclude(this.paths);
    }

    @Override
    public PathSelector persistPhantom() {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEntityNotFoundStrategy(PersistPhantomEntityStrategy.INSTANCE);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEntityNotFoundStrategy(path, PersistPhantomEntityStrategy.INSTANCE);
            }
        }
        return this;
    }

    @Override
    public PathSelector on(NodeVisitorListener listener) {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultNodeVisitorListener(listener);
        } else {
            for (String path : this.paths) {
                this.callbacks.addNodeVisitorListener(path, listener);
            }
        }
        return this;
    }

    @Override
    public PathSelector on(EntityPersistListener listener) {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEntityPersistListener(listener);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEntityPersistListener(path, listener);
            }
        }
        return this;
    }

    @Override
    public PathSelector on(EntityRemoveListener listener) {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEntityRemoveListener(listener);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEntityRemoveListener(path, listener);
            }
        }
        return this;
    }

    @Override
    public PathSelector on(PhantomEntityListener listener) {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEntityNotFoundStrategy(listener);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEntityNotFoundStrategy(path, listener);
            }
        }
        return this;
    }

    @Override
    public PathSelector on(EmptyManagedNodeListener listener) {
        if (this.paths.length == 0) {
            this.callbacks.setDefaultEmptyManagedNodeListener(listener);
        } else {
            for (String path : this.paths) {
                this.callbacks.addEmptyManagedNodeListener(path, listener);
            }
        }
        return this;
    }
}

