/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.NodeVisitorFactory;

public class ArrayNodeVisitor
extends AbstractNodeVisitor {
    public static final ArrayNodeVisitor INSTANCE = new ArrayNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(ArrayNodeVisitor.class);

    private ArrayNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit array node for " + nodeData);
        Collection dtoCollection = (Collection)nodeData.getDataObj();
        if (dtoCollection != null) {
            if (!dtoCollection.isEmpty()) {
                ArrayList rawNodeArray = (ArrayList)nodeData.getRawNode();
                Class<?> typeCls = dtoCollection.iterator().next().getClass();
                int index = 0;
                Iterator itr = dtoCollection.iterator();
                while (itr.hasNext()) {
                    Node itemNodeData = new Node(typeCls, rawNodeArray.get(index), itr.next(), null, nodeData.getNodeContext(), index);
                    NodeVisitorFactory.createNodeVisitor(typeCls).visitNode(itemNodeData);
                    ++index;
                }
            } else {
                this.logger.debug("Empty collection node, nothing to visit");
            }
        } else {
            this.logger.debug("Null node");
        }
    }
}

