/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.ByPrimaryKeyComparator;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaHelper;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.PrimaryKeyFinder;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.factory.PrimaryKeyFinderFactory;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.ManagedObjectNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.NewEntityNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.util.CollectionUtils;

public class ManagedArrayNodeVisitor
extends AbstractNodeVisitor {
    public static final ManagedArrayNodeVisitor INSTANCE = new ManagedArrayNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(ManagedArrayNodeVisitor.class);

    private ManagedArrayNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit managed array node for " + nodeData);
        Collection managedCollection = (Collection)nodeData.getManagedObj();
        ArrayList toBeRemoved = new ArrayList(managedCollection);
        Collection dtoCollection = (Collection)nodeData.getDataObj();
        if (dtoCollection != null && !dtoCollection.isEmpty()) {
            Class<?> clazz = dtoCollection.iterator().next().getClass();
            ArrayList arrayRawNode = (ArrayList)nodeData.getRawNode();
            PrimaryKeyFinder primaryKeyFinder = PrimaryKeyFinderFactory.createFinder(clazz);
            ByPrimaryKeyComparator pkComparator = new ByPrimaryKeyComparator(BeanIntrospector.introspect(clazz), primaryKeyFinder);
            int index = 0;
            for (Object childData : dtoCollection) {
                if (childData != null) {
                    Object managedItem = toBeRemoved.isEmpty() ? null : CollectionUtils.search(toBeRemoved, childData, pkComparator);
                    Node childNodeData = new Node(clazz, arrayRawNode.get(index), childData, managedItem, nodeData.getNodeContext(), index);
                    if (managedItem != null) {
                        ManagedObjectNodeVisitor.INSTANCE.visitNode(childNodeData);
                        toBeRemoved.remove(managedItem);
                    } else {
                        NewEntityNodeVisitor.INSTANCE.visitNode(childNodeData);
                    }
                }
                ++index;
            }
        }
        if (!toBeRemoved.isEmpty()) {
            JpaHelper.removeContainerRelationship(toBeRemoved, nodeData);
            managedCollection.removeAll(toBeRemoved);
        }
    }
}

