/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaHelper;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.ManagedNodeVisitorFactory;

public class ManagedMapNodeVisitor
extends AbstractNodeVisitor {
    public static final ManagedMapNodeVisitor INSTANCE = new ManagedMapNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(ManagedMapNodeVisitor.class);

    private ManagedMapNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit managed map node for " + nodeData);
        Map managedMap = (Map)nodeData.getManagedObj();
        Map toBeRemovedMap = new HashMap();
        Map dataMap = (Map)nodeData.getDataObj();
        if (dataMap != null) {
            Class<?> clazz = null;
            if (!managedMap.isEmpty()) {
                clazz = managedMap.values().iterator().next().getClass();
            } else if (!dataMap.isEmpty()) {
                clazz = dataMap.values().iterator().next().getClass();
            }
            if (clazz != null) {
                Map rawNodeMap = (Map)nodeData.getRawNode();
                for (Map.Entry entry : dataMap.entrySet()) {
                    Node entryNodeData = new Node(clazz, rawNodeMap.get(entry.getKey().toString()), entry.getValue(), managedMap.get(entry.getKey()), nodeData.getNodeContext(), entry.getKey());
                    ManagedNodeVisitorFactory.createNodeVisitor(clazz).visitNode(entryNodeData);
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    if (dataMap.containsKey(entry.getKey())) continue;
                    toBeRemovedMap.put(entry.getKey(), entry.getValue());
                }
            }
        } else if (!managedMap.isEmpty()) {
            toBeRemovedMap = managedMap;
        }
        if (!toBeRemovedMap.isEmpty()) {
            JpaHelper.removeContainerRelationship(toBeRemovedMap.values(), nodeData);
            Set entrySet = toBeRemovedMap.entrySet();
            for (Map.Entry entry : entrySet) {
                managedMap.remove(entry.getKey());
            }
        }
    }
}

