/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import flexjson.BeanProperty;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaHelper;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaRelationship;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersisterContext;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.node.NodeContext;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.ManagedNodeVisitorFactory;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EmptyManagedNodeListener;
import ro.go.kpaxplanet.jsonpersister.util.StringUtils;

public class ManagedObjectNodeVisitor
extends AbstractNodeVisitor {
    public static final ManagedObjectNodeVisitor INSTANCE = new ManagedObjectNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(ManagedObjectNodeVisitor.class);

    private ManagedObjectNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit managed object node for " + nodeData);
        BeanIntrospector beanWrapper = BeanIntrospector.introspect(nodeData.getTypeCls());
        if (nodeData.getRawNode() != null) {
            Map mapRawNode = (Map)nodeData.getRawNode();
            for (Map.Entry entry : mapRawNode.entrySet()) {
                BeanProperty property = beanWrapper.findProperty((String)entry.getKey());
                if (property == null || property.getPropertyType().isAnnotationPresent(Id.class) || property.getPropertyType().isAnnotationPresent(EmbeddedId.class)) continue;
                JpaRelationship childJpaRelationship = BeanIntrospector.findJpaRelatioship(property);
                if (childJpaRelationship != null) {
                    if (nodeData.getNodeContext() != null && childJpaRelationship.isBidirectional(nodeData.getNodeContext().getJpaRelationship())) continue;
                    Node childNodeData = new Node(property.getPropertyType(), mapRawNode.get(property.getName()), BeanIntrospector.invokeGetter(nodeData.getDataObj(), property), BeanIntrospector.invokeGetter(nodeData.getManagedObj(), property), new NodeContext(property, childJpaRelationship, nodeData.getManagedObj()));
                    ManagedNodeVisitorFactory.createNodeVisitor(childNodeData.getTypeCls()).visitNode(childNodeData);
                    continue;
                }
                BeanIntrospector.copyValue(nodeData.getDataObj(), nodeData.getManagedObj(), property);
            }
        } else if (nodeData.getManagedObj() != null) {
            BeanProperty property;
            this.logger.debug("Remove jpa relationships");
            Class parentClass = nodeData.getNodeContext().getProperty().getPropertyType();
            if (Collection.class.isAssignableFrom(parentClass)) {
                ((Collection)BeanIntrospector.invokeGetter(nodeData.getNodeContext().getOwner(), nodeData.getNodeContext().getProperty())).remove(nodeData.getManagedObj());
            } else if (Map.class.isAssignableFrom(parentClass)) {
                ((Map)BeanIntrospector.invokeGetter(nodeData.getNodeContext().getOwner(), nodeData.getNodeContext().getProperty())).remove(nodeData.getManagedObj());
            } else {
                BeanIntrospector.invokeSetter(nodeData.getNodeContext().getOwner(), nodeData.getNodeContext().getProperty(), null);
            }
            JsonPersisterContext context = JsonPersisterContext.getContext();
            EmptyManagedNodeListener emptyManagedNodeListener = context.getListenerManager().getEmptyManagedNodeListener(context.currentSimplePath());
            if (emptyManagedNodeListener != null) {
                emptyManagedNodeListener.onEmptyManagedNode(nodeData.getTypeCls(), nodeData.getManagedObj(), entityManager);
            }
            if (entityManager.contains(nodeData.getManagedObj()) && (property = StringUtils.hasText(nodeData.getNodeContext().getJpaRelationship().getMappedBy()) ? beanWrapper.findProperty(nodeData.getNodeContext().getJpaRelationship().getMappedBy()) : beanWrapper.findAnnotatedProperty(nodeData.getNodeContext().getJpaRelationship().getType().oppositeRelationshipClass(), nodeData.getNodeContext().getProperty().getName())) != null) {
                if (nodeData.getNodeContext().getJpaRelationship().getType() == JpaRelationship.Type.ONETOONE && !BeanIntrospector.isJpaNullable(property)) {
                    JpaHelper.removeEntity(nodeData.getManagedObj());
                } else {
                    Object obj = BeanIntrospector.invokeGetter(nodeData.getManagedObj(), property);
                    if (obj instanceof Collection) {
                        ((Collection)obj).remove(nodeData.getNodeContext().getOwner());
                    } else if (obj instanceof Map) {
                        ((Map)obj).remove(nodeData.getNodeContext().getOwner());
                    } else {
                        BeanIntrospector.invokeSetter(nodeData.getManagedObj(), property, null);
                    }
                }
            }
        }
    }
}

