/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.NodeVisitorFactory;

public class MapNodeVisitor
extends AbstractNodeVisitor {
    public static final MapNodeVisitor INSTANCE = new MapNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(MapNodeVisitor.class);

    private MapNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit map node for " + nodeData);
        if (nodeData.getDataObj() != null) {
            Map dataMap = (Map)nodeData.getDataObj();
            Set dataEntrySet = dataMap.entrySet();
            if (!dataMap.isEmpty()) {
                Map rawNodeMap = (Map)nodeData.getRawNode();
                Class<?> valueClass = dataEntrySet.iterator().next().getValue().getClass();
                for (Map.Entry entry : dataEntrySet) {
                    Node entryNodeData = new Node(valueClass, rawNodeMap.get(entry.getKey()), entry.getValue(), null, nodeData.getNodeContext(), entry.getKey());
                    NodeVisitorFactory.createNodeVisitor(valueClass).visitNode(entryNodeData);
                }
            }
        }
    }
}

