/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import flexjson.BeanProperty;
import java.util.ArrayList;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaHelper;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaRelationship;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.node.NodeContext;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.NodeVisitorFactory;
import ro.go.kpaxplanet.jsonpersister.util.StringUtils;

public class NewEntityNodeVisitor
extends AbstractNodeVisitor {
    public static final NewEntityNodeVisitor INSTANCE = new NewEntityNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(NewEntityNodeVisitor.class);

    private NewEntityNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit new entity node for " + nodeData);
        Map mapRawNode = (Map)nodeData.getRawNode();
        BeanIntrospector beanWrapper = BeanIntrospector.introspect(nodeData.getTypeCls());
        ArrayList<Node> visitLaterNodes = new ArrayList<Node>();
        for (Map.Entry entry : mapRawNode.entrySet()) {
            BeanProperty property = beanWrapper.findProperty((String)entry.getKey());
            if (property == null) continue;
            String fieldName = property.getName();
            JpaRelationship childJpaRelationship = BeanIntrospector.findJpaRelatioship(property);
            if (childJpaRelationship == null) continue;
            if (childJpaRelationship.getType() == JpaRelationship.Type.ONETOMANY) {
                visitLaterNodes.add(new Node(property.getPropertyType(), mapRawNode.get(fieldName), BeanIntrospector.invokeGetter(nodeData.getDataObj(), property), null, new NodeContext(property, childJpaRelationship, nodeData.getDataObj())));
                BeanIntrospector.invokeSetter(nodeData.getDataObj(), property, null);
                continue;
            }
            Node childNodeData = new Node(property.getPropertyType(), mapRawNode.get(fieldName), BeanIntrospector.invokeGetter(nodeData.getDataObj(), property), null, new NodeContext(property, childJpaRelationship, nodeData.getDataObj()), null);
            NodeVisitorFactory.createNodeVisitor(childNodeData.getTypeCls()).visitNode(childNodeData);
        }
        if (nodeData.getNodeContext().getJpaRelationship() != null && (nodeData.getNodeContext().getJpaRelationship().getType() == JpaRelationship.Type.ONETOMANY || nodeData.getNodeContext().getJpaRelationship().getType() == JpaRelationship.Type.ONETOONE)) {
            if (StringUtils.hasText(nodeData.getNodeContext().getJpaRelationship().getMappedBy())) {
                BeanProperty setter = beanWrapper.findProperty(nodeData.getNodeContext().getJpaRelationship().getMappedBy());
                BeanIntrospector.invokeSetter(nodeData.getDataObj(), setter, nodeData.getNodeContext().getOwner());
            } else {
                BeanProperty property = beanWrapper.findAnnotatedProperty(nodeData.getNodeContext().getJpaRelationship().getType().oppositeRelationshipClass(), nodeData.getNodeContext().getJpaRelationship().getMappingName());
                if (property != null) {
                    BeanIntrospector.invokeSetter(nodeData.getDataObj(), property, nodeData.getNodeContext().getOwner());
                }
            }
        }
        JpaHelper.persistEntity(nodeData.getDataObj());
        this.logger.debug("Delayed nodes to visit: " + visitLaterNodes);
        for (Node visitLaterNodeData : visitLaterNodes) {
            NodeVisitorFactory.createNodeVisitor(visitLaterNodeData.getTypeCls()).visitNode(visitLaterNodeData);
            if (visitLaterNodeData.getNodeContext().getJpaRelationship().getType() != JpaRelationship.Type.ONETOMANY) continue;
            BeanIntrospector.invokeSetter(nodeData.getDataObj(), visitLaterNodeData.getNodeContext().getProperty(), visitLaterNodeData.getDataObj());
        }
    }
}

