/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor;

import flexjson.BeanProperty;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.go.kpaxplanet.jsonpersister.bean.BeanIntrospector;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.JpaRelationship;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.PrimaryKeyFinder;
import ro.go.kpaxplanet.jsonpersister.bean.jpa.keyfinder.factory.PrimaryKeyFinderFactory;
import ro.go.kpaxplanet.jsonpersister.persister.AbstractNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.JsonPersisterContext;
import ro.go.kpaxplanet.jsonpersister.persister.node.Node;
import ro.go.kpaxplanet.jsonpersister.persister.node.NodeContext;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.NewEntityNodeVisitor;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.ManagedNodeVisitorFactory;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.factory.NodeVisitorFactory;

public class ObjectNodeVisitor
extends AbstractNodeVisitor {
    public static final ObjectNodeVisitor INSTANCE = new ObjectNodeVisitor();
    private final Logger logger = LoggerFactory.getLogger(ObjectNodeVisitor.class);

    private ObjectNodeVisitor() {
    }

    @Override
    protected void onVisit(EntityManager entityManager, Node nodeData) {
        this.logger.debug("Visit object node for " + nodeData);
        Map mapRawNode = (Map)nodeData.getRawNode();
        if (mapRawNode != null) {
            BeanIntrospector beanWrapper = BeanIntrospector.introspect(nodeData.getTypeCls());
            if (nodeData.getTypeCls().isAnnotationPresent(Entity.class)) {
                PrimaryKeyFinder primaryKeyFinder = PrimaryKeyFinderFactory.createFinder(nodeData.getTypeCls());
                Object primaryKey = primaryKeyFinder.findPrimaryKey(beanWrapper, nodeData.getDataObj());
                if (primaryKey != null) {
                    Object managedObj = entityManager.find(nodeData.getTypeCls(), primaryKey);
                    if (managedObj != null) {
                        nodeData.setManagedObj(managedObj);
                        for (Map.Entry entry : mapRawNode.entrySet()) {
                            BeanProperty property = beanWrapper.findProperty((String)entry.getKey());
                            if (property == null) continue;
                            JpaRelationship childJpaRelationship = BeanIntrospector.findJpaRelatioship(property);
                            if (childJpaRelationship != null) {
                                if (childJpaRelationship.isBidirectional(nodeData.getNodeContext().getJpaRelationship())) continue;
                                Node childNodeData = new Node(property.getPropertyType(), mapRawNode.get(property.getName()), BeanIntrospector.invokeGetter(nodeData.getDataObj(), property), BeanIntrospector.invokeGetter(managedObj, property), new NodeContext(property, childJpaRelationship, managedObj));
                                ManagedNodeVisitorFactory.createNodeVisitor(childNodeData.getTypeCls()).visitNode(childNodeData);
                                continue;
                            }
                            BeanIntrospector.copyValue(nodeData.getDataObj(), managedObj, property);
                        }
                        if (nodeData.getNodeContext().getOwner() != null) {
                            if (Collection.class.isAssignableFrom(nodeData.getNodeContext().getOwner().getClass())) {
                                Collection dataCollection = (Collection)nodeData.getNodeContext().getOwner();
                                dataCollection.remove(nodeData.getDataObj());
                                dataCollection.add(managedObj);
                            } else if (Map.class.isAssignableFrom(nodeData.getNodeContext().getOwner().getClass())) {
                                Map dataMap = (Map)nodeData.getNodeContext().getOwner();
                                dataMap.put(nodeData.getIndex(), managedObj);
                            } else {
                                BeanIntrospector.invokeSetter(nodeData.getNodeContext().getOwner(), nodeData.getNodeContext().getProperty(), managedObj);
                            }
                        }
                    } else {
                        this.logger.debug("Phantom entity found, now apply strategy");
                        JsonPersisterContext context = JsonPersisterContext.getContext();
                        context.getListenerManager().getEntityNotFoundStrategy(context.currentSimplePath()).onPhantomEntity(nodeData, nodeData.getTypeCls(), primaryKey);
                    }
                } else {
                    ObjectNodeVisitor.delegateVisit(NewEntityNodeVisitor.INSTANCE);
                }
            } else {
                for (BeanProperty property : beanWrapper.getProperties().values()) {
                    String fieldName = property.getName();
                    if (!mapRawNode.containsKey(fieldName)) continue;
                    Node childNodeData = new Node(property.getPropertyType(), mapRawNode.get(fieldName), BeanIntrospector.invokeGetter(nodeData.getDataObj(), property), null, nodeData.getNodeContext(), null);
                    NodeVisitorFactory.createNodeVisitor(childNodeData.getTypeCls()).visitNode(childNodeData);
                }
            }
        }
    }
}

