/*
 * Decompiled with CFR 0.152.
 */
package ro.go.kpaxplanet.jsonpersister.persister.visitor.listener;

import java.util.HashMap;
import java.util.Map;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EmptyManagedNodeListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityPersistListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.EntityRemoveListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.NodeVisitorListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.PhantomEntityListener;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.strategy.EntityNotFoundErrorStrategy;
import ro.go.kpaxplanet.jsonpersister.persister.visitor.listener.strategy.SkipNodeStrategy;

public class ListenerManager {
    private final Map<String, NodeVisitorListener> nodeVisitorListenerMap = new HashMap<String, NodeVisitorListener>();
    private final Map<String, NodeVisitorListener> excludeNodeListenerMap = new HashMap<String, NodeVisitorListener>();
    private final Map<String, EntityPersistListener> persistEntityListenerMap = new HashMap<String, EntityPersistListener>();
    private final Map<String, EntityRemoveListener> removeEntityListenerMap = new HashMap<String, EntityRemoveListener>();
    private final Map<Class<?>, EntityPersistListener> persistEntityListenerClassMap = new HashMap();
    private final Map<Class<?>, EntityRemoveListener> removeEntityListenerClassMap = new HashMap();
    private final Map<String, PhantomEntityListener> entityNotFoundStrategyMap = new HashMap<String, PhantomEntityListener>();
    private final Map<String, EmptyManagedNodeListener> emptyManagedNodeListenerMap = new HashMap<String, EmptyManagedNodeListener>();
    private PhantomEntityListener defaultEntityNotFoundStrategy = EntityNotFoundErrorStrategy.INSTANCE;
    private NodeVisitorListener defaultNodeVisitorListener;
    private EntityPersistListener defaultEntityPersistListener;
    private EntityRemoveListener defaultEntityRemoveListener;
    private EmptyManagedNodeListener defaultEmptyManagedNodeListener;
    private boolean excludeAll;

    public ListenerManager addEntityPersistListener(String path, EntityPersistListener listener) {
        this.persistEntityListenerMap.put(path, listener);
        return this;
    }

    public ListenerManager addEntityRemoveListener(String path, EntityRemoveListener listener) {
        this.removeEntityListenerMap.put(path, listener);
        return this;
    }

    public ListenerManager addEntityPersistListener(Class<?> clazz, EntityPersistListener listener) {
        this.persistEntityListenerClassMap.put(clazz, listener);
        return this;
    }

    public ListenerManager addEntityRemoveListener(Class<?> clazz, EntityRemoveListener listener) {
        this.removeEntityListenerClassMap.put(clazz, listener);
        return this;
    }

    public ListenerManager addNodeVisitorListener(String path, NodeVisitorListener listener) {
        this.nodeVisitorListenerMap.put(path, listener);
        return this;
    }

    public ListenerManager addEntityNotFoundStrategy(String path, PhantomEntityListener listener) {
        this.entityNotFoundStrategyMap.put(path, listener);
        return this;
    }

    public ListenerManager addEmptyManagedNodeListener(String path, EmptyManagedNodeListener listener) {
        this.emptyManagedNodeListenerMap.put(path, listener);
        return this;
    }

    public ListenerManager exclude(String ... paths) {
        if (paths.length > 0) {
            for (String path : paths) {
                this.excludeNodeListenerMap.put(path, SkipNodeStrategy.INSTANCE);
            }
        } else {
            this.excludeAll = true;
        }
        return this;
    }

    public boolean isExcluded(String path) {
        return this.excludeAll || this.excludeNodeListenerMap.containsKey(path);
    }

    public boolean isExcludeAll() {
        return this.excludeAll;
    }

    public NodeVisitorListener getNodeVisitorListener(String path) {
        if (path != null && this.nodeVisitorListenerMap.containsKey(path)) {
            return this.nodeVisitorListenerMap.get(path);
        }
        return this.defaultNodeVisitorListener;
    }

    public EntityRemoveListener getEntityRemoveListener(String path, Class<?> clazz) {
        if (path != null && this.removeEntityListenerMap.containsKey(path)) {
            return this.removeEntityListenerMap.get(path);
        }
        if (clazz != null && this.removeEntityListenerClassMap.containsKey(clazz)) {
            return this.removeEntityListenerClassMap.get(clazz);
        }
        return this.defaultEntityRemoveListener;
    }

    public EntityPersistListener getEntityPersistListener(String path, Class<?> clazz) {
        if (path != null && this.persistEntityListenerMap.containsKey(path)) {
            return this.persistEntityListenerMap.get(path);
        }
        if (clazz != null && this.persistEntityListenerClassMap.containsKey(clazz)) {
            return this.persistEntityListenerClassMap.get(clazz);
        }
        return this.defaultEntityPersistListener;
    }

    public PhantomEntityListener getEntityNotFoundStrategy(String path) {
        if (path != null && this.entityNotFoundStrategyMap.containsKey(path)) {
            return this.entityNotFoundStrategyMap.get(path);
        }
        return this.defaultEntityNotFoundStrategy;
    }

    public EmptyManagedNodeListener getEmptyManagedNodeListener(String path) {
        if (path != null && this.emptyManagedNodeListenerMap.containsKey(path)) {
            return this.emptyManagedNodeListenerMap.get(path);
        }
        return this.defaultEmptyManagedNodeListener;
    }

    public PhantomEntityListener getDefaultEntityNotFoundStrategy() {
        return this.defaultEntityNotFoundStrategy;
    }

    public void setDefaultEntityNotFoundStrategy(PhantomEntityListener defaultEntityNotFoundStrategy) {
        this.defaultEntityNotFoundStrategy = defaultEntityNotFoundStrategy;
    }

    public NodeVisitorListener getDefaultNodeVisitorListener() {
        return this.defaultNodeVisitorListener;
    }

    public void setDefaultNodeVisitorListener(NodeVisitorListener defaultNodeVisitorListener) {
        this.defaultNodeVisitorListener = defaultNodeVisitorListener;
    }

    public EntityPersistListener getDefaultEntityPersistListener() {
        return this.defaultEntityPersistListener;
    }

    public void setDefaultEntityPersistListener(EntityPersistListener defaultEntityPersistListener) {
        this.defaultEntityPersistListener = defaultEntityPersistListener;
    }

    public EntityRemoveListener getDefaultEntityRemoveListener() {
        return this.defaultEntityRemoveListener;
    }

    public void setDefaultEntityRemoveListener(EntityRemoveListener defaultEntityRemoveListener) {
        this.defaultEntityRemoveListener = defaultEntityRemoveListener;
    }

    public EmptyManagedNodeListener getDefaultEmptyManagedNodeListener() {
        return this.defaultEmptyManagedNodeListener;
    }

    public void setDefaultEmptyManagedNodeListener(EmptyManagedNodeListener defaultEmptyManagedNodeListener) {
        this.defaultEmptyManagedNodeListener = defaultEmptyManagedNodeListener;
    }

    public Map<String, PhantomEntityListener> getEntityNotFoundStrategyMap() {
        return this.entityNotFoundStrategyMap;
    }

    public ListenerManager putAllNodeVisitorListeners(Map<String, NodeVisitorListener> listenerMap) {
        this.nodeVisitorListenerMap.putAll(listenerMap);
        return this;
    }

    public void removeNodeVisitorListeners() {
        this.nodeVisitorListenerMap.clear();
    }
}

