/*
 * Decompiled with CFR 0.152.
 */
package ro.gs1.quarkus.etcd.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.HashSet;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import ro.gs1.quarkus.etcd.api.EtcdClient;
import ro.gs1.quarkus.etcd.api.EtcdClientChannel;
import ro.gs1.quarkus.etcd.runtime.EtcdClientDestroyer;
import ro.gs1.quarkus.etcd.runtime.EtcdClientFactory;
import ro.gs1.quarkus.etcd.runtime.config.EtcdConfigProvider;

class EtcdClientProcessor {
    private static final String FEATURE = "etcd-client";

    EtcdClientProcessor() {
    }

    @BuildStep
    void createContext(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{EtcdClient.class}));
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{EtcdConfigProvider.class}).build());
    }

    @BuildStep
    void generateEtcdClientProducers(BeanDiscoveryFinishedBuildItem beanDiscovery, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<FeatureBuildItem> features) {
        HashSet<String> clients = new HashSet<String>();
        for (InjectionPointInfo injectionPoint : beanDiscovery.getInjectionPoints()) {
            AnnotationInstance clientAnnotation = injectionPoint.getRequiredQualifier(DotName.createSimple((String)EtcdClient.class.getName()));
            if (clientAnnotation == null) continue;
            AnnotationValue clientNameValue = clientAnnotation.value();
            if (clientNameValue == null) {
                throw new DeploymentException("@EtcdClient client name cannot be null.");
            }
            String clientName = clientNameValue.asString();
            clients.add(clientName);
        }
        if (!clients.isEmpty()) {
            for (String client : clients) {
                SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EtcdClientChannel.class).addQualifier().annotation(DotName.createSimple((String)EtcdClient.class.getName())).addValue("value", (Object)client).done()).scope(ApplicationScoped.class)).unremovable()).forceApplicationClass()).creator(mc -> this.generateChannelProducer((MethodCreator)mc, client))).destroyer(EtcdClientDestroyer.class);
                syntheticBeans.produce((BuildItem)configurator.done());
            }
            features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        }
    }

    private void generateChannelProducer(MethodCreator mc, String clientName) {
        ResultHandle name = mc.load(clientName);
        ResultHandle result = mc.invokeStaticMethod(MethodDescriptor.ofMethod(EtcdClientFactory.class, (String)"createClient", EtcdClientChannel.class, (Class[])new Class[]{String.class}), new ResultHandle[]{name});
        mc.returnValue(result);
        mc.close();
    }
}

