/*
 * Decompiled with CFR 0.152.
 */
package ro.gs1.quarkus.etcd.runtime;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.net.JksOptions;
import io.vertx.grpc.VertxChannelBuilder;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import ro.gs1.quarkus.etcd.api.AuthenticateRequest;
import ro.gs1.quarkus.etcd.api.AuthenticateResponse;
import ro.gs1.quarkus.etcd.api.Cluster;
import ro.gs1.quarkus.etcd.api.ClusterClient;
import ro.gs1.quarkus.etcd.api.EtcdClientChannel;
import ro.gs1.quarkus.etcd.api.KV;
import ro.gs1.quarkus.etcd.api.KVClient;
import ro.gs1.quarkus.etcd.api.Lease;
import ro.gs1.quarkus.etcd.api.LeaseClient;
import ro.gs1.quarkus.etcd.api.Maintenance;
import ro.gs1.quarkus.etcd.api.MaintenanceClient;
import ro.gs1.quarkus.etcd.api.MutinyAuthGrpc;
import ro.gs1.quarkus.etcd.api.Watch;
import ro.gs1.quarkus.etcd.api.WatchClient;
import ro.gs1.quarkus.etcd.api.lock.Lock;
import ro.gs1.quarkus.etcd.api.lock.LockClient;
import ro.gs1.quarkus.etcd.runtime.config.EtcdClientConfig;
import ro.gs1.quarkus.etcd.runtime.config.EtcdSslConfig;

public class EtcdClientChannelVertx
implements EtcdClientChannel {
    private static final Logger logger = Logger.getLogger(EtcdClientChannelVertx.class);
    private final EtcdClientConfig config;
    private final ManagedChannel channel;
    private final Vertx vertx;
    private final Object lock;
    private final String clientName;
    private String token;

    public EtcdClientChannelVertx(String clientName, EtcdClientConfig config, Vertx vertx) {
        this.config = config;
        this.vertx = vertx;
        this.clientName = clientName;
        this.lock = new Object();
        this.channel = this.createGrpcVertxClient();
    }

    private ManagedChannel createGrpcVertxClient() {
        VertxChannelBuilder vertxChannelBuilder = VertxChannelBuilder.forAddress((Vertx)this.vertx, (String)this.config.host(), (int)this.config.port());
        vertxChannelBuilder.intercept(new ClientInterceptor[]{new AuthTokenInterceptor()});
        if (this.config.sslConfig().keyStore().isEmpty() && this.config.sslConfig().trustStore().isEmpty()) {
            vertxChannelBuilder.usePlaintext();
        } else {
            vertxChannelBuilder.useSsl(event -> {
                event.setSsl(true);
                if (this.config.sslConfig().keyStore().isPresent()) {
                    event.setKeyStoreOptions(this.buildJksOptions(this.config.sslConfig().keyStore().get()));
                }
                if (this.config.sslConfig().trustStore().isPresent()) {
                    event.setTrustStoreOptions(this.buildJksOptions(this.config.sslConfig().trustStore().get()));
                }
            });
        }
        if (this.config.keepAliveTime().isPresent()) {
            vertxChannelBuilder.keepAliveTime(this.config.keepAliveTime().get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.config.keepAliveTimeout().isPresent()) {
            vertxChannelBuilder.keepAliveTimeout(this.config.keepAliveTimeout().get().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.config.keepAliveWithoutCalls().isPresent()) {
            vertxChannelBuilder.keepAliveWithoutCalls(this.config.keepAliveWithoutCalls().get().booleanValue());
        }
        if (this.config.defaultLoadBalancingPolicy().isPresent()) {
            vertxChannelBuilder.defaultLoadBalancingPolicy(this.config.defaultLoadBalancingPolicy().get());
        }
        if (this.config.maxInboundMessageSize().isPresent()) {
            vertxChannelBuilder.maxInboundMessageSize(this.config.maxInboundMessageSize().get().intValue());
        }
        if (this.config.authority().isPresent()) {
            vertxChannelBuilder.overrideAuthority(this.config.authority().get());
        }
        logger.debugv("Created GRPC Vert.x Channel for endpoint: {0}:{1}.", (Object)this.config.host(), (Object)this.config.port().toString());
        return vertxChannelBuilder.build();
    }

    private JksOptions buildJksOptions(EtcdSslConfig.Jks jks) {
        JksOptions jksOptions = new JksOptions();
        jksOptions.setPath(jks.path().toString());
        if (jks.password().isPresent()) {
            jksOptions.setPassword(jks.password().get());
        }
        if (jks.alias().isPresent()) {
            jksOptions.setAlias(jks.alias().get());
        }
        if (jks.aliasPassword().isPresent()) {
            jksOptions.setAliasPassword(jks.aliasPassword().get());
        }
        return jksOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken(Channel channel) {
        if (this.token == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.token == null) {
                    this.token = this.generateToken(channel);
                }
            }
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceTokenRefresh() {
        Object object = this.lock;
        synchronized (object) {
            this.token = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshToken(Channel channel) {
        Object object = this.lock;
        synchronized (object) {
            this.token = this.generateToken(channel);
        }
    }

    private String generateToken(Channel channel) {
        if (this.config.name().isEmpty() || this.config.password().isEmpty()) {
            return null;
        }
        MutinyAuthGrpc.MutinyAuthStub mutinyAuthStub = MutinyAuthGrpc.newMutinyStub((Channel)channel);
        Uni authenticate = mutinyAuthStub.authenticate(AuthenticateRequest.newBuilder().setName(this.config.name().get()).setPassword(this.config.password().get()).build());
        AuthenticateResponse authenticateResponse = (AuthenticateResponse)authenticate.await().atMost(this.config.authenticationTimeout().isPresent() ? this.config.authenticationTimeout().get() : Duration.ofSeconds(5L));
        return authenticateResponse.getToken();
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.channel != null) {
                this.channel.shutdownNow().awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
    }

    public KV getKVClient() {
        return new KVClient("KVClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public Lease getLeaseClient() {
        return new LeaseClient("LeaseClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public Lock getLockClient() {
        return new LockClient("LockClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public Maintenance getMaintenanceClient() {
        return new MaintenanceClient("MaintenanceClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public Watch getWatchClient() {
        return new WatchClient("WatchClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public Cluster getClusterClient() {
        return new ClusterClient("ClusterClient[" + this.clientName + "]", (Channel)this.channel, (a, b) -> b);
    }

    public String getClientName() {
        return this.clientName;
    }

    private class AuthTokenInterceptor
    implements ClientInterceptor {
        private AuthTokenInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    String generatedToken = EtcdClientChannelVertx.this.getToken(next);
                    if (generatedToken != null) {
                        Metadata.Key tokenMetadata = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                        headers.put(tokenMetadata, (Object)generatedToken);
                    }
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (status.getCode() == Status.Code.UNAUTHENTICATED && status.getDescription() != null && status.getDescription().contains("invalid auth token")) {
                                EtcdClientChannelVertx.this.refreshToken(next);
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

