/*
 * Decompiled with CFR 0.152.
 */
package ro.gs1.quarkus.etcd.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import ro.gs1.quarkus.etcd.api.EtcdClientChannel;
import ro.gs1.quarkus.etcd.runtime.EtcdClientChannelVertx;
import ro.gs1.quarkus.etcd.runtime.config.EtcdClientConfig;
import ro.gs1.quarkus.etcd.runtime.config.EtcdConfigProvider;

public class EtcdClientFactory {
    private EtcdClientFactory() {
    }

    public static EtcdClientChannel createClient(String name) {
        ArcContainer container = Arc.container();
        InstanceHandle instance = container.instance(EtcdConfigProvider.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("Unable to find the EtcdConfigProvider");
        }
        EtcdConfigProvider configProvider = (EtcdConfigProvider)instance.get();
        EtcdClientConfig config = configProvider.getConfiguration(name);
        if (config == null) {
            throw new IllegalStateException("etcd client " + name + " is missing configuration.");
        }
        Vertx vertx = (Vertx)container.instance(Vertx.class, new Annotation[0]).get();
        return new EtcdClientChannelVertx(name, config, vertx);
    }
}

