/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.csslint.CssLint;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@SupportedResourceType(value=ResourceType.CSS)
public class CssLintProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssLintProcessor.class);
    public static final String ALIAS = "cssLint";
    private String[] options;

    public CssLintProcessor setOptions(String[] options) {
        this.options = options;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            new CssLint().setOptions(this.options).validate(content);
        }
        catch (CssLintException e) {
            try {
                this.onCssLintException(e, resource);
            }
            catch (Exception ex) {
                throw new WroRuntimeException("", (Throwable)ex);
            }
        }
        catch (WroRuntimeException e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            writer.write(content);
            reader.close();
            writer.close();
        }
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected void onCssLintException(CssLintException e, Resource resource) throws Exception {
        LOG.error("The following resource: " + resource + " has " + e.getErrors().size() + " errors.", (Throwable)e);
    }
}

