/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.less.LessCss;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@SupportedResourceType(value=ResourceType.CSS)
public class LessCssProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LessCssProcessor.class);
    public static final String ALIAS = "lessCss";
    private LessCss engine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            writer.write(this.getEngine().less(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            writer.write(content);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected void onException(WroRuntimeException e) {
    }

    private LessCss getEngine() {
        if (this.engine == null) {
            this.engine = this.newLessCss();
        }
        return this.engine;
    }

    protected LessCss newLessCss() {
        return new LessCss();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

