/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.cjson.CJson;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public abstract class CJsonProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CJsonProcessor.class);
    public static final String ALIAS_PACK = "cjson-pack";
    public static final String ALIAS_UNPACK = "cjson-unpack";
    private CJson engine;

    private CJsonProcessor() {
    }

    public static CJsonProcessor packProcessor() {
        return new CJsonProcessor(){

            @Override
            protected String doProcess(String content) {
                return this.getEngine().pack(content);
            }
        };
    }

    public static CJsonProcessor unpackProcessor() {
        return new CJsonProcessor(){

            @Override
            protected String doProcess(String content) {
                return this.getEngine().unpack(content);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            writer.write(this.doProcess(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            writer.write(content);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while  applying lessCss processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected abstract String doProcess(String var1);

    protected void onException(WroRuntimeException e) {
    }

    CJson getEngine() {
        if (this.engine == null) {
            this.engine = this.newEngine();
        }
        return this.engine;
    }

    protected CJson newEngine() {
        return new CJson();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

