/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.less;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class LessCss {
    private static final Logger LOG = LoggerFactory.getLogger(LessCss.class);
    private static final String DEFAULT_LESS_JS = "less-1.1.4.min.js";
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                String SCRIPT_INIT = "init.js";
                InputStream initStream = this.getClass().getResourceAsStream("init.js");
                String SCRIPT_RUN = "run.js";
                InputStream runStream = this.getClass().getResourceAsStream("run.js");
                builder = RhinoScriptBuilder.newClientSideAwareChain().evaluateChain(initStream, "init.js").evaluateChain(this.getScriptAsStream(), DEFAULT_LESS_JS).evaluateChain(runStream, "run.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading javascript less.js", ex);
        }
        catch (Exception e) {
            LOG.error("Processing error:" + e.getMessage(), (Throwable)e);
            throw new WroRuntimeException("Processing error", (Throwable)e);
        }
    }

    protected InputStream getScriptAsStream() {
        return this.getClass().getResourceAsStream(DEFAULT_LESS_JS);
    }

    public String less(String data) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("lessify");
        try {
            String execute = "lessIt(" + WroUtil.toJSMultiLineString((String)data) + ");";
            Object result = builder.evaluate(execute, "lessIt");
            String string = String.valueOf(result);
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }
}

