/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoScriptBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RhinoScriptBuilder.class);
    private Context context;
    private ScriptableObject scope;

    private RhinoScriptBuilder() {
        this(null);
    }

    private RhinoScriptBuilder(ScriptableObject scope) {
        this.scope = this.createContext(scope);
    }

    public ScriptableObject getScope() {
        return this.scope;
    }

    private ScriptableObject createContext(ScriptableObject initialScope) {
        this.context = ContextFactory.getGlobal().enterContext();
        this.context.setOptimizationLevel(-1);
        this.context.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        this.context.setLanguageVersion(170);
        InputStream script = null;
        ScriptableObject scope = (ScriptableObject)this.context.initStandardObjects(initialScope);
        try {
            script = this.getClass().getResourceAsStream("commons.js");
            this.context.evaluateReader((Scriptable)scope, (Reader)new InputStreamReader(script), "common.js", 1, null);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Problem while evaluationg commons script.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(script);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)script);
        return scope;
    }

    public RhinoScriptBuilder addClientSideEnvironment() {
        try {
            String SCRIPT_ENV = "env.rhino.min.js";
            InputStream script = this.getClass().getResourceAsStream("env.rhino.min.js");
            this.evaluate(script, "env.rhino.min.js");
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize env.rhino script", e);
        }
    }

    public RhinoScriptBuilder addJSON() {
        try {
            String SCRIPT_ENV = "json2.min.js";
            InputStream script = this.getClass().getResourceAsStream("json2.min.js");
            this.evaluate(script, "json2.min.js");
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize json2.min.js script", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoScriptBuilder evaluateChain(InputStream stream, String sourceName) throws IOException {
        Validate.notNull((Object)stream);
        try {
            this.context.evaluateReader((Scriptable)this.scope, (Reader)new InputStreamReader(stream), sourceName, 1, null);
            RhinoScriptBuilder rhinoScriptBuilder = this;
            return rhinoScriptBuilder;
        }
        finally {
            stream.close();
        }
    }

    public RhinoScriptBuilder evaluateChain(String script, String sourceName) {
        Validate.notNull((Object)script);
        this.context.evaluateString((Scriptable)this.scope, script, sourceName, 1, null);
        return this;
    }

    public Object evaluate(InputStream stream, String sourceName) throws IOException {
        Validate.notNull((Object)stream);
        try {
            Object object = this.context.evaluateReader((Scriptable)this.scope, (Reader)new InputStreamReader(stream), sourceName, 1, null);
            return object;
        }
        catch (JavaScriptException e) {
            LOG.error("JavaScriptException occured: " + e.getMessage());
            throw e;
        }
        finally {
            stream.close();
        }
    }

    public Object evaluate(Reader reader, String sourceName) throws IOException {
        Validate.notNull((Object)reader);
        try {
            Object object = this.context.evaluateReader((Scriptable)this.scope, reader, sourceName, 1, null);
            return object;
        }
        catch (JavaScriptException e) {
            LOG.error("JavaScriptException occured: " + e.getMessage());
            throw e;
        }
        finally {
            reader.close();
        }
    }

    public Object evaluate(String script, String sourceName) {
        Validate.notNull((Object)script);
        try {
            return this.context.evaluateString((Scriptable)this.scope, script, sourceName, 1, null);
        }
        catch (JavaScriptException e) {
            LOG.error("JavaScriptException occured: " + e.getMessage());
            throw e;
        }
    }

    public static RhinoScriptBuilder newChain() {
        return new RhinoScriptBuilder();
    }

    public static RhinoScriptBuilder newChain(ScriptableObject scope) {
        return new RhinoScriptBuilder(scope);
    }

    public static RhinoScriptBuilder newClientSideAwareChain() {
        return new RhinoScriptBuilder().addClientSideEnvironment();
    }
}

