var KEYWORDS=array_to_hash("break,case,catch,const,continue,default,delete,do,else,finally,for,function,if,in,instanceof,new,return,switch,throw,try,typeof,var,void,while,with".split(",")),RESERVED_WORDS=array_to_hash("abstract,boolean,byte,char,class,debugger,double,enum,export,extends,final,float,goto,implements,import,int,interface,long,native,package,private,protected,public,short,static,super,synchronized,throws,transient,volatile".split(",")),KEYWORDS_BEFORE_EXPRESSION=array_to_hash("return,new,delete,throw,else,case".split(",")),
KEYWORDS_ATOM=array_to_hash(["false","null","true","undefined"]),OPERATOR_CHARS=array_to_hash(characters("+-*&%=<>!?|~^")),RE_HEX_NUMBER=/^0x[0-9a-f]+$/i,RE_OCT_NUMBER=/^0[0-7]+$/,RE_DEC_NUMBER=/^\d*\.?\d*(?:e[+-]?\d*(?:\d\.?|\.?\d)\d*)?$/i,OPERATORS=array_to_hash("in,instanceof,typeof,new,void,delete,++,--,+,-,!,~,&,|,^,*,/,%,>>,<<,>>>,<,>,<=,>=,==,===,!=,!==,?,=,+=,-=,/=,*=,%=,>>=,<<=,>>>=,|=,^=,&=,&&,||".split(",")),WHITESPACE_CHARS=array_to_hash(characters(" Â \n\r\tâ€‹")),PUNC_BEFORE_EXPRESSION=
array_to_hash(characters("[{}(,.;:")),PUNC_CHARS=array_to_hash(characters("[]{}(),;:")),REGEXP_MODIFIERS=array_to_hash(characters("gmsiy")),UNICODE={letter:RegExp("[\\u0041-\\u005A\\u0061-\\u007A\\u00AA\\u00B5\\u00BA\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u0523\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0621-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971\\u0972\\u097B-\\u097F\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C33\\u0C35-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D28\\u0D2A-\\u0D39\\u0D3D\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC\\u0EDD\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8B\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10D0-\\u10FA\\u10FC\\u1100-\\u1159\\u115F-\\u11A2\\u11A8-\\u11F9\\u1200-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u1676\\u1681-\\u169A\\u16A0-\\u16EA\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u1900-\\u191C\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19A9\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u2094\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2183\\u2184\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2C6F\\u2C71-\\u2C7D\\u2C80-\\u2CE4\\u2D00-\\u2D25\\u2D30-\\u2D65\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005\\u3006\\u3031-\\u3035\\u303B\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31B7\\u31F0-\\u31FF\\u3400\\u4DB5\\u4E00\\u9FC3\\uA000-\\uA48C\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA65F\\uA662-\\uA66E\\uA67F-\\uA697\\uA717-\\uA71F\\uA722-\\uA788\\uA78B\\uA78C\\uA7FB-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA90A-\\uA925\\uA930-\\uA946\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAC00\\uD7A3\\uF900-\\uFA2D\\uFA30-\\uFA6A\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"),
non_spacing_mark:RegExp("[\\u0300-\\u036F\\u0483-\\u0487\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u0610-\\u061A\\u064B-\\u065E\\u0670\\u06D6-\\u06DC\\u06DF-\\u06E4\\u06E7\\u06E8\\u06EA-\\u06ED\\u0711\\u0730-\\u074A\\u07A6-\\u07B0\\u07EB-\\u07F3\\u0816-\\u0819\\u081B-\\u0823\\u0825-\\u0827\\u0829-\\u082D\\u0900-\\u0902\\u093C\\u0941-\\u0948\\u094D\\u0951-\\u0955\\u0962\\u0963\\u0981\\u09BC\\u09C1-\\u09C4\\u09CD\\u09E2\\u09E3\\u0A01\\u0A02\\u0A3C\\u0A41\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A70\\u0A71\\u0A75\\u0A81\\u0A82\\u0ABC\\u0AC1-\\u0AC5\\u0AC7\\u0AC8\\u0ACD\\u0AE2\\u0AE3\\u0B01\\u0B3C\\u0B3F\\u0B41-\\u0B44\\u0B4D\\u0B56\\u0B62\\u0B63\\u0B82\\u0BC0\\u0BCD\\u0C3E-\\u0C40\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C62\\u0C63\\u0CBC\\u0CBF\\u0CC6\\u0CCC\\u0CCD\\u0CE2\\u0CE3\\u0D41-\\u0D44\\u0D4D\\u0D62\\u0D63\\u0DCA\\u0DD2-\\u0DD4\\u0DD6\\u0E31\\u0E34-\\u0E3A\\u0E47-\\u0E4E\\u0EB1\\u0EB4-\\u0EB9\\u0EBB\\u0EBC\\u0EC8-\\u0ECD\\u0F18\\u0F19\\u0F35\\u0F37\\u0F39\\u0F71-\\u0F7E\\u0F80-\\u0F84\\u0F86\\u0F87\\u0F90-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u102D-\\u1030\\u1032-\\u1037\\u1039\\u103A\\u103D\\u103E\\u1058\\u1059\\u105E-\\u1060\\u1071-\\u1074\\u1082\\u1085\\u1086\\u108D\\u109D\\u135F\\u1712-\\u1714\\u1732-\\u1734\\u1752\\u1753\\u1772\\u1773\\u17B7-\\u17BD\\u17C6\\u17C9-\\u17D3\\u17DD\\u180B-\\u180D\\u18A9\\u1920-\\u1922\\u1927\\u1928\\u1932\\u1939-\\u193B\\u1A17\\u1A18\\u1A56\\u1A58-\\u1A5E\\u1A60\\u1A62\\u1A65-\\u1A6C\\u1A73-\\u1A7C\\u1A7F\\u1B00-\\u1B03\\u1B34\\u1B36-\\u1B3A\\u1B3C\\u1B42\\u1B6B-\\u1B73\\u1B80\\u1B81\\u1BA2-\\u1BA5\\u1BA8\\u1BA9\\u1C2C-\\u1C33\\u1C36\\u1C37\\u1CD0-\\u1CD2\\u1CD4-\\u1CE0\\u1CE2-\\u1CE8\\u1CED\\u1DC0-\\u1DE6\\u1DFD-\\u1DFF\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2CEF-\\u2CF1\\u2DE0-\\u2DFF\\u302A-\\u302F\\u3099\\u309A\\uA66F\\uA67C\\uA67D\\uA6F0\\uA6F1\\uA802\\uA806\\uA80B\\uA825\\uA826\\uA8C4\\uA8E0-\\uA8F1\\uA926-\\uA92D\\uA947-\\uA951\\uA980-\\uA982\\uA9B3\\uA9B6-\\uA9B9\\uA9BC\\uAA29-\\uAA2E\\uAA31\\uAA32\\uAA35\\uAA36\\uAA43\\uAA4C\\uAAB0\\uAAB2-\\uAAB4\\uAAB7\\uAAB8\\uAABE\\uAABF\\uAAC1\\uABE5\\uABE8\\uABED\\uFB1E\\uFE00-\\uFE0F\\uFE20-\\uFE26]"),
space_combining_mark:RegExp("[\\u0903\\u093E-\\u0940\\u0949-\\u094C\\u094E\\u0982\\u0983\\u09BE-\\u09C0\\u09C7\\u09C8\\u09CB\\u09CC\\u09D7\\u0A03\\u0A3E-\\u0A40\\u0A83\\u0ABE-\\u0AC0\\u0AC9\\u0ACB\\u0ACC\\u0B02\\u0B03\\u0B3E\\u0B40\\u0B47\\u0B48\\u0B4B\\u0B4C\\u0B57\\u0BBE\\u0BBF\\u0BC1\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCC\\u0BD7\\u0C01-\\u0C03\\u0C41-\\u0C44\\u0C82\\u0C83\\u0CBE\\u0CC0-\\u0CC4\\u0CC7\\u0CC8\\u0CCA\\u0CCB\\u0CD5\\u0CD6\\u0D02\\u0D03\\u0D3E-\\u0D40\\u0D46-\\u0D48\\u0D4A-\\u0D4C\\u0D57\\u0D82\\u0D83\\u0DCF-\\u0DD1\\u0DD8-\\u0DDF\\u0DF2\\u0DF3\\u0F3E\\u0F3F\\u0F7F\\u102B\\u102C\\u1031\\u1038\\u103B\\u103C\\u1056\\u1057\\u1062-\\u1064\\u1067-\\u106D\\u1083\\u1084\\u1087-\\u108C\\u108F\\u109A-\\u109C\\u17B6\\u17BE-\\u17C5\\u17C7\\u17C8\\u1923-\\u1926\\u1929-\\u192B\\u1930\\u1931\\u1933-\\u1938\\u19B0-\\u19C0\\u19C8\\u19C9\\u1A19-\\u1A1B\\u1A55\\u1A57\\u1A61\\u1A63\\u1A64\\u1A6D-\\u1A72\\u1B04\\u1B35\\u1B3B\\u1B3D-\\u1B41\\u1B43\\u1B44\\u1B82\\u1BA1\\u1BA6\\u1BA7\\u1BAA\\u1C24-\\u1C2B\\u1C34\\u1C35\\u1CE1\\u1CF2\\uA823\\uA824\\uA827\\uA880\\uA881\\uA8B4-\\uA8C3\\uA952\\uA953\\uA983\\uA9B4\\uA9B5\\uA9BA\\uA9BB\\uA9BD-\\uA9C0\\uAA2F\\uAA30\\uAA33\\uAA34\\uAA4D\\uAA7B\\uABE3\\uABE4\\uABE6\\uABE7\\uABE9\\uABEA\\uABEC]"),
connector_punctuation:RegExp("[\\u005F\\u203F\\u2040\\u2054\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFF3F]")};function is_letter(a){return UNICODE.letter.test(a)}function is_digit(a){a=a.charCodeAt(0);return a>=48&&a<=57}function is_alphanumeric_char(a){return is_digit(a)||is_letter(a)}function is_unicode_combining_mark(a){return UNICODE.non_spacing_mark.test(a)||UNICODE.space_combining_mark.test(a)}function is_unicode_connector_punctuation(a){return UNICODE.connector_punctuation.test(a)}
function is_identifier_start(a){return a=="$"||a=="_"||is_letter(a)}function is_identifier_char(a){return is_identifier_start(a)||is_unicode_combining_mark(a)||is_digit(a)||is_unicode_connector_punctuation(a)||a=="â€Œ"||a=="â€"}function parse_js_number(a){if(RE_HEX_NUMBER.test(a))return parseInt(a.substr(2),16);else if(RE_OCT_NUMBER.test(a))return parseInt(a.substr(1),8);else if(RE_DEC_NUMBER.test(a))return parseFloat(a)}
function JS_Parse_Error(a,d,f,e){this.message=a;this.line=d;this.col=f;this.pos=e;try{({})()}catch(c){this.stack=c.stack}}JS_Parse_Error.prototype.toString=function(){return this.message+" (line: "+this.line+", col: "+this.col+", pos: "+this.pos+")\n\n"+this.stack};function js_error(a,d,f,e){throw new JS_Parse_Error(a,d,f,e);}function is_token(a,d,f){return a.type==d&&(f==null||a.value==f)}var EX_EOF={};
function tokenizer(a){function d(){return b.text.charAt(b.pos)}function f(z){var a=b.text.charAt(b.pos++);if(z&&!a)throw EX_EOF;a=="\n"?(b.newline_before=!0,++b.line,b.col=0):++b.col;return a}function e(a,c){var e=b.text.indexOf(a,b.pos);if(c&&e==-1)throw EX_EOF;return e}function c(a,c,e){b.regex_allowed=a=="operator"&&!HOP(UNARY_POSTFIX,c)||a=="keyword"&&HOP(KEYWORDS_BEFORE_EXPRESSION,c)||a=="punc"&&HOP(PUNC_BEFORE_EXPRESSION,c);a={type:a,value:c,line:b.tokline,col:b.tokcol,pos:b.tokpos,nlb:b.newline_before};
if(!e)a.comments_before=b.comments_before,b.comments_before=[];b.newline_before=!1;return a}function j(a){for(var c="",e=d(),b=0;e&&a(e,b++);)c+=f(),e=d();return c}function k(a){js_error(a,b.tokline,b.tokcol,b.tokpos)}function u(a){var e=!1,b=!1,f=!1,d=a==".",h=j(function(c,h){if(c=="x"||c=="X")return f?!1:f=!0;if(!f&&(c=="E"||c=="e"))return e?!1:e=b=!0;if(c=="-")return b||h==0&&!a?!0:!1;if(c=="+")return b;b=!1;return c=="."?!d&&!f?d=!0:!1:is_alphanumeric_char(c)});a&&(h=a+h);var i=parse_js_number(h);
if(isNaN(i))k("Invalid syntax: "+h);else return c("num",i)}function i(){var a=f(!0);switch(a){case "n":return"\n";case "r":return"\r";case "t":return"\t";case "b":return"";case "v":return"";case "f":return"";case "0":return"\x00";case "x":return String.fromCharCode(r(2));case "u":return String.fromCharCode(r(4));case "\n":return"";default:return a}}function r(a){for(var c=0;a>0;--a){var e=parseInt(f(!0),16);isNaN(e)&&k("Invalid hex-character pattern in string");c=c<<4|e}return c}function l(){return v("Unterminated string constant",
function(){for(var a=f(),e="";;){var b=f(!0);if(b=="\\")var d=0,h=null,b=j(function(a){if(a>="0"&&a<="7")if(h)if(h<="3"&&d<=2)return++d;else{if(h>="4"&&d<=1)return++d}else return h=a,++d;return!1}),b=d>0?String.fromCharCode(parseInt(b,8)):i();else if(b==a)break;e+=b}return c("string",e)})}function h(){f();var a=e("\n"),d;a==-1?(d=b.text.substr(b.pos),b.pos=b.text.length):(d=b.text.substring(b.pos,a),b.pos=a);return c("comment1",d,!0)}function p(){f();return v("Unterminated multiline comment",function(){var a=
e("*/",!0),d=b.text.substring(b.pos,a),f=c("comment2",d,!0);b.pos=a+2;b.line+=d.split("\n").length-1;b.newline_before=d.indexOf("\n")>=0;/^@cc_on/i.test(d)&&(warn("WARNING: at line "+b.line),warn('*** Found "conditional comment": '+d),warn("*** UglifyJS DISCARDS ALL COMMENTS.  This means your code might no longer work properly in Internet Explorer."));return f})}function q(){for(var a=!1,c="",e;(e=d())!=null;)if(a)e!="u"&&k("Expecting UnicodeEscapeSequence -- uXXXX"),e=i(),is_identifier_char(e)||
k("Unicode char: "+e.charCodeAt(0)+" is not valid in identifier"),c+=e,a=!1;else if(e=="\\")a=!0,f();else if(is_identifier_char(e))c+=f();else break;return c}function x(){return v("Unterminated regular expression",function(){for(var a=!1,e="",b,d=!1;b=f(!0);)if(a)e+="\\"+b,a=!1;else if(b=="[")d=!0,e+=b;else if(b=="]"&&d)d=!1,e+=b;else if(b=="/"&&!d)break;else b=="\\"?a=!0:e+=b;a=q();return c("regexp",[e,a])})}function s(a){function e(a){if(!d())return a;var c=a+d();return HOP(OPERATORS,c)?(f(),e(c)):
a}return c("operator",e(a||f()))}function y(){f();var a=b.regex_allowed;switch(d()){case "/":return b.comments_before.push(h()),b.regex_allowed=a,t();case "*":return b.comments_before.push(p()),b.regex_allowed=a,t()}return b.regex_allowed?x():s("/")}function v(a,e){try{return e()}catch(c){if(c===EX_EOF)k(a);else throw c;}}function t(a){if(a)return x();for(;HOP(WHITESPACE_CHARS,d());)f();b.tokline=b.line;b.tokcol=b.col;b.tokpos=b.pos;a=d();if(!a)return c("eof");if(is_digit(a))return u();if(a=='"'||
a=="'")return l();if(HOP(PUNC_CHARS,a))return c("punc",f());if(a==".")return f(),is_digit(d())?u("."):c("punc",".");if(a=="/")return y();if(HOP(OPERATOR_CHARS,a))return s();if(a=="\\"||is_identifier_start(a))return a=q(),!HOP(KEYWORDS,a)?c("name",a):HOP(OPERATORS,a)?c("operator",a):HOP(KEYWORDS_ATOM,a)?c("atom",a):c("keyword",a);k("Unexpected character '"+a+"'")}var b={text:a.replace(/\r\n?|[\n\u2028\u2029]/g,"\n").replace(/^\uFEFF/,""),pos:0,tokpos:0,line:0,tokline:0,col:0,tokcol:0,newline_before:!1,
regex_allowed:!1,comments_before:[]};t.context=function(a){a&&(b=a);return b};return t}
var UNARY_PREFIX=array_to_hash("typeof,void,delete,--,++,!,~,-,+".split(",")),UNARY_POSTFIX=array_to_hash(["--","++"]),ASSIGNMENT=function(a,d,f){for(;f<a.length;)d[a[f]]=a[f].substr(0,a[f].length-1),f++;return d}("+=,-=,/=,*=,%=,>>=,<<=,>>>=,|=,^=,&=".split(","),{"=":!0},0),PRECEDENCE=function(a,d){for(var f=0,e=1;f<a.length;++f,++e)for(var c=a[f],j=0;j<c.length;++j)d[c[j]]=e;return d}([["||"],["&&"],["|"],["^"],["&"],["==","===","!=","!=="],"<,>,<=,>=,in,instanceof".split(","),[">>","<<",">>>"],
["+","-"],["*","/","%"]],{}),STATEMENTS_WITH_LABELS=array_to_hash(["for","do","while","switch"]),ATOMIC_START_TOKEN=array_to_hash(["atom","num","string","regexp","name"]);function NodeWithToken(a,d,f){this.name=a;this.start=d;this.end=f}NodeWithToken.prototype.toString=function(){return this.name};
function parse(a,d,f){function e(a,c){return is_token(g.token,a,c)}function c(){g.prev=g.token;g.peeked?(g.token=g.peeked,g.peeked=null):g.token=g.input();return g.token}function j(a,c,e,b){var d=g.input.context();js_error(a,c!=null?c:d.tokline,e!=null?e:d.tokcol,b!=null?b:d.tokpos)}function k(a){if(a==null)a=g.token;j("Unexpected token: "+a.type+" ("+a.value+")",a.line,a.col)}function u(a,b){if(e(a,b))return c();var d=g.token;j("Unexpected token "+g.token.type+", expected "+a,d.line,d.col)}function i(a){return u("punc",
a)}function r(){return!d&&(g.token.nlb||e("eof")||e("punc","}"))}function l(){e("punc",";")?c():r()||k()}function h(){return slice(arguments)}function p(){i("(");var a=m();i(")");return a}function q(a){return f?function(){var c=g.token,e=a.apply(this,arguments),b=e,d=e[0],c=d instanceof NodeWithToken?d:new NodeWithToken(d,c,g.prev);b[0]=c;return e}:a}function x(a){g.labels.push(a);var c=g.token,e=n();d&&!HOP(STATEMENTS_WITH_LABELS,e[0])&&k(c);g.labels.pop();return h("label",a,e)}function s(){return h("stat",
prog1(m,l))}function y(a){var b;r()||(b=e("name")?g.token.value:null);b!=null?(c(),member(b,g.labels)||j("Label "+b+" without matching loop or statement")):g.in_loop==0&&j(a+" not inside a loop or switch");l();return h(a,b)}function v(){i("(");var a=null;if(!e("punc",";")&&(a=e("keyword","var")?(c(),G(!0)):m(!0,!0),e("operator","in"))){var b=a[0]=="var"?h("name",a[1][0]):a;c();var d=m();i(")");return h("for-in",a,b,d,w(n))}i(";");b=e("punc",";")?null:m();i(";");d=e("punc",")")?null:m();i(")");return h("for",
a,b,d,w(n))}function t(){var a=p(),b=n(),d;e("keyword","else")&&(c(),d=n());return h("if",a,b,d)}function b(){i("{");for(var a=[];!e("punc","}");)e("eof")&&k(),a.push(n());c();return a}function z(){var a=b(),d,f;if(e("keyword","catch"))c(),i("("),e("name")||j("Name expected"),d=g.token.value,c(),i(")"),d=[d,b()];e("keyword","finally")&&(c(),f=b());!d&&!f&&j("Missing catch/finally blocks");return h("try",a,d,f)}function F(a){for(var b=[];;){e("name")||k();var d=g.token.value;c();e("operator","=")?
(c(),b.push([d,m(!1,a)])):b.push([d]);if(!e("punc",","))break;c()}return b}function G(a){return h("var",F(a))}function L(){return h("const",F())}function A(a,b,d){for(var g=!0,f=[];!e("punc",a);){g?g=!1:i(",");if(b&&e("punc",a))break;e("punc",",")&&d?f.push(["atom","undefined"]):f.push(m(!1))}c();return f}function C(){switch(g.token.type){case "name":case "operator":case "keyword":case "atom":return prog1(g.token.value,c);default:k()}}function o(a,b){if(e("punc","."))return c(),o(h("dot",a,C()),b);
if(e("punc","["))return c(),o(h("sub",a,prog1(m,curry(i,"]"))),b);return b&&e("punc","(")?(c(),o(h("call",a,A(")")),!0)):a}function B(a){if(e("operator")&&HOP(UNARY_PREFIX,g.token.value))return H("unary-prefix",prog1(g.token.value,c),B(a));for(a=I(a);e("operator")&&HOP(UNARY_POSTFIX,g.token.value)&&!g.token.nlb;)a=H("unary-postfix",g.token.value,a),c();return a}function H(a,c,b){(c=="++"||c=="--")&&!J(b)&&j("Invalid use of "+c+" operator");return h(a,c,b)}function D(a,b,d){var f=e("operator")?g.token.value:
null;f&&f=="in"&&d&&(f=null);var i=f!=null?PRECEDENCE[f]:null;return i!=null&&i>b?(c(),i=D(B(!0),i,d),D(h("binary",f,a,i),b,d)):a}function J(a){if(!d)return!0;switch(a[0]){case "dot":case "sub":case "new":case "call":return!0;case "name":return a[1]!="this"}}function K(a){var b;b=D(B(!0),0,a);if(e("operator","?")){c();var d=m(!1);i(":");b=h("conditional",b,d,m(!1,a))}d=g.token.value;if(e("operator")&&HOP(ASSIGNMENT,d)){if(J(b))return c(),h("assign",ASSIGNMENT[d],b,K(a));j("Invalid assignment")}return b}
function w(a){try{return++g.in_loop,a()}finally{--g.in_loop}}var g={input:typeof a=="string"?tokenizer(a,!0):a,token:null,prev:null,peeked:null,in_function:0,in_loop:0,labels:[]};g.token=c();var n=q(function(){if(e("operator","/"))g.peeked=null,g.token=g.input(!0);switch(g.token.type){case "num":case "string":case "regexp":case "operator":case "atom":return s();case "name":return is_token(g.peeked||(g.peeked=g.input()),"punc",":")?x(prog1(g.token.value,c,c)):s();case "punc":switch(g.token.value){case "{":return h("block",
b());case "[":case "(":return s();case ";":return c(),h("block");default:k()}case "keyword":switch(prog1(g.token.value,c)){case "break":return y("break");case "continue":return y("continue");case "debugger":return l(),h("debugger");case "do":return function(a){u("keyword","while");return h("do",prog1(p,l),a)}(w(n));case "for":return v();case "function":return E(!0);case "if":return t();case "return":return g.in_function==0&&j("'return' outside of function"),h("return",e("punc",";")?(c(),null):r()?
null:prog1(m,l));case "switch":return h("switch",p(),M());case "throw":return h("throw",prog1(m,l));case "try":return z();case "var":return prog1(G,l);case "const":return prog1(L,l);case "while":return h("while",p(),w(n));case "with":return h("with",p(),n());default:k()}}}),E=q(function(a){var d=e("name")?prog1(g.token.value,c):null;a&&!d&&k();i("(");return h(a?"defun":"function",d,function(a,b){for(;!e("punc",")");)a?a=!1:i(","),e("name")||k(),b.push(g.token.value),c();c();return b}(!0,[]),function(){++g.in_function;
var a=g.in_loop;g.in_loop=0;var c=b();--g.in_function;g.in_loop=a;return c}())}),M=curry(w,function(){i("{");for(var a=[],b=null;!e("punc","}");)e("eof")&&k(),e("keyword","case")?(c(),b=[],a.push([m(),b]),i(":")):e("keyword","default")?(c(),i(":"),b=[],a.push([null,b])):(b||k(),b.push(n()));c();return a}),I=q(function(a){if(e("operator","new")){c();var a=I(!1),b;e("punc","(")?(c(),b=A(")")):b=[];return o(h("new",a,b),!0)}if(e("punc")){switch(g.token.value){case "(":return c(),o(prog1(m,curry(i,")")),
a);case "[":return c(),o(h("array",A("]",!d,!0)),a);case "{":c();b=o;var f;f=!0;for(var j=[];!e("punc","}");){f?f=!1:i(",");if(!d&&e("punc","}"))break;var n=g.token.type,l;a:{switch(g.token.type){case "num":case "string":l=prog1(g.token.value,c);break a}l=C()}n=="name"&&(l=="get"||l=="set")&&!e("punc",":")?j.push([C(),E(!1),l]):(i(":"),j.push([l,m(!1)]))}c();f=h("object",j);return b(f,a)}k()}if(e("keyword","function"))return c(),o(E(!1),a);if(HOP(ATOMIC_START_TOKEN,g.token.type))return b=g.token.type==
"regexp"?h("regexp",g.token.value[0],g.token.value[1]):h(g.token.type,g.token.value),o(prog1(b,c),a);k()}),m=q(function(a,b){arguments.length==0&&(a=!0);var d=K(b);return a&&e("punc",",")?(c(),h("seq",d,m(!0,b))):d});return h("toplevel",function(a){for(;!e("eof");)a.push(n());return a}([]))}function curry(a){var d=slice(arguments,1);return function(){return a.apply(this,d.concat(slice(arguments)))}}
function prog1(a){a instanceof Function&&(a=a());for(var d=1,f=arguments.length;--f>0;++d)arguments[d]();return a}function array_to_hash(a){for(var d={},f=0;f<a.length;++f)d[a[f]]=!0;return d}function slice(a,d){return Array.prototype.slice.call(a,d||0)}function characters(a){return a.split("")}function member(a,d){for(var f=d.length;--f>=0;)if(d[f]===a)return!0;return!1}function HOP(a,d){return Object.prototype.hasOwnProperty.call(a,d)}var warn=function(){};exports.tokenizer=tokenizer;
exports.parse=parse;exports.slice=slice;exports.curry=curry;exports.member=member;exports.array_to_hash=array_to_hash;exports.PRECEDENCE=PRECEDENCE;exports.KEYWORDS_ATOM=KEYWORDS_ATOM;exports.RESERVED_WORDS=RESERVED_WORDS;exports.KEYWORDS=KEYWORDS;exports.ATOMIC_START_TOKEN=ATOMIC_START_TOKEN;exports.OPERATORS=OPERATORS;exports.is_alphanumeric_char=is_alphanumeric_char;exports.set_logger=function(a){warn=a};var jsp=require("./parse-js"),slice=jsp.slice,member=jsp.member,PRECEDENCE=jsp.PRECEDENCE,OPERATORS=jsp.OPERATORS;
function ast_walker(){function a(a){return[this[0],MAP(a,function(a){var g=[a[0]];a.length>1&&(g[1]=c(a[1]));return g})]}function b(a){var b=[this[0]];a!=null&&b.push(MAP(a,c));return b}function c(a){if(a==null)return null;try{h.push(a);var c=a[0],f=d[c];if(f){var b=f.apply(a,a.slice(1));if(b!=null)return b}f=e[c];return f.apply(a,a.slice(1))}finally{h.pop()}}var e={string:function(a){return[this[0],a]},num:function(a){return[this[0],a]},name:function(a){return[this[0],a]},toplevel:function(a){return[this[0],
MAP(a,c)]},block:b,splice:b,"var":a,"const":a,"try":function(a,b,f){return[this[0],MAP(a,c),b!=null?[b[0],MAP(b[1],c)]:null,f!=null?MAP(f,c):null]},"throw":function(a){return[this[0],c(a)]},"new":function(a,b){return[this[0],c(a),MAP(b,c)]},"switch":function(a,b){return[this[0],c(a),MAP(b,function(a){return[a[0]?c(a[0]):null,MAP(a[1],c)]})]},"break":function(a){return[this[0],a]},"continue":function(a){return[this[0],a]},conditional:function(a,b,f){return[this[0],c(a),c(b),c(f)]},assign:function(a,
b,f){return[this[0],a,c(b),c(f)]},dot:function(a){return[this[0],c(a)].concat(slice(arguments,1))},call:function(a,b){return[this[0],c(a),MAP(b,c)]},"function":function(a,b,f){return[this[0],a,b.slice(),MAP(f,c)]},defun:function(a,b,f){return[this[0],a,b.slice(),MAP(f,c)]},"if":function(a,b,f){return[this[0],c(a),c(b),c(f)]},"for":function(a,b,f,d){return[this[0],c(a),c(b),c(f),c(d)]},"for-in":function(a,b,f,d){return[this[0],c(a),c(b),c(f),c(d)]},"while":function(a,b){return[this[0],c(a),c(b)]},
"do":function(a,b){return[this[0],c(a),c(b)]},"return":function(a){return[this[0],c(a)]},binary:function(a,b,f){return[this[0],a,c(b),c(f)]},"unary-prefix":function(a,b){return[this[0],a,c(b)]},"unary-postfix":function(a,b){return[this[0],a,c(b)]},sub:function(a,b){return[this[0],c(a),c(b)]},object:function(a){return[this[0],MAP(a,function(a){return a.length==2?[a[0],c(a[1])]:[a[0],c(a[1]),a[2]]})]},regexp:function(a,b){return[this[0],a,b]},array:function(a){return[this[0],MAP(a,c)]},stat:function(a){return[this[0],
c(a)]},seq:function(){return[this[0]].concat(MAP(slice(arguments),c))},label:function(a,b){return[this[0],a,c(b)]},"with":function(a,b){return[this[0],c(a),c(b)]},atom:function(a){return[this[0],a]}},d={},h=[];return{walk:c,with_walkers:function(a,b){var c={},i;for(i in a)HOP(a,i)&&(c[i]=d[i],d[i]=a[i]);var n=b();for(i in c)HOP(c,i)&&(c[i]?d[i]=c[i]:delete d[i]);return n},parent:function(){return h[h.length-2]},stack:function(){return h}}}
function Scope(a){this.names={};this.mangled={};this.rev_mangled={};this.cname=-1;this.refs={};this.uses_eval=this.uses_with=!1;this.parent=a;this.children=[];a?(this.level=a.level+1,a.children.push(this)):this.level=0}var base54=function(){return function(a){var b="";do b="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_".charAt(a%54)+b,a=Math.floor(a/54);while(a>0);return b}}();
Scope.prototype={has:function(a){for(var b=this;b;b=b.parent)if(HOP(b.names,a))return b},has_mangled:function(a){for(var b=this;b;b=b.parent)if(HOP(b.rev_mangled,a))return b},toJSON:function(){return{names:this.names,uses_eval:this.uses_eval,uses_with:this.uses_with}},next_mangled:function(){for(;;){var a=base54(++this.cname),b;b=this.has_mangled(a);if(!(b&&this.refs[b.rev_mangled[a]]===b)&&(b=this.has(a),(!b||!(b!==this&&this.refs[a]===b&&!b.has_mangled(a)))&&!(HOP(this.refs,a)&&this.refs[a]==null)&&
is_identifier(a)))return a}},set_mangle:function(a,b){this.rev_mangled[b]=a;return this.mangled[a]=b},get_mangled:function(a,b){if(this.uses_eval||this.uses_with)return a;var c=this.has(a);return!c?a:HOP(c.mangled,a)?c.mangled[a]:!b?a:c.set_mangle(a,c.next_mangled())},references:function(a){return a&&!this.parent||this.uses_with||this.uses_eval||this.refs[a]},define:function(a,b){if(a!=null){if(b=="var"||!HOP(this.names,a))this.names[a]=b||"var";return a}}};
function ast_add_scope(a){function b(a){d=new Scope(d);a=d.body=a();a.scope=d;d=d.parent;return a}function c(a,c,n){var m=this[0]=="defun";return[this[0],m?d.define(a,"defun"):a,c,b(function(){m||d.define(a,"lambda");MAP(c,function(a){d.define(a,"arg")});return MAP(n,g)})]}function e(a){return function(b){MAP(b,function(n){d.define(n[0],a);n[1]&&(d.refs[n[0]]=!0)})}}var d=null,h=ast_walker(),g=h.walk,k=[];return b(function(){function b(a,c){for(c=a.children.length;--c>=0;)b(a.children[c]);for(c in a.refs)if(HOP(a.refs,
c))for(var d=a.has(c),l=a;l;l=l.parent)if(l.refs[c]=d,l===d)break}var i=h.with_walkers({"function":c,defun:c,label:function(a){d.define(a,"label")},"break":function(a){a&&(d.refs[a]=!0)},"continue":function(a){a&&(d.refs[a]=!0)},"with":function(){for(var a=d;a;a=a.parent)a.uses_with=!0},"var":e("var"),"const":e("const"),"try":function(a,b,c){if(b!=null)return[this[0],MAP(a,g),[d.define(b[0],"catch"),MAP(b[1],g)],c!=null?MAP(c,g):null]},name:function(a){a=="eval"&&k.push(d);d.refs[a]=!0}},function(){return g(a)});
MAP(k,function(a){if(!a.has("eval"))for(;a;)a.uses_eval=!0,a=a.parent});b(d);return i})}
function ast_mangle(a,b){function c(a,n){return!b.toplevel&&!f.parent?a:b.except&&member(a,b.except)?a:f.get_mangled(a,n)}function e(a,b,m){var r=this[0]=="defun",l;a&&(r?a=c(a):(l={},!f.uses_eval&&!f.uses_with?a=l[a]=f.next_mangled():l[a]=a));m=d(m.scope,function(){b=MAP(b,function(a){return c(a)});return MAP(m,k)},l);return[this[0],a,b,m]}function d(a,b,m){var d=f;f=a;if(m)for(var l in m)HOP(m,l)&&a.set_mangle(l,m[l]);for(l in a.names)HOP(a.names,l)&&c(l,!0);b=b();b.scope=a;f=d;return b}function h(a){return[this[0],
MAP(a,function(a){return[c(a[0]),k(a[1])]})]}var g=ast_walker(),k=g.walk,f,b=b||{};return g.with_walkers({"function":e,defun:function(){var a=e.apply(this,arguments);switch(g.parent()[0]){case "toplevel":case "function":case "defun":return MAP.at_top(a)}return a},label:function(a,b){return[this[0],c(a),k(b)]},"break":function(a){if(a)return[this[0],c(a)]},"continue":function(a){if(a)return[this[0],c(a)]},"var":h,"const":h,name:function(a){var n;b.defines&&(n=!f.has(a)&&HOP(b.defines,a)?b.defines[a]:
null);return n||[this[0],c(a)]},"try":function(a,b,m){return[this[0],MAP(a,k),b!=null?[c(b[0]),MAP(b[1],k)]:null,m!=null?MAP(m,k):null]},toplevel:function(a){var b=this;return d(b.scope,function(){return[b[0],MAP(a,k)]})}},function(){return k(ast_add_scope(a))})}var warn=function(){};function best_of(a,b){return gen_code(a).length>gen_code(b[0]=="stat"?b[1]:b).length?b:a}function last_stat(a){return a[0]=="block"&&a[1]&&a[1].length>0?a[1][a[1].length-1]:a}
function aborts(a){if(a)switch(last_stat(a)[0]){case "return":case "break":case "continue":case "throw":return!0}}
function boolean_expr(a){return a[0]=="unary-prefix"&&member(a[1],["!","delete"])||a[0]=="binary"&&member(a[1],"in,instanceof,==,!=,===,!==,<,<=,>=,>".split(","))||a[0]=="binary"&&member(a[1],["&&","||"])&&boolean_expr(a[2])&&boolean_expr(a[3])||a[0]=="conditional"&&boolean_expr(a[2])&&boolean_expr(a[3])||a[0]=="assign"&&a[1]===!0&&boolean_expr(a[3])||a[0]=="seq"&&boolean_expr(a[a.length-1])}
function make_conditional(a,b,c){return when_constant(a,function(a,d){warn_unreachable(d?c:b);return d?b:c},function(){return a[0]=="unary-prefix"&&a[1]=="!"?c?["conditional",a[2],c,b]:["binary","||",a[2],b]:c?["conditional",a,b,c]:["binary","&&",a,b]})}function empty(a){return!a||a[0]=="block"&&(!a[1]||a[1].length==0)}function is_string(a){return a[0]=="string"||a[0]=="unary-prefix"&&a[1]=="typeof"||a[0]=="binary"&&a[1]=="+"&&(is_string(a[2])||is_string(a[3]))}
var when_constant=function(){function a(c){switch(c[0]){case "string":case "num":return c[1];case "name":case "atom":switch(c[1]){case "true":return!0;case "false":return!1}break;case "unary-prefix":switch(c[1]){case "!":return!a(c[2]);case "typeof":return typeof a(c[2]);case "~":return~a(c[2]);case "-":return-a(c[2]);case "+":return+a(c[2])}break;case "binary":var e=c[2],d=c[3];switch(c[1]){case "&&":return a(e)&&a(d);case "||":return a(e)||a(d);case "|":return a(e)|a(d);case "&":return a(e)&a(d);
case "^":return a(e)^a(d);case "+":return a(e)+a(d);case "*":return a(e)*a(d);case "/":return a(e)/a(d);case "-":return a(e)-a(d);case "<<":return a(e)<<a(d);case ">>":return a(e)>>a(d);case ">>>":return a(e)>>>a(d);case "==":return a(e)==a(d);case "===":return a(e)===a(d);case "!=":return a(e)!=a(d);case "!==":return a(e)!==a(d);case "<":return a(e)<a(d);case "<=":return a(e)<=a(d);case ">":return a(e)>a(d);case ">=":return a(e)>=a(d);case "in":return a(e)in a(d);case "instanceof":return a(e)instanceof
a(d)}}throw b;}var b={};return function(c,e,d){try{var h=a(c),g;switch(typeof h){case "string":g=["string",h];break;case "number":g=["num",h];break;case "boolean":g=["name",String(h)];break;default:throw Error("Can't handle constant of type: "+typeof h);}return e.call(c,g,h)}catch(k){if(k===b){if(c[0]=="binary"&&(c[1]=="==="||c[1]=="!==")&&(is_string(c[2])&&is_string(c[3])||boolean_expr(c[2])&&boolean_expr(c[3])))c[1]=c[1].substr(0,2);else if(d&&c[0]=="binary"&&(c[1]=="||"||c[1]=="&&"))try{var f=
a(c[2]),c=c[1]=="&&"&&(f?c[3]:f)||c[1]=="||"&&(f?f:c[3])||c}catch(i){}return d?d.call(c,c):null}else throw k;}}}();function warn_unreachable(a){empty(a)||warn("Dropping unreachable code: "+gen_code(a,!0))}
function prepare_ifs(a){function b(a){for(var a=MAP(a,h),c=0;c<a.length;++c){var d=a[c];if(d[0]=="if"&&(!d[3]||!h(d[3]))){var e=h(d[2]);if(aborts(e)){var n=h(d[1]),m=a.slice(c+1),m=m.length==1?m[0]:["block",m],a=a.slice(0,c).concat([[d[0],n,e,m]]);return b(a)}}}return a}function c(a,c,d){d=b(d);return[this[0],a,c,d]}function e(a){return[this[0],a!=null?b(a):null]}var d=ast_walker(),h=d.walk;return d.with_walkers({defun:c,"function":c,block:e,splice:e,toplevel:function(a){return[this[0],b(a)]},"try":function(a,
c,d){return[this[0],b(a),c!=null?[c[0],b(c[1])]:null,d!=null?b(d):null]}},function(){return h(a)})}
function for_side_effects(a,b){function c(){throw f;}function e(){throw i;}function d(){return b.call(this,this,g,c,e)}function h(a){if(a=="++"||a=="--")return d.apply(this,arguments)}var g=ast_walker(),k=g.walk,f={},i={};return g.with_walkers({"try":d,"throw":d,"return":d,"new":d,"switch":d,"break":d,"continue":d,assign:d,call:d,"if":d,"for":d,"for-in":d,"while":d,"do":d,"return":d,"unary-prefix":h,"unary-postfix":h,defun:d},function(){for(;;)try{k(a);break}catch(b){if(b===f)break;if(b!==i)throw b;
}})}
function ast_lift_variables(a){function b(a,b){var c=d;d=b;var a=MAP(a,e),f={},i=MAP(b.names,function(a,c){if(a!="var")return MAP.skip;if(!b.references(c))return MAP.skip;f[c]=!0;return[c]});i.length>0&&(for_side_effects(["block",a],function(a,b,c,d){if(a[0]=="assign"&&a[1]===!0&&a[2][0]=="name"&&HOP(f,a[2][1])){for(var e=i.length;--e>=0;)if(i[e][0]==a[2][1]){i[e][1]&&c();i[e][1]=a[3];i.push(i.splice(e,1)[0]);break}a=b.parent();a[0]=="seq"?(b=a[2],b.unshift(0,a.length),a.splice.apply(a,b)):a[0]=="stat"?
a.splice(0,a.length,"block"):c();d()}c()}),a.unshift(["var",i]));d=c;return a}var c=ast_walker(),e=c.walk,d;return c.with_walkers({"function":function(a,c,d){for(var f=c.length;--f>=0&&!d.scope.references(c[f]);)c.pop();d.scope.references(a)||(a=null);return[this[0],a,c,b(d,d.scope)]},defun:function(a,c,e){if(!d.references(a))return MAP.skip;for(var f=c.length;--f>=0&&!e.scope.references(c[f]);)c.pop();return[this[0],a,c,b(e,e.scope)]},"var":function(a){for(var b=null,d=a.length;--d>=0;){var e=a[d];
e[1]&&(e=["assign",!0,["name",e[0]],e[1]],b=b==null?e:["seq",e,b])}return b==null?c.parent()[0]=="for-in"?["name",a[0][0]]:MAP.skip:["stat",b]},toplevel:function(a){return[this[0],b(a,this.scope)]}},function(){return e(ast_add_scope(a))})}
function ast_squeeze(a,b){function c(a){var d=["unary-prefix","!",a];switch(a[0]){case "unary-prefix":return a[1]=="!"&&boolean_expr(a[2])?a[2]:d;case "seq":return a=slice(a),a[a.length-1]=c(a[a.length-1]),a;case "conditional":return best_of(d,["conditional",a[1],c(a[2]),c(a[3])]);case "binary":var e=a[1],l=a[2],a=a[3];if(!b.keep_comps)switch(e){case "<=":return["binary",">",l,a];case "<":return["binary",">=",l,a];case ">=":return["binary","<",l,a];case ">":return["binary","<=",l,a]}switch(e){case "==":return["binary",
"!=",l,a];case "!=":return["binary","==",l,a];case "===":return["binary","!==",l,a];case "!==":return["binary","===",l,a];case "&&":return best_of(d,["binary","||",c(l),c(a)]);case "||":return best_of(d,["binary","&&",c(l),c(a)])}}return d}function e(a,b){var c=i;i=a;var d=b();d.scope=a;i=c;return d}function d(a,b,c){var d=this[0]=="defun",c=e(c.scope,function(){var b=h(c,"lambda");!d&&a&&!i.references(a)&&(a=null);return b});return[this[0],a,b,c]}function h(a){a=MAP(a,f);a=a.reduce(function(a,b){b[0]==
"block"?b[1]&&a.push.apply(a,b[1]):a.push(b);return a},[]);a=function(b,c){a.forEach(function(a){c&&(a[0]=="var"&&c[0]=="var"||a[0]=="const"&&c[0]=="const")?c[1]=c[1].concat(a[1]):(b.push(a),c=a)});return b}([]);b.dead_code&&(a=function(c,d){a.forEach(function(a){d?a[0]=="function"||a[0]=="defun"?c.push(a):a[0]=="var"||a[0]=="const"?(b.no_warnings||warn("Variables declared in unreachable code"),a[1]=MAP(a[1],function(a){a[1]&&!b.no_warnings&&warn_unreachable(["assign",!0,["name",a[0]],a[1]]);return[a[0]]}),
c.push(a)):b.no_warnings||warn_unreachable(a):(c.push(a),member(a[0],["return","throw","break","continue"])&&(d=!0))});return c}([]));b.make_seqs&&(a=function(b,c){a.forEach(function(a){c&&c[0]=="stat"&&a[0]=="stat"?c[1]=["seq",c[1],a[1]]:(b.push(a),c=a)});b.length>=2&&b[b.length-2][0]=="stat"&&(b[b.length-1][0]=="return"||b[b.length-1][0]=="throw")&&b[b.length-1][1]&&b.splice(b.length-2,2,[b[b.length-1][0],["seq",b[b.length-2][1],b[b.length-1][1]]]);return b}([]));return a}function g(a,b,d){a=f(a);
b=f(b);d=f(d);empty(b)?(a=c(a),b=d,d=null):empty(d)?d=null:function(){var e=gen_code(a),f=c(a);gen_code(f).length<e.length&&(e=b,b=d,d=e,a=f)}();if(empty(d)&&empty(b))return["stat",a];var e=["if",a,b,d];b[0]=="if"&&empty(b[3])&&empty(d)?e=best_of(e,f(["if",["binary","&&",a,b[1]],b[2]])):b[0]=="stat"?d?d[0]=="stat"&&(e=best_of(e,["stat",make_conditional(a,b[1],d[1])])):e=best_of(e,["stat",make_conditional(a,b[1])]):d&&b[0]==d[0]&&(b[0]=="return"||b[0]=="throw")&&b[1]&&d[1]?e=best_of(e,[b[0],make_conditional(a,
b[1],d[1])]):d&&aborts(b)?(e=[["if",a,b]],d[0]=="block"?d[1]&&(e=e.concat(d[1])):e.push(d),e=f(["block",e])):b&&aborts(d)&&(e=[["if",c(a),d]],b[0]=="block"?b[1]&&(e=e.concat(b[1])):e.push(b),e=f(["block",e]));return e}var b=defaults(b,{make_seqs:!0,dead_code:!0,keep_comps:!0,no_warnings:!1}),k=ast_walker(),f=k.walk,i;return k.with_walkers({sub:function(a,b){if(b[0]=="string"){var c=b[1];if(is_identifier(c))return["dot",f(a),c];else if(/^[1-9][0-9]*$/.test(c)||c==="0")return["sub",f(a),["num",parseInt(c,
10)]]}},"if":function(a,b,c){return when_constant(a,function(a,d){return d?(warn_unreachable(c),b):(warn_unreachable(b),c)},function(){return g(a,b,c)})},toplevel:function(a){return["toplevel",e(this.scope,function(){return h(a)})]},"switch":function(a,b){var c=b.length-1;return["switch",f(a),MAP(b,function(a,b){var d=h(a[1]);if(b==c&&d.length>0){var e=d[d.length-1];e[0]=="break"&&!e[1]&&d.pop()}return[a[0]?f(a[0]):null,d]})]},"function":d,defun:d,block:function(a){if(a)return a=["block",h(a)],a!=
null&&a[0]=="block"&&a[1]&&(a[1].length==1?a=a[1][0]:a[1].length==0&&(a=["block"])),a},binary:function(a,b,c){return when_constant(["binary",a,f(b),f(c)],function(a){return best_of(f(a),this)},function(){return this})},conditional:function(a,b,c){return make_conditional(f(a),f(b),f(c))},"try":function(a,b,c){return["try",h(a),b!=null?[b[0],h(b[1])]:null,c!=null?h(c):null]},"unary-prefix":function(a,b){var b=f(b),d=["unary-prefix",a,b];a=="!"&&(d=best_of(d,c(b)));return when_constant(d,function(a){return f(a)},
function(){return d})},name:function(a){switch(a){case "true":return["unary-prefix","!",["num",0]];case "false":return["unary-prefix","!",["num",1]]}},"while":function(a,b){return when_constant(a,function(a,c){return c?["for",null,null,null,f(b)]:(warn_unreachable(b),["block"])})}},function(){for(var b=0;b<2;++b)a=prepare_ifs(a),a=ast_add_scope(a),a=f(a);return a})}var DOT_CALL_NO_PARENS=jsp.array_to_hash("name,array,object,string,dot,sub,call,regexp".split(","));
function make_string(a,b){var c=0,e=0,a=a.replace(/[\\\b\f\n\r\t\x22\x27\u2028\u2029]/g,function(a){switch(a){case "\\":return"\\\\";case "":return"\\b";case "":return"\\f";case "\n":return"\\n";case "\r":return"\\r";case "\t":return"\\t";case "â€¨":return"\\u2028";case "â€©":return"\\u2029";case '"':return++c,'"';case "'":return++e,"'"}return a});b&&(a=to_ascii(a));return c>e?"'"+a.replace(/\x27/g,"\\'")+"'":'"'+a.replace(/\x22/g,'\\"')+'"'}
function to_ascii(a){return a.replace(/[\u0080-\uffff]/g,function(a){for(a=a.charCodeAt(0).toString(16);a.length<4;)a="0"+a;return"\\u"+a})}var SPLICE_NEEDS_BRACKETS=jsp.array_to_hash("if,while,do,for,for-in,with".split(","));
function gen_code(a,b){function c(a){a=make_string(a,b.ascii_only);b.inline_script&&(a=a.replace(/<\x2fscript([>/\t\n\f\r ])/gi,"<\\/script$1"));return a}function e(a){a=a.toString();b.ascii_only&&(a=to_ascii(a));return a}function d(a){a==null&&(a="");p&&(a=repeat_string(" ",b.indent_start+u*b.indent_level)+a);return a}function h(a,b){b==null&&(b=1);u+=b;try{return a.apply(null,slice(arguments,1))}finally{u-=b}}function g(a){if(p)return a.join(" ");for(var b=[],c=0;c<a.length;++c){var d=a[c+1];b.push(a[c]);
d&&(/[a-z0-9_\x24]$/i.test(a[c].toString())&&/^[a-z0-9_\x24]/i.test(d.toString())||/[\+\-]$/.test(a[c].toString())&&/^[\+\-]/.test(d.toString()))&&b.push(" ")}return b.join("")}function k(a){return a.join(","+v)}function f(a){for(var b=j(a),c=1;c<arguments.length;++c){var d=arguments[c];if(d instanceof Function&&d(a)||a[0]==d)return"("+b+")"}return b}function i(a){if(a.length==1)return a[0];if(a.length==2){var b=a[1],a=a[0];return a.length<=b.length?a:b}return i([a[0],i(a.slice(1))])}function n(a){if(a[0]==
"function"||a[0]=="object")for(var b=slice(t.stack()),c=b.pop(),d=b.pop();d;){if(d[0]=="stat")return!0;if((d[0]=="seq"||d[0]=="call"||d[0]=="dot"||d[0]=="sub"||d[0]=="conditional")&&d[1]===c||(d[0]=="binary"||d[0]=="assign"||d[0]=="unary-postfix")&&d[2]===c)c=d,d=b.pop();else return!1}return!HOP(DOT_CALL_NO_PARENS,a[0])}function m(a){var b=a.toString(10),c=[b.replace(/^0\./,".")],d;Math.floor(a)===a?(c.push("0x"+a.toString(16).toLowerCase(),"0"+a.toString(8)),(d=/^(.*?)(0+)$/.exec(a))&&c.push(d[1]+
"e"+d[2].length)):(d=/^0?\.(0+)(.*)$/.exec(a))&&c.push(d[2]+"e-"+(d[1].length+d[2].length),b.substr(b.indexOf(".")));return i(c)}function r(a,b,c,d){d=d||"function";a&&(d+=" "+e(a));d+="("+k(MAP(b,e))+")";return g([d,q(c)])}function l(a){switch(a[0]){case "with":case "while":return empty(a[2]);case "for":case "for-in":return empty(a[4]);case "if":return empty(a[2])&&!a[3]?!0:a[3]?empty(a[3])?!0:l(a[3]):l(a[2])}}function s(a,b){for(var c=[],e=a.length-1,f=0;f<=e;++f){var g=a[f],h=j(g);h!=";"&&(!p&&
f==e&&!l(g)&&(h=h.replace(/;+\s*$/,"")),c.push(h))}return b?c:MAP(c,d)}function y(a){var b=a.length;return b==0?"{}":"{"+o+MAP(a,function(a,c){var e=a[1].length>0,w=h(function(){return d(a[0]?g(["case",j(a[0])+":"]):"default:")},0.5)+(e?o+h(function(){return s(a[1]).join(o)}):"");!p&&e&&c<b-1&&(w+=";");return w}).join(o)+o+d("}")}function q(a){return!a?";":a.length==0?"{}":"{"+o+h(function(){return s(a).join(o)})+o+d("}")}function x(a){var b=a[0],a=a[1];a!=null&&(b=g([e(b),"=",f(a,"seq")]));return b}
var b=defaults(b,{indent_start:0,indent_level:4,quote_keys:!1,space_colon:!1,beautify:!1,ascii_only:!1,inline_script:!1}),p=!!b.beautify,u=0,o=p?"\n":"",v=p?" ":"",t=ast_walker(),j=t.walk;return t.with_walkers({string:c,num:m,name:e,toplevel:function(a){return s(a).join(o+o)},splice:function(a){var b=t.parent();return HOP(SPLICE_NEEDS_BRACKETS,b)?q.apply(this,arguments):MAP(s(a,!0),function(a,b){return b>0?d(a):a}).join(o)},block:q,"var":function(a){return"var "+k(MAP(a,x))+";"},"const":function(a){return"const "+
k(MAP(a,x))+";"},"try":function(a,b,c){a=["try",q(a)];b&&a.push("catch","("+b[0]+")",q(b[1]));c&&a.push("finally",q(c));return g(a)},"throw":function(a){return g(["throw",j(a)])+";"},"new":function(a,b){b=b.length>0?"("+k(MAP(b,j))+")":"";return g(["new",f(a,"seq","binary","conditional","assign",function(a){var b=ast_walker(),c={};try{b.with_walkers({call:function(){throw c;},"function":function(){return this}},function(){b.walk(a)})}catch(d){if(d===c)return!0;throw d;}})+b])},"switch":function(a,
b){return g(["switch","("+j(a)+")",y(b)])},"break":function(a){var b="break";a!=null&&(b+=" "+e(a));return b+";"},"continue":function(a){var b="continue";a!=null&&(b+=" "+e(a));return b+";"},conditional:function(a,b,c){return g([f(a,"assign","seq","conditional"),"?",f(b,"seq"),":",f(c,"seq")])},assign:function(a,b,c){a&&a!==!0?a+="=":a="=";return g([j(b),a,f(c,"seq")])},dot:function(a){var b=j(a),c=1;for(a[0]=="num"?/\./.test(a[1])||(b+="."):n(a)&&(b="("+b+")");c<arguments.length;)b+="."+e(arguments[c++]);
return b},call:function(a,b){var c=j(a);n(a)&&(c="("+c+")");return c+"("+k(MAP(b,function(a){return f(a,"seq")}))+")"},"function":r,defun:r,"if":function(a,b,c){a="("+j(a)+")";if(c)a:if(b[0]=="do")b=q([b]);else{for(var d=b;;){var e=d[0];if(e=="if"){if(!d[3]){b=j(["block",[b]]);break a}d=d[3]}else if(e=="while"||e=="do")d=d[2];else if(e=="for"||e=="for-in")d=d[4];else break}b=j(b)}else b=j(b);b=["if",a,b];c&&b.push("else",j(c));return g(b)},"for":function(a,b,c,d){var e=["for"],a=(a!=null?j(a):"").replace(/;*\s*$/,
";"+v),b=(b!=null?j(b):"").replace(/;*\s*$/,";"+v),c=(c!=null?j(c):"").replace(/;*\s*$/,""),a=a+b+c;a=="; ; "&&(a=";;");e.push("("+a+")",j(d));return g(e)},"for-in":function(a,b,c,d){return g(["for","("+(a?j(a).replace(/;+$/,""):j(b)),"in",j(c)+")",j(d)])},"while":function(a,b){return g(["while","("+j(a)+")",j(b)])},"do":function(a,b){return g(["do",j(b),"while","("+j(a)+")"])+";"},"return":function(a){var b=["return"];a!=null&&b.push(j(a));return g(b)+";"},binary:function(a,c,d){var e=j(c),f=j(d);
if(member(c[0],["assign","conditional","seq"])||c[0]=="binary"&&PRECEDENCE[a]>PRECEDENCE[c[1]])e="("+e+")";if(member(d[0],["assign","conditional","seq"])||d[0]=="binary"&&PRECEDENCE[a]>=PRECEDENCE[d[1]]&&!(d[1]==a&&member(a,["&&","||","*"])))f="("+f+")";else if(!p&&b.inline_script&&(a=="<"||a=="<<")&&d[0]=="regexp"&&/^script/i.test(d[1]))f=" "+f;return g([e,a,f])},"unary-prefix":function(a,b){var c=j(b);b[0]=="num"||b[0]=="unary-prefix"&&!HOP(OPERATORS,a+b[1])||!n(b)||(c="("+c+")");return a+(jsp.is_alphanumeric_char(a.charAt(0))?
" ":"")+c},"unary-postfix":function(a,b){var c=j(b);b[0]=="num"||b[0]=="unary-postfix"&&!HOP(OPERATORS,a+b[1])||!n(b)||(c="("+c+")");return c+a},sub:function(a,b){var c=j(a);n(a)&&(c="("+c+")");return c+"["+j(b)+"]"},object:function(a){return a.length==0?"{}":"{"+o+h(function(){return MAP(a,function(a){if(a.length==3)return d(r(a[0],a[1][2],a[1][3],a[2]));var e=a[0],a=f(a[1],"seq");b.quote_keys?e=c(e):(typeof e=="number"||!p&&+e+""==e)&&parseFloat(e)>=0?e=m(+e):is_identifier(e)||(e=c(e));return d(g(p&&
b.space_colon?[e,":",a]:[e+":",a]))}).join(","+o)})+o+d("}")},regexp:function(a,b){return"/"+a+"/"+b},array:function(a){return a.length==0?"[]":g(["[",k(MAP(a,function(a){return!p&&a[0]=="atom"&&a[1]=="undefined"?"":f(a,"seq")})),"]"])},stat:function(a){return j(a).replace(/;*\s*$/,";")},seq:function(){return k(MAP(slice(arguments),j))},label:function(a,b){return g([e(a),":",j(b)])},"with":function(a,b){return g(["with","("+j(a)+")",j(b)])},atom:function(a){return e(a)}},function(){return j(a)})}
function split_lines(a,b){var c=[0];jsp.parse(function(){function e(){var a=d.apply(this,arguments);if(!(g&&g.type=="keyword")&&a.pos-h>b)switch(a.type){case "keyword":case "atom":case "name":case "punc":h=a.pos,c.push(h)}return g=a}var d=jsp.tokenizer(a),h=0,g;e.context=function(){return d.context.apply(this,arguments)};return e}());return c.map(function(b,d){return a.substring(b,c[d+1]||a.length)}).join("\n")}
function repeat_string(a,b){if(b<=0)return"";if(b==1)return a;var c=repeat_string(a,b>>1);c+=c;b&1&&(c+=a);return c}function defaults(a,b){var c={};a===!0&&(a={});for(var e in b)HOP(b,e)&&(c[e]=a&&HOP(a,e)?a[e]:b[e]);return c}function is_identifier(a){return/^[a-z_$][a-z0-9_$]*$/i.test(a)&&a!="this"&&!HOP(jsp.KEYWORDS_ATOM,a)&&!HOP(jsp.RESERVED_WORDS,a)&&!HOP(jsp.KEYWORDS,a)}function HOP(a,b){return Object.prototype.hasOwnProperty.call(a,b)}var MAP;
(function(){function a(a){this.v=a}function b(a){this.v=a}MAP=function(e,d,h){function g(){var g=d.call(h,e[i],i);g instanceof a?(g=g.v,g instanceof b?f.push.apply(f,g.v):f.push(g)):g!=c&&(g instanceof b?k.push.apply(k,g.v):k.push(g))}var k=[],f=[],i;if(e instanceof Array)for(i=0;i<e.length;++i)g();else for(i in e)HOP(e,i)&&g();return f.concat(k)};MAP.at_top=function(b){return new a(b)};MAP.splice=function(a){return new b(a)};var c=MAP.skip={}})();exports.ast_walker=ast_walker;
exports.ast_mangle=ast_mangle;exports.ast_squeeze=ast_squeeze;exports.ast_lift_variables=ast_lift_variables;exports.gen_code=gen_code;exports.ast_add_scope=ast_add_scope;exports.set_logger=function(a){warn=a};exports.make_string=make_string;exports.split_lines=split_lines;exports.MAP=MAP;exports.ast_squeeze_more=require("./squeeze-more").ast_squeeze_more;