var JSLINT=(function(){'use strict';function array_to_object(a,b){var i,length=a.length,object={};for(i=0;i<length;i+=1){object[a[i]]=b}return object}var k,adsafe_may,adsafe_top,adsafe_went,allowed_option={anon:true,bitwise:true,browser:true,cap:true,'continue':true,css:true,debug:true,devel:true,eqeq:true,es5:true,evil:true,forin:true,fragment:true,indent:10,maxerr:1000,maxlen:256,newcap:true,node:true,nomen:true,on:true,passfail:true,plusplus:true,properties:true,regexp:true,rhino:true,undef:true,unparam:true,sloppy:true,sub:true,vars:true,white:true,widget:true,windows:true},anonname,approved,bang={'<':true,'<=':true,'==':true,'===':true,'!==':true,'!=':true,'>':true,'>=':true,'+':true,'-':true,'*':true,'/':true,'%':true},banned=array_to_object(['arguments','callee','caller','constructor','eval','prototype','stack','unwatch','valueOf','watch'],true),begin,browser=array_to_object(['clearInterval','clearTimeout','document','event','frames','history','Image','localStorage','location','name','navigator','Option','parent','screen','sessionStorage','setInterval','setTimeout','Storage','window','XMLHttpRequest'],false),bundle={a_label:"'{a}' is a statement label.",a_not_allowed:"'{a}' is not allowed.",a_not_defined:"'{a}' is not defined.",a_scope:"'{a}' used out of scope.",adsafe_a:"ADsafe violation: '{a}'.",adsafe_autocomplete:"ADsafe autocomplete violation.",adsafe_bad_id:"ADSAFE violation: bad id.",adsafe_div:"ADsafe violation: Wrap the widget in a div.",adsafe_fragment:"ADSAFE: Use the fragment option.",adsafe_go:"ADsafe violation: Misformed ADSAFE.go.",adsafe_html:"Currently, ADsafe does not operate on whole HTML "+"documents. It operates on <div> fragments and .js files.",adsafe_id:"ADsafe violation: id does not match.",adsafe_id_go:"ADsafe violation: Missing ADSAFE.id or ADSAFE.go.",adsafe_lib:"ADsafe lib violation.",adsafe_lib_second:"ADsafe: The second argument to lib must be a function.",adsafe_missing_id:"ADSAFE violation: missing ID_.",adsafe_name_a:"ADsafe name violation: '{a}'.",adsafe_placement:"ADsafe script placement violation.",adsafe_prefix_a:"ADsafe violation: An id must have a '{a}' prefix",adsafe_script:"ADsafe script violation.",adsafe_source:"ADsafe unapproved script source.",adsafe_subscript_a:"ADsafe subscript '{a}'.",adsafe_tag:"ADsafe violation: Disallowed tag '{a}'.",already_defined:"'{a}' is already defined.",and:"The '&&' subexpression should be wrapped in parens.",assign_exception:"Do not assign to the exception parameter.",assignment_function_expression:"Expected an assignment or "+"function call and instead saw an expression.",attribute_case_a:"Attribute '{a}' not all lower case.",avoid_a:"Avoid '{a}'.",bad_assignment:"Bad assignment.",bad_color_a:"Bad hex color '{a}'.",bad_constructor:"Bad constructor.",bad_entity:"Bad entity.",bad_html:"Bad HTML string",bad_id_a:"Bad id: '{a}'.",bad_in_a:"Bad for in variable '{a}'.",bad_invocation:"Bad invocation.",bad_name_a:"Bad name: '{a}'.",bad_new:"Do not use 'new' for side effects.",bad_number:"Bad number '{a}'.",bad_operand:"Bad operand.",bad_style:"Bad style.",bad_type:"Bad type.",bad_url_a:"Bad url '{a}'.",bad_wrap:"Do not wrap function literals in parens unless they "+"are to be immediately invoked.",combine_var:"Combine this with the previous 'var' statement.",conditional_assignment:"Expected a conditional expression and "+"instead saw an assignment.",confusing_a:"Confusing use of '{a}'.",confusing_regexp:"Confusing regular expression.",constructor_name_a:"A constructor name '{a}' should start with "+"an uppercase letter.",control_a:"Unexpected control character '{a}'.",css:"A css file should begin with @charset 'UTF-8';",dangling_a:"Unexpected dangling '_' in '{a}'.",dangerous_comment:"Dangerous comment.",deleted:"Only properties should be deleted.",duplicate_a:"Duplicate '{a}'.",empty_block:"Empty block.",empty_case:"Empty case.",empty_class:"Empty class.",es5:"This is an ES5 feature.",evil:"eval is evil.",expected_a:"Expected '{a}'.",expected_a_b:"Expected '{a}' and instead saw '{b}'.",expected_a_b_from_c_d:"Expected '{a}' to match '{b}' from line "+"{c} and instead saw '{d}'.",expected_at_a:"Expected an at-rule, and instead saw @{a}.",expected_a_at_b_c:"Expected '{a}' at column {b}, not column {c}.",expected_attribute_a:"Expected an attribute, and instead saw [{a}].",expected_attribute_value_a:"Expected an attribute value and "+"instead saw '{a}'.",expected_class_a:"Expected a class, and instead saw .{a}.",expected_fraction_a:"Expected a number between 0 and 1 and "+"instead saw '{a}'",expected_id_a:"Expected an id, and instead saw #{a}.",expected_identifier_a:"Expected an identifier and instead saw '{a}'.",expected_identifier_a_reserved:"Expected an identifier and "+"instead saw '{a}' (a reserved word).",expected_linear_a:"Expected a linear unit and instead saw '{a}'.",expected_lang_a:"Expected a lang code, and instead saw :{a}.",expected_media_a:"Expected a CSS media type, and instead saw '{a}'.",expected_name_a:"Expected a name and instead saw '{a}'.",expected_nonstandard_style_attribute:"Expected a non-standard "+"style attribute and instead saw '{a}'.",expected_number_a:"Expected a number and instead saw '{a}'.",expected_operator_a:"Expected an operator and instead saw '{a}'.",expected_percent_a:"Expected a percentage and instead saw '{a}'",expected_positive_a:"Expected a positive number and instead saw '{a}'",expected_pseudo_a:"Expected a pseudo, and instead saw :{a}.",expected_selector_a:"Expected a CSS selector, and instead saw {a}.",expected_small_a:"Expected a small positive integer and instead saw '{a}'",expected_space_a_b:"Expected exactly one space between '{a}' and '{b}'.",expected_string_a:"Expected a string and instead saw {a}.",expected_style_attribute:"Excepted a style attribute, and instead saw '{a}'.",expected_style_pattern:"Expected a style pattern, and instead saw '{a}'.",expected_tagname_a:"Expected a tagName, and instead saw {a}.",expected_type_a:"Expected a type, and instead saw {a}.",for_if:"The body of a for in should be wrapped in an if "+"statement to filter unwanted properties from the prototype.",function_block:"Function statements should not be placed in blocks. "+"Use a function expression or move the statement to the top of "+"the outer function.",function_eval:"The Function constructor is eval.",function_loop:"Don't make functions within a loop.",function_statement:"Function statements are not invocable. "+"Wrap the whole function invocation in parens.",function_strict:"Use the function form of 'use strict'.",html_confusion_a:"HTML confusion in regular expression '<{a}'.",html_handlers:"Avoid HTML event handlers.",identifier_function:"Expected an identifier in an assignment "+"and instead saw a function invocation.",implied_evil:"Implied eval is evil. Pass a function instead of a string.",infix_in:"Unexpected 'in'. Compare with undefined, or use the "+"hasOwnProperty method instead.",insecure_a:"Insecure '{a}'.",isNaN:"Use the isNaN function to compare with NaN.",label_a_b:"Label '{a}' on '{b}' statement.",lang:"lang is deprecated.",leading_decimal_a:"A leading decimal point can be confused with a dot: '.{a}'.",missing_a:"Missing '{a}'.",missing_a_after_b:"Missing '{a}' after '{b}'.",missing_option:"Missing option value.",missing_property:"Missing property name.",missing_space_a_b:"Missing space between '{a}' and '{b}'.",missing_url:"Missing url.",missing_use_strict:"Missing 'use strict' statement.",mixed:"Mixed spaces and tabs.",move_invocation:"Move the invocation into the parens that "+"contain the function.",move_var:"Move 'var' declarations to the top of the function.",name_function:"Missing name in function statement.",nested_comment:"Nested comment.",not:"Nested not.",not_a_constructor:"Do not use {a} as a constructor.",not_a_defined:"'{a}' has not been fully defined yet.",not_a_function:"'{a}' is not a function.",not_a_label:"'{a}' is not a label.",not_a_scope:"'{a}' is out of scope.",not_greater:"'{a}' should not be greater than '{b}'.",octal_a:"Don't use octal: '{a}'. Use '\\u....' instead.",parameter_arguments_a:"Do not mutate parameter '{a}' when using 'arguments'.",parameter_a_get_b:"Unexpected parameter '{a}' in get {b} function.",parameter_set_a:"Expected parameter (value) in set {a} function.",radix:"Missing radix parameter.",read_only:"Read only.",redefinition_a:"Redefinition of '{a}'.",reserved_a:"Reserved name '{a}'.",scanned_a_b:"{a} ({b}% scanned).",slash_equal:"A regular expression literal can be confused with '/='.",statement_block:"Expected to see a statement and instead saw a block.",stopping:"Stopping. ",strange_loop:"Strange loop.",strict:"Strict violation.",subscript:"['{a}'] is better written in dot notation.",tag_a_in_b:"A '<{a}>' must be within '<{b}>'.",too_long:"Line too long.",too_many:"Too many errors.",trailing_decimal_a:"A trailing decimal point can be confused "+"with a dot: '.{a}'.",type:"type is unnecessary.",unclosed:"Unclosed string.",unclosed_comment:"Unclosed comment.",unclosed_regexp:"Unclosed regular expression.",unescaped_a:"Unescaped '{a}'.",unexpected_a:"Unexpected '{a}'.",unexpected_char_a_b:"Unexpected character '{a}' in {b}.",unexpected_comment:"Unexpected comment.",unexpected_property_a:"Unexpected /*property*/ '{a}'.",unexpected_space_a_b:"Unexpected space between '{a}' and '{b}'.",unnecessary_initialize:"It is not necessary to initialize '{a}' "+"to 'undefined'.",unnecessary_use:"Unnecessary 'use strict'.",unreachable_a_b:"Unreachable '{a}' after '{b}'.",unrecognized_style_attribute_a:"Unrecognized style attribute '{a}'.",unrecognized_tag_a:"Unrecognized tag '<{a}>'.",unsafe:"Unsafe character.",url:"JavaScript URL.",use_array:"Use the array literal notation [].",use_braces:"Spaces are hard to count. Use {{a}}.",use_charAt:"Use the charAt method.",use_object:"Use the object literal notation {}.",use_or:"Use the || operator.",use_param:"Use a named parameter.",used_before_a:"'{a}' was used before it was defined.",var_a_not:"Variable {a} was not declared correctly.",weird_assignment:"Weird assignment.",weird_condition:"Weird condition.",weird_new:"Weird construction. Delete 'new'.",weird_program:"Weird program.",weird_relation:"Weird relation.",weird_ternary:"Weird ternary.",wrap_immediate:"Wrap an immediate function invocation in parentheses "+"to assist the reader in understanding that the expression "+"is the result of a function, and not the function itself.",wrap_regexp:"Wrap the /regexp/ literal in parens to "+"disambiguate the slash operator.",write_is_wrong:"document.write can be a form of eval."},comments_off,css_attribute_data,css_any,css_colorData=array_to_object(["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgreen","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen","activeborder","activecaption","appworkspace","background","buttonface","buttonhighlight","buttonshadow","buttontext","captiontext","graytext","highlight","highlighttext","inactiveborder","inactivecaption","inactivecaptiontext","infobackground","infotext","menu","menutext","scrollbar","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","window","windowframe","windowtext"],true),css_border_style,css_break,css_lengthData={'%':true,'cm':true,'em':true,'ex':true,'in':true,'mm':true,'pc':true,'pt':true,'px':true},css_media,css_overflow,descapes={'b':'\b','t':'\t','n':'\n','f':'\f','r':'\r','"':'"','/':'/','\\':'\\'},devel=array_to_object(['alert','confirm','console','Debug','opera','prompt','WSH'],false),directive,escapes={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','\'':'\\\'','"':'\\"','/':'\\/','\\':'\\\\'},funct,functionicity=['closure','exception','global','label','outer','undef','unused','var'],functions,global_funct,global_scope,html_tag={a:{},abbr:{},acronym:{},address:{},applet:{},area:{empty:true,parent:' map '},article:{},aside:{},audio:{},b:{},base:{empty:true,parent:' head '},bdo:{},big:{},blockquote:{},body:{parent:' html noframes '},br:{empty:true},button:{},canvas:{parent:' body p div th td '},caption:{parent:' table '},center:{},cite:{},code:{},col:{empty:true,parent:' table colgroup '},colgroup:{parent:' table '},command:{parent:' menu '},datalist:{},dd:{parent:' dl '},del:{},details:{},dialog:{},dfn:{},dir:{},div:{},dl:{},dt:{parent:' dl '},em:{},embed:{},fieldset:{},figure:{},font:{},footer:{},form:{},frame:{empty:true,parent:' frameset '},frameset:{parent:' html frameset '},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{parent:' html '},header:{},hgroup:{},hr:{empty:true},'hta:application':{empty:true,parent:' head '},html:{parent:'*'},i:{},iframe:{},img:{empty:true},input:{empty:true},ins:{},kbd:{},keygen:{},label:{},legend:{parent:' details fieldset figure '},li:{parent:' dir menu ol ul '},link:{empty:true,parent:' head '},map:{},mark:{},menu:{},meta:{empty:true,parent:' head noframes noscript '},meter:{},nav:{},noframes:{parent:' html body '},noscript:{parent:' body head noframes '},object:{},ol:{},optgroup:{parent:' select '},option:{parent:' optgroup select '},output:{},p:{},param:{empty:true,parent:' applet object '},pre:{},progress:{},q:{},rp:{},rt:{},ruby:{},samp:{},script:{empty:true,parent:' body div frame head iframe p pre span '},section:{},select:{},small:{},span:{},source:{},strong:{},style:{parent:' head ',empty:true},sub:{},sup:{},table:{},tbody:{parent:' table '},td:{parent:' tr '},textarea:{},tfoot:{parent:' table '},th:{parent:' tr '},thead:{parent:' table '},time:{},title:{parent:' head '},tr:{parent:' table tbody thead tfoot '},tt:{},u:{},ul:{},'var':{},video:{}},ids,in_block,indent,itself,json_mode,lex,lines,lookahead,node=array_to_object(['Buffer','clearInterval','clearTimeout','console','exports','global','module','process','querystring','require','setInterval','setTimeout','__dirname','__filename'],false),node_js,numbery=array_to_object(['indexOf','lastIndexOf','search'],true),next_token,option,predefined,prereg,prev_token,property,regexp_flag=array_to_object(['g','i','m'],true),return_this=function return_this(){return this},rhino=array_to_object(['defineClass','deserialize','gc','help','load','loadClass','print','quit','readFile','readUrl','runCommand','seal','serialize','spawn','sync','toint32','version'],false),scope,semicolon_coda=array_to_object([';','"','\'',')'],true),src,stack,standard=array_to_object(['Array','Boolean','Date','decodeURI','decodeURIComponent','encodeURI','encodeURIComponent','Error','eval','EvalError','Function','isFinite','isNaN','JSON','Math','Number','Object','parseInt','parseFloat','RangeError','ReferenceError','RegExp','String','SyntaxError','TypeError','URIError'],false),strict_mode,syntax={},tab,token,urls,var_mode,warnings,widget=array_to_object(['alert','animator','appleScript','beep','bytesToUIString','Canvas','chooseColor','chooseFile','chooseFolder','closeWidget','COM','convertPathToHFS','convertPathToPlatform','CustomAnimation','escape','FadeAnimation','filesystem','Flash','focusWidget','form','FormField','Frame','HotKey','Image','include','isApplicationRunning','iTunes','konfabulatorVersion','log','md5','MenuItem','MoveAnimation','openURL','play','Point','popupMenu','preferenceGroups','preferences','print','prompt','random','Rectangle','reloadWidget','ResizeAnimation','resolvePath','resumeUpdates','RotateAnimation','runCommand','runCommandInBg','saveAs','savePreferences','screen','ScrollBar','showWidgetPreferences','sleep','speak','Style','suppressUpdates','system','tellWidget','Text','TextArea','Timer','unescape','updateNow','URL','Web','widget','Window','XMLDOM','XMLHttpRequest','yahooCheckLogin','yahooLogin','yahooLogout'],true),windows=array_to_object(['ActiveXObject','CScript','Debug','Enumerator','System','VBArray','WScript','WSH'],false),xmode,xquote,ax=/@cc|<\/?|script|\]\s*\]|<\s*!|&lt/i,crx=/\r/g,crlfx=/\r\n/g,cx=/[\u0000-\u001f\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/,dx=/[\[\]\/\\"'*<>.&:(){}+=#]/,hx=/^\s*(['"=>\/&#]|<(?:\/|\!(?:--)?)?|[a-zA-Z][a-zA-Z0-9_\-:]*|[0-9]+|--)/,ix=/^([a-zA-Z_$][a-zA-Z0-9_$]*)$/,jx=/^(?:javascript|jscript|ecmascript|vbscript|mocha|livescript)\s*:/i,lx=/\*\/|\/\*/,nx=/[\u0000-\u001f'\\\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,ox=/[>&]|<[\/!]?|--/,qx=/[^a-zA-Z0-9+\-_\/ ]/,sx=/^\s*([{}:#%.=,>+\[\]@()"';]|[*$\^~]=|[a-zA-Z_][a-zA-Z0-9_\-]*|[0-9]+|<\/|\/\*)/,ssx=/^\s*([@#!"'};:\-%.=,+\[\]()*_]|[a-zA-Z][a-zA-Z0-9._\-]*|\/\*?|\d+(?:\.\d+)?|<\/)/,tx=/^\s*([(){}\[\]\?.,:;'"~#@`]|={1,3}|\/(\*(jslint|properties|property|members?|globals?)?|=|\/)?|\*[\/=]?|\+(?:=|\++)?|-(?:=|-+)?|[\^%]=?|&[&=]?|\|[|=]?|>{1,3}=?|<(?:[\/=!]|\!(\[|--)?|<=?)?|\!={0,2}|[a-zA-Z_$][a-zA-Z0-9_$]*|[0-9]+(?:[xX][0-9a-fA-F]+|\.[0-9]*)?(?:[eE][+\-]?[0-9]+)?)/,ux=/&|\+|\u00AD|\.\.|\/\*|%[^;]|base64|url|expression|data|mailto|script/i,rx={outer:hx,html:hx,style:sx,styleproperty:ssx};function F(){}if(typeof Array.prototype.filter!=='function'){Array.prototype.filter=function(f){var i,length=this.length,result=[],value;for(i=0;i<length;i+=1){try{value=this[i];if(f(value)){result.push(value)}}catch(ignore){}}return result}}if(typeof Array.prototype.forEach!=='function'){Array.prototype.forEach=function(f){var i,length=this.length;for(i=0;i<length;i+=1){try{f(this[i])}catch(ignore){}}}}if(typeof Array.isArray!=='function'){Array.isArray=function(o){return Object.prototype.toString.apply(o)==='[object Array]'}}if(!Object.prototype.hasOwnProperty.call(Object,'create')){Object.create=function(o){F.prototype=o;return new F()}}if(typeof Object.keys!=='function'){Object.keys=function(o){var a=[],key;for(key in o){if(Object.prototype.hasOwnProperty.call(o,key)){a.push(key)}}return a}}if(typeof String.prototype.entityify!=='function'){String.prototype.entityify=function(){return this.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')}}if(typeof String.prototype.isAlpha!=='function'){String.prototype.isAlpha=function(){return(this>='a'&&this<='z\uffff')||(this>='A'&&this<='Z\uffff')}}if(typeof String.prototype.isDigit!=='function'){String.prototype.isDigit=function(){return(this>='0'&&this<='9')}}if(typeof String.prototype.supplant!=='function'){String.prototype.supplant=function(o){return this.replace(/\{([^{}]*)\}/g,function(a,b){var c=o[b];return typeof c==='string'||typeof c==='number'?c:a})}}function sanitize(a){return escapes[a]||'\\u'+('0000'+a.charCodeAt().toString(16)).slice(-4)}function add_to_predefined(b){Object.keys(b).forEach(function(a){predefined[a]=b[a]})}function assume(){if(!option.safe){if(option.rhino){add_to_predefined(rhino);option.rhino=false}if(option.devel){add_to_predefined(devel);option.devel=false}if(option.browser){add_to_predefined(browser);option.browser=false}if(option.windows){add_to_predefined(windows);option.windows=false}if(option.node){add_to_predefined(node);option.node=false;node_js=true}if(option.widget){add_to_predefined(widget);option.widget=false}}}function artifact(a){if(!a){a=next_token}return a.number||a.string}function quit(a,b,c){throw{name:'JSLintError',line:b,character:c,message:bundle.scanned_a_b.supplant({a:a,b:Math.floor((b/lines.length)*100)})}}function warn(e,f,a,b,c,d){var g,line,warning;f=f||next_token;line=f.line||0;g=f.from||0;warning={id:'(error)',raw:bundle[e]||e,evidence:lines[line-1]||'',line:line,character:g,a:a||(f.id==='(number)'?String(f.number):f.string),b:b,c:c,d:d};warning.reason=warning.raw.supplant(warning);JSLINT.errors.push(warning);if(option.passfail){quit(bundle.stopping,line,g)}warnings+=1;if(warnings>=option.maxerr){quit(bundle.too_many,line,g)}return warning}function warn_at(e,f,g,a,b,c,d){return warn(e,{line:f,from:g},a,b,c,d)}function stop(e,f,a,b,c,d){var g=warn(e,f,a,b,c,d);quit(bundle.stopping,g.line,g.character)}function stop_at(e,f,g,a,b,c,d){return stop(e,{line:f,from:g},a,b,c,d)}function expected_at(a){if(!option.white&&next_token.from!==a){warn('expected_a_at_b_c',next_token,'',a,next_token.from)}}function aint(a,b,c){if(a[b]!==c){warn('expected_a_b',a,c,a[b]);return true}else{return false}}lex=(function lex(){var d,c,from,length,line,pos,source_row;function next_line(){var a;if(line>=lines.length){return false}d=1;source_row=lines[line];line+=1;a=source_row.search(/ \t/);if(a>=0){warn_at('mixed',line,a+1)}source_row=source_row.replace(/\t/g,tab);a=source_row.search(cx);if(a>=0){warn_at('unsafe',line,a)}if(option.maxlen&&option.maxlen<source_row.length){warn_at('too_long',line,source_row.length)}return true}function it(a,b){var c,the_token;if(a==='(string)'||a==='(range)'){if(jx.test(b)){warn_at('url',line,from)}}the_token=Object.create(syntax[(a==='(punctuator)'||(a==='(identifier)'&&Object.prototype.hasOwnProperty.call(syntax,b))?b:a)]||syntax['(error)']);if(a==='(identifier)'){the_token.identifier=true;if(b==='__iterator__'||b==='__proto__'){stop_at('reserved_a',line,from,b)}else if(!option.nomen&&(b.charAt(0)==='_'||b.charAt(b.length-1)==='_')){warn_at('dangling_a',line,from,b)}}if(a==='(number)'){the_token.number=+b}else if(b!==undefined){the_token.string=String(b)}the_token.line=line;the_token.from=from;the_token.thru=d;c=the_token.id;prereg=c&&(('(,=:[!&|?{};'.indexOf(c.charAt(c.length-1))>=0)||c==='return'||c==='case');return the_token}function match(x){var a=x.exec(source_row),first;if(a){length=a[0].length;first=a[1];c=first.charAt(0);source_row=source_row.slice(length);from=d+length-first.length;d+=length;return first}}function string(x){var c,pos=0,r='',result;function hex(n){var i=parseInt(source_row.substr(pos+1,n),16);pos+=n;if(i>=32&&i<=126&&i!==34&&i!==92&&i!==39){warn_at('unexpected_a',line,d,'\\')}d+=n;c=String.fromCharCode(i)}if(json_mode&&x!=='"'){warn_at('expected_a',line,d,'"')}if(xquote===x||(xmode==='scriptstring'&&!xquote)){return it('(punctuator)',x)}for(;;){while(pos>=source_row.length){pos=0;if(xmode!=='html'||!next_line()){stop_at('unclosed',line,from)}}c=source_row.charAt(pos);if(c===x){d+=1;source_row=source_row.slice(pos+1);result=it('(string)',r);result.quote=x;return result}if(c<' '){if(c==='\n'||c==='\r'){break}warn_at('control_a',line,d+pos,source_row.slice(0,pos))}else if(c===xquote){warn_at('bad_html',line,d+pos)}else if(c==='<'){if(option.safe&&xmode==='html'){warn_at('adsafe_a',line,d+pos,c)}else if(source_row.charAt(pos+1)==='/'&&(xmode||option.safe)){warn_at('expected_a_b',line,d,'<\\/','</')}else if(source_row.charAt(pos+1)==='!'&&(xmode||option.safe)){warn_at('unexpected_a',line,d,'<!')}}else if(c==='\\'){if(xmode==='html'){if(option.safe){warn_at('adsafe_a',line,d+pos,c)}}else if(xmode==='styleproperty'){pos+=1;d+=1;c=source_row.charAt(pos);if(c!==x){warn_at('unexpected_a',line,d,'\\')}}else{pos+=1;d+=1;c=source_row.charAt(pos);switch(c){case'':if(!option.es5){warn_at('es5',line,d)}next_line();pos=-1;break;case xquote:warn_at('bad_html',line,d+pos);break;case'\'':if(json_mode){warn_at('unexpected_a',line,d,'\\\'')}break;case'u':hex(4);break;case'v':if(json_mode){warn_at('unexpected_a',line,d,'\\v')}c='\v';break;case'x':if(json_mode){warn_at('unexpected_a',line,d,'\\x')}hex(2);break;default:if(typeof descapes[c]!=='string'){warn_at(c>='0'&&c<='7'?'octal_a':'unexpected_a',line,d,'\\'+c)}else{c=descapes[c]}}}}r+=c;d+=1;pos+=1}}function number(a){var b;if(xmode!=='style'&&xmode!=='styleproperty'&&source_row.charAt(0).isAlpha()){warn_at('expected_space_a_b',line,d,c,source_row.charAt(0))}if(c==='0'){b=a.charAt(1);if(b.isDigit()){if(token.id!=='.'&&xmode!=='styleproperty'){warn_at('unexpected_a',line,d,a)}}else if(json_mode&&(b==='x'||b==='X')){warn_at('unexpected_a',line,d,'0x')}}if(a.slice(a.length-1)==='.'){warn_at('trailing_decimal_a',line,d,a)}if(xmode!=='style'){b=+a;if(!isFinite(b)){warn_at('bad_number',line,d,a)}a=b}return it('(number)',a)}function comment(a){if(comments_off||src||(xmode&&xmode!=='script'&&xmode!=='style'&&xmode!=='styleproperty')){warn_at('unexpected_comment',line,d)}else if(xmode==='script'&&/<\//i.test(source_row)){warn_at('unexpected_a',line,d,'<\/')}else if(option.safe&&ax.test(a)){warn_at('dangerous_comment',line,d)}}function regexp(){var b,bit,captures=0,depth=0,flag='',high,letter,length=0,low,potential,quote,result;for(;;){b=true;c=source_row.charAt(length);length+=1;switch(c){case'':stop_at('unclosed_regexp',line,from);return;case'/':if(depth>0){warn_at('unescaped_a',line,from+length,'/')}c=source_row.slice(0,length-1);potential=Object.create(regexp_flag);for(;;){letter=source_row.charAt(length);if(potential[letter]!==true){break}potential[letter]=false;length+=1;flag+=letter}if(source_row.charAt(length).isAlpha()){stop_at('unexpected_a',line,from,source_row.charAt(length))}d+=length;source_row=source_row.slice(length);quote=source_row.charAt(0);if(quote==='/'||quote==='*'){stop_at('confusing_regexp',line,from)}result=it('(regexp)',c);result.flag=flag;return result;case'\\':c=source_row.charAt(length);if(c<' '){warn_at('control_a',line,from+length,String(c))}else if(c==='<'){warn_at(bundle.unexpected_a,line,from+length,'\\')}length+=1;break;case'(':depth+=1;b=false;if(source_row.charAt(length)==='?'){length+=1;switch(source_row.charAt(length)){case':':case'=':case'!':length+=1;break;default:warn_at(bundle.expected_a_b,line,from+length,':',source_row.charAt(length))}}else{captures+=1}break;case'|':b=false;break;case')':if(depth===0){warn_at('unescaped_a',line,from+length,')')}else{depth-=1}break;case' ':pos=1;while(source_row.charAt(length)===' '){length+=1;pos+=1}if(pos>1){warn_at('use_braces',line,from+length,pos)}break;case'[':c=source_row.charAt(length);if(c==='^'){length+=1;if(!option.regexp){warn_at('insecure_a',line,from+length,c)}else if(source_row.charAt(length)===']'){stop_at('unescaped_a',line,from+length,'^')}}bit=false;if(c===']'){warn_at('empty_class',line,from+length-1);bit=true}klass:do{c=source_row.charAt(length);length+=1;switch(c){case'[':case'^':warn_at('unescaped_a',line,from+length,c);bit=true;break;case'-':if(bit){bit=false}else{warn_at('unescaped_a',line,from+length,'-');bit=true}break;case']':if(!bit){warn_at('unescaped_a',line,from+length-1,'-')}break klass;case'\\':c=source_row.charAt(length);if(c<' '){warn_at(bundle.control_a,line,from+length,String(c))}else if(c==='<'){warn_at(bundle.unexpected_a,line,from+length,'\\')}length+=1;bit=true;break;case'/':warn_at('unescaped_a',line,from+length-1,'/');bit=true;break;case'<':if(xmode==='script'){c=source_row.charAt(length);if(c==='!'||c==='/'){warn_at(bundle.html_confusion_a,line,from+length,c)}}bit=true;break;default:bit=true}}while(c);break;case'.':if(!option.regexp){warn_at('insecure_a',line,from+length,c)}break;case']':case'?':case'{':case'}':case'+':case'*':warn_at('unescaped_a',line,from+length,c);break;case'<':if(xmode==='script'){c=source_row.charAt(length);if(c==='!'||c==='/'){warn_at(bundle.html_confusion_a,line,from+length,c)}}break}if(b){switch(source_row.charAt(length)){case'?':case'+':case'*':length+=1;if(source_row.charAt(length)==='?'){length+=1}break;case'{':length+=1;c=source_row.charAt(length);if(c<'0'||c>'9'){warn_at(bundle.expected_number_a,line,from+length,c)}length+=1;low=+c;for(;;){c=source_row.charAt(length);if(c<'0'||c>'9'){break}length+=1;low=+c+(low*10)}high=low;if(c===','){length+=1;high=Infinity;c=source_row.charAt(length);if(c>='0'&&c<='9'){length+=1;high=+c;for(;;){c=source_row.charAt(length);if(c<'0'||c>'9'){break}length+=1;high=+c+(high*10)}}}if(source_row.charAt(length)!=='}'){warn_at(bundle.expected_a_b,line,from+length,'}',c)}else{length+=1}if(source_row.charAt(length)==='?'){length+=1}if(low>high){warn_at(bundle.not_greater,line,from+length,low,high)}break}}}c=source_row.slice(0,length-1);d+=length;source_row=source_row.slice(length);return it('(regexp)',c)}return{init:function(a){if(typeof a==='string'){lines=a.replace(crlfx,'\n').replace(crx,'\n').split('\n')}else{lines=a}line=0;next_line();from=1},range:function(a,b){var c,value='';from=d;if(source_row.charAt(0)!==a){stop_at('expected_a_b',line,d,a,source_row.charAt(0))}for(;;){source_row=source_row.slice(1);d+=1;c=source_row.charAt(0);switch(c){case'':stop_at('missing_a',line,d,c);break;case b:source_row=source_row.slice(1);d+=1;return it('(range)',value);case xquote:case'\\':warn_at('unexpected_a',line,d,c);break}value+=c}},token:function(){var c,i,snippet;for(;;){while(!source_row){if(!next_line()){return it('(end)')}}while(xmode==='outer'){i=source_row.search(ox);if(i===0){break}else if(i>0){d+=1;source_row=source_row.slice(i);break}else{if(!next_line()){return it('(end)','')}}}snippet=match(rx[xmode]||tx);if(!snippet){if(source_row){if(source_row.charAt(0)===' '){if(!option.white){warn_at('unexpected_a',line,d,'(space)')}d+=1;source_row=''}else{stop_at('unexpected_a',line,d,source_row.charAt(0))}}}else{c=snippet.charAt(0);if(c.isAlpha()||c==='_'||c==='$'){return it('(identifier)',snippet)}if(c.isDigit()){return number(snippet)}switch(snippet){case'"':case"'":return string(snippet);case'//':comment(source_row);source_row='';break;case'/*':for(;;){i=source_row.search(lx);if(i>=0){break}comment(source_row);if(!next_line()){stop_at('unclosed_comment',line,d)}}comment(source_row.slice(0,i));d+=i+2;if(source_row.charAt(i)==='/'){stop_at('nested_comment',line,d)}source_row=source_row.slice(i+2);break;case'':break;case'/':if(token.id==='/='){stop_at(bundle.slash_equal,line,from)}return prereg?regexp():it('(punctuator)',snippet);case'<!--':length=line;for(;;){i=source_row.indexOf('--');if(i>=0){break}i=source_row.indexOf('<!');if(i>=0){stop_at('nested_comment',line,d+i)}if(!next_line()){stop_at('unclosed_comment',length,c)}}length=source_row.indexOf('<!');if(length>=0&&length<i){stop_at('nested_comment',line,d+length)}d+=i;if(source_row.charAt(i+2)!=='>'){stop_at('expected_a',line,d,'-->')}d+=3;source_row=source_row.slice(i+3);break;case'#':if(xmode==='html'||xmode==='styleproperty'){for(;;){c=source_row.charAt(0);if((c<'0'||c>'9')&&(c<'a'||c>'f')&&(c<'A'||c>'F')){break}d+=1;source_row=source_row.slice(1);snippet+=c}if(snippet.length!==4&&snippet.length!==7){warn_at('bad_color_a',line,from+length,snippet)}return it('(color)',snippet)}return it('(punctuator)',snippet);default:if(xmode==='outer'&&c==='&'){d+=1;source_row=source_row.slice(1);for(;;){c=source_row.charAt(0);d+=1;source_row=source_row.slice(1);if(c===';'){break}if(!((c>='0'&&c<='9')||(c>='a'&&c<='z')||c==='#')){stop_at('bad_entity',line,from+length,d)}}break}return it('(punctuator)',snippet)}}}}}}());function add_label(a,b,c){c=c||a.string;if(funct===global_funct){if(option.safe){warn('adsafe_a',a,c)}if(typeof global_funct[c]!=='string'){a.writeable=typeof predefined[c]==='boolean'?predefined[c]:true;a.funct=funct;global_scope[c]=a}if(b==='becoming'){b='var'}}else{if(typeof funct[c]==='string'){if(funct[c]==='undef'){if(!option.undef){warn('used_before_a',a,c)}b='var'}else{warn('already_defined',a,c)}}else{a.funct=funct;a.writeable=true;scope[c]=a}}funct[c]=b}function peek(a){var b,slot=0;a=a||0;while(slot<=a){b=lookahead[slot];if(!b){b=lookahead[slot]=lex.token()}slot+=1}return b}function advance(a,b){if(indent){if(var_mode&&next_token.line!==token.line){if((var_mode!==indent||!next_token.edge)&&next_token.from===indent.at-(next_token.edge?option.indent:0)){var c=indent;for(;;){c.at-=option.indent;if(c===var_mode){break}c=c.was}c.open=false}var_mode=null}if(next_token.id==='?'&&indent.mode===':'&&token.line!==next_token.line){indent.at-=option.indent}if(indent.open){if(next_token.edge){if(next_token.edge==='label'){expected_at(1)}else if(next_token.edge==='case'||indent.mode==='statement'){expected_at(indent.at-option.indent)}else if(indent.mode!=='array'||next_token.line!==token.line){expected_at(indent.at)}}else if(next_token.line!==token.line){if(next_token.from<indent.at+(indent.mode==='expression'?0:option.indent)){expected_at(indent.at+option.indent)}indent.wrap=true}}else if(next_token.line!==token.line){if(next_token.edge){expected_at(indent.at)}else{indent.wrap=true;if(indent.mode==='statement'||indent.mode==='var'){expected_at(indent.at+option.indent)}else if(next_token.from<indent.at+(indent.mode==='expression'?0:option.indent)){expected_at(indent.at+option.indent)}}}}switch(token.id){case'(number)':if(next_token.id==='.'){warn('trailing_decimal_a')}break;case'-':if(next_token.id==='-'||next_token.id==='--'){warn('confusing_a')}break;case'+':if(next_token.id==='+'||next_token.id==='++'){warn('confusing_a')}break}if(token.id==='(string)'||token.identifier){anonname=token.string}if(a&&next_token.id!==a){if(b){warn('expected_a_b_from_c_d',next_token,a,b.id,b.line,artifact())}else if(!next_token.identifier||next_token.string!==a){warn('expected_a_b',next_token,a,artifact())}}prev_token=token;token=next_token;next_token=lookahead.shift()||lex.token()}function advance_identifier(a){if(next_token.identifier&&next_token.string===a){advance()}else{warn('expected_a_b',next_token,a,artifact())}}function do_safe(){if(option.adsafe){option.safe=true}if(option.safe){option.browser=option['continue']=option.css=option.debug=option.devel=option.evil=option.forin=option.newcap=option.nomen=option.on=option.rhino=option.sloppy=option.sub=option.undef=option.widget=option.windows=false;delete predefined.Array;delete predefined.Date;delete predefined.Function;delete predefined.Object;delete predefined['eval'];add_to_predefined({ADSAFE:false,lib:false})}}function do_globals(){var a,writeable;for(;;){if(next_token.id!=='(string)'&&!next_token.identifier){return}a=next_token.string;advance();writeable=false;if(next_token.id===':'){advance(':');switch(next_token.id){case'true':writeable=predefined[a]!==false;advance('true');break;case'false':advance('false');break;default:stop('unexpected_a')}}predefined[a]=writeable;if(next_token.id!==','){return}advance(',')}}function do_jslint(){var a,value;while(next_token.id==='(string)'||next_token.identifier){a=next_token.string;if(!allowed_option[a]){stop('unexpected_a')}advance();if(next_token.id!==':'){stop('expected_a_b',next_token,':',artifact())}advance(':');if(typeof allowed_option[a]==='number'){value=next_token.number;if(value>allowed_option[a]||value<=0||Math.floor(value)!==value){stop('expected_small_a')}option[a]=value}else{if(next_token.id==='true'){option[a]=true}else if(next_token.id==='false'){option[a]=false}else{stop('unexpected_a')}}advance();if(next_token.id===','){advance(',')}}assume()}function do_properties(){var a;option.properties=true;for(;;){if(next_token.id!=='(string)'&&!next_token.identifier){return}a=next_token.string;advance();if(next_token.id===':'){for(;;){advance();if(next_token.id!=='(string)'&&!next_token.identifier){break}}}property[a]=0;if(next_token.id!==','){return}advance(',')}}directive=function directive(){var a=this.id,old_comments_off=comments_off,old_indent=indent;comments_off=true;indent=null;if(next_token.line===token.line&&next_token.from===token.thru){warn('missing_space_a_b',next_token,artifact(token),artifact())}if(lookahead.length>0){warn('unexpected_a',this)}switch(a){case'/*properties':case'/*property':case'/*members':case'/*member':do_properties();break;case'/*jslint':if(option.safe){warn('adsafe_a',this)}do_jslint();break;case'/*globals':case'/*global':if(option.safe){warn('adsafe_a',this)}do_globals();break;default:stop('unexpected_a',this)}comments_off=old_comments_off;advance('*/');indent=old_indent};function edge(a){next_token.edge=indent?indent.open&&(a||'edge'):''}function step_in(a){var b;if(typeof a==='number'){indent={at:+a,open:true,was:indent}}else if(!indent){indent={at:1,mode:'statement',open:true}}else if(a==='statement'){indent={at:indent.at,open:true,was:indent}}else{b=a==='var'||next_token.line!==token.line;indent={at:(b||a==='control'?indent.at+option.indent:indent.at)+(indent.wrap?option.indent:0),mode:a,open:b,was:indent};if(a==='var'&&b){var_mode=indent}}}function step_out(a,b){if(a){if(indent&&indent.open){indent.at-=option.indent;edge()}advance(a,b)}if(indent){indent=indent.was}}function one_space(a,b){a=a||token;b=b||next_token;if(b.id!=='(end)'&&!option.white&&(token.line!==b.line||token.thru+1!==b.from)){warn('expected_space_a_b',b,artifact(token),artifact(b))}}function one_space_only(a,b){a=a||token;b=b||next_token;if(b.id!=='(end)'&&(a.line!==b.line||(!option.white&&a.thru+1!==b.from))){warn('expected_space_a_b',b,artifact(a),artifact(b))}}function no_space(a,b){a=a||token;b=b||next_token;if((!option.white||xmode==='styleproperty'||xmode==='style')&&a.thru!==b.from&&a.line===b.line){warn('unexpected_space_a_b',b,artifact(a),artifact(b))}}function no_space_only(a,b){a=a||token;b=b||next_token;if(b.id!=='(end)'&&(a.line!==b.line||(!option.white&&a.thru!==b.from))){warn('unexpected_space_a_b',b,artifact(a),artifact(b))}}function spaces(a,b){if(!option.white){a=a||token;b=b||next_token;if(a.thru===b.from&&a.line===b.line){warn('missing_space_a_b',b,artifact(a),artifact(b))}}}function comma(){if(next_token.id!==','){warn_at('expected_a_b',token.line,token.thru,',',artifact())}else{if(!option.white){no_space_only()}advance(',');spaces()}}function semicolon(){if(next_token.id!==';'){warn_at('expected_a_b',token.line,token.thru,';',artifact())}else{if(!option.white){no_space_only()}advance(';');if(semicolon_coda[next_token.id]!==true){spaces()}}}function use_strict(){if(next_token.string==='use strict'){if(strict_mode){warn('unnecessary_use')}edge();advance();semicolon();strict_mode=true;option.newcap=false;option.undef=false;return true}else{return false}}function are_similar(a,b){if(a===b){return true}if(Array.isArray(a)){if(Array.isArray(b)&&a.length===b.length){var i;for(i=0;i<a.length;i+=1){if(!are_similar(a[i],b[i])){return false}}return true}return false}if(Array.isArray(b)){return false}if(a.id==='(number)'&&b.id==='(number)'){return a.number===b.number}if(a.arity===b.arity&&a.string===b.string){switch(a.arity){case'prefix':case'suffix':case undefined:return a.id===b.id&&are_similar(a.first,b.first);case'infix':return are_similar(a.first,b.first)&&are_similar(a.second,b.second);case'ternary':return are_similar(a.first,b.first)&&are_similar(a.second,b.second)&&are_similar(a.third,b.third);case'function':case'regexp':return false;default:return true}}else{if(a.id==='.'&&b.id==='['&&b.arity==='infix'){return a.second.string===b.second.string&&b.second.id==='(string)'}else if(a.id==='['&&a.arity==='infix'&&b.id==='.'){return a.second.string===b.second.string&&a.second.id==='(string)'}}return false}function expression(a,b){var c;if(next_token.id==='(end)'){stop('unexpected_a',token,next_token.id)}advance();if(option.safe&&scope[token.string]&&scope[token.string]===global_scope[token.string]&&(next_token.id!=='('&&next_token.id!=='.')){warn('adsafe_a',token)}if(b){anonname='anonymous';funct['(verb)']=token.string}if(b===true&&token.fud){c=token.fud()}else{if(token.nud){c=token.nud()}else{if(next_token.id==='(number)'&&token.id==='.'){warn('leading_decimal_a',token,artifact());advance();return token}else{stop('expected_identifier_a',token,token.id)}}while(a<next_token.lbp){advance();if(token.led){c=token.led(c)}else{stop('expected_operator_a',token,token.id)}}}return c}function symbol(s,p){var x=syntax[s];if(!x||typeof x!=='object'){syntax[s]=x={id:s,lbp:p||0,string:s}}return x}function postscript(x){x.postscript=true;return x}function ultimate(s){var x=symbol(s,0);x.from=1;x.thru=1;x.line=0;x.edge='edge';s.string=s;return postscript(x)}function stmt(s,f){var x=symbol(s);x.identifier=x.reserved=true;x.fud=f;return x}function labeled_stmt(s,f){var x=stmt(s,f);x.labeled=true}function disrupt_stmt(s,f){var x=stmt(s,f);x.disrupt=true}function reserve_name(x){var c=x.id.charAt(0);if((c>='a'&&c<='z')||(c>='A'&&c<='Z')){x.identifier=x.reserved=true}return x}function prefix(s,f){var x=symbol(s,150);reserve_name(x);x.nud=typeof f==='function'?f:function(){if(s==='typeof'){one_space()}else{no_space_only()}this.first=expression(150);this.arity='prefix';if(this.id==='++'||this.id==='--'){if(!option.plusplus){warn('unexpected_a',this)}else if((!this.first.identifier||this.first.reserved)&&this.first.id!=='.'&&this.first.id!=='['){warn('bad_operand',this)}}return this};return x}function type(s,t,a){var x=symbol(s);x.arity=t;if(a){x.nud=a}return x}function reserve(s,f){var x=symbol(s);x.identifier=x.reserved=true;if(typeof f==='function'){x.nud=f}return x}function constant(a){var x=reserve(a);x.string=a;x.nud=return_this;return x}function reservevar(s,v){return reserve(s,function(){if(typeof v==='function'){v(this)}return this})}function infix(s,p,f,w){var x=symbol(s,p);reserve_name(x);x.led=function(a){this.arity='infix';if(!w){spaces(prev_token,token);spaces()}if(!option.bitwise&&this.bitwise){warn('unexpected_a',this)}if(typeof f==='function'){return f(a,this)}else{this.first=a;this.second=expression(p);return this}};return x}function expected_relation(a,b){if(a.assign){warn(b||bundle.conditional_assignment,a)}return a}function expected_condition(a,b){switch(a.id){case'[':case'-':if(a.arity!=='infix'){warn(b||bundle.weird_condition,a)}break;case'false':case'function':case'Infinity':case'NaN':case'null':case'true':case'undefined':case'void':case'(number)':case'(regexp)':case'(string)':case'{':warn(b||bundle.weird_condition,a);break;case'(':if(a.first.id==='.'&&numbery[a.first.second.string]===true){warn(b||bundle.weird_condition,a)}break}return a}function check_relation(a){switch(a.arity){case'prefix':switch(a.id){case'{':case'[':warn('unexpected_a',a);break;case'!':warn('confusing_a',a);break}break;case'function':case'regexp':warn('unexpected_a',a);break;default:if(a.id==='NaN'){warn('isNaN',a)}}return a}function relation(s,d){return infix(s,100,function(a,b){check_relation(a);if(d&&!option.eqeq){warn('expected_a_b',b,d,b.id)}var c=expression(100);if(are_similar(a,c)||((a.id==='(string)'||a.id==='(number)')&&(c.id==='(string)'||c.id==='(number)'))){warn('weird_relation',b)}b.first=a;b.second=check_relation(c);return b})}function assignop(s,d){var x=infix(s,20,function(b,c){var l;c.first=b;if(b.identifier){if(scope[b.string]){if(scope[b.string].writeable===false){warn('read_only',b)}}else{stop('read_only')}if(funct['(params)']){funct['(params)'].forEach(function(a){if(a.string===b.string){a.assign=true}})}}else if(option.safe){l=b;do{if(typeof predefined[l.string]==='boolean'){warn('adsafe_a',l)}l=l.first}while(l)}if(b===syntax['function']){warn('identifier_function',token)}if(b.id==='.'||b.id==='['){if(!b.first||b.first.string==='arguments'){warn('bad_assignment',c)}}else if(b.identifier){if(!b.reserved&&funct[b.string]==='exception'){warn('assign_exception',b)}}else{warn('bad_assignment',c)}c.second=expression(19);if(c.id==='='&&are_similar(c.first,c.second)){warn('weird_assignment',c)}return c});x.assign=true;if(d){if(syntax[d].bitwise){x.bitwise=true}}return x}function bitwise(s,p){var x=infix(s,p,'number');x.bitwise=true;return x}function suffix(s){var x=symbol(s,150);x.led=function(a){no_space_only(prev_token,token);if(!option.plusplus){warn('unexpected_a',this)}else if((!a.identifier||a.reserved)&&a.id!=='.'&&a.id!=='['){warn('bad_operand',this)}this.first=a;this.arity='suffix';return this};return x}function optional_identifier(){if(next_token.identifier){advance();if(option.safe&&banned[token.string]){warn('adsafe_a',token)}else if(token.reserved&&!option.es5){warn('expected_identifier_a_reserved',token)}return token.string}}function identifier(){var i=optional_identifier();if(!i){stop(token.id==='function'&&next_token.id==='('?'name_function':'expected_identifier_a')}return i}function statement(){var a,old_scope=scope,the_statement;if(next_token.id===';'){warn('unexpected_a');semicolon();return}if(next_token.identifier&&!next_token.reserved&&peek().id===':'){edge('label');a=next_token;advance();advance(':');scope=Object.create(old_scope);add_label(a,'label');if(next_token.labeled!==true){warn('label_a_b',next_token,a.string,artifact())}else if(jx.test(a.string+':')){warn('url',a)}else if(funct===global_funct){stop('unexpected_a',token)}next_token.label=a}if(token.id!=='else'){edge()}step_in('statement');the_statement=expression(0,true);if(the_statement){if(the_statement.arity==='statement'){if(the_statement.id==='switch'||(the_statement.block&&the_statement.id!=='do')){spaces()}else{semicolon()}}else{if(the_statement.id==='('){if(the_statement.first.id==='new'){warn('bad_new')}}else if(!the_statement.assign&&the_statement.id!=='delete'&&the_statement.id!=='++'&&the_statement.id!=='--'){warn('assignment_function_expression',token)}semicolon()}}step_out();scope=old_scope;return the_statement}function statements(){var a=[],disruptor,the_statement;while(next_token.postscript!==true){if(next_token.id===';'){warn('unexpected_a',next_token);semicolon()}else{if(next_token.string==='use strict'){if((!node_js&&xmode!=='script')||funct!==global_funct||a.length>0){warn('function_strict')}use_strict()}if(disruptor){warn('unreachable_a_b',next_token,next_token.string,disruptor.string);disruptor=null}the_statement=statement();if(the_statement){a.push(the_statement);if(the_statement.disrupt){disruptor=the_statement;a.disrupt=true}}}}return a}function block(a){var b,curly=next_token,old_in_block=in_block,old_scope=scope,old_strict_mode=strict_mode;in_block=a;scope=Object.create(scope);spaces();if(next_token.id==='{'){advance('{');step_in();if(!a&&!use_strict()&&!old_strict_mode&&!option.sloppy&&funct['(context)']===global_funct){warn('missing_use_strict')}b=statements();strict_mode=old_strict_mode;step_out('}',curly)}else if(!a){stop('expected_a_b',next_token,'{',artifact())}else{warn('expected_a_b',next_token,'{',artifact());b=[statement()];b.disrupt=b[0].disrupt}funct['(verb)']=null;scope=old_scope;in_block=old_in_block;if(a&&b.length===0){warn('empty_block')}return b}function tally_property(a){if(option.properties&&typeof property[a]!=='number'){warn('unexpected_property_a',token,a)}if(typeof property[a]==='number'){property[a]+=1}else{property[a]=1}}syntax['(identifier)']={id:'(identifier)',lbp:0,identifier:true,nud:function(){var a=this.string,variable=scope[a],site,writeable;if(typeof variable!=='object'){writeable=predefined[a];if(typeof writeable==='boolean'){global_scope[a]=variable={string:a,writeable:writeable,funct:global_funct};global_funct[a]='var'}else{if(!option.undef){warn('used_before_a',token)}scope[a]=variable={string:a,writeable:true,funct:funct};funct[a]='undef'}}site=variable.funct;if(funct===site){switch(funct[a]){case'becoming':warn('unexpected_a',token);funct[a]='var';break;case'unused':funct[a]='var';break;case'unparam':funct[a]='parameter';break;case'unction':funct[a]='function';break;case'label':warn('a_label',token,a);break}}else{switch(funct[a]){case'closure':case'function':case'var':case'unused':warn('a_scope',token,a);break;case'label':warn('a_label',token,a);break;case'outer':case'global':break;default:switch(site[a]){case'becoming':case'closure':case'function':case'parameter':case'unction':case'unused':case'var':site[a]='closure';funct[a]=site===global_funct?'global':'outer';break;case'unparam':site[a]='parameter';funct[a]='outer';break;case'undef':funct[a]='undef';break;case'label':warn('a_label',token,a);break}}}return this},led:function(){stop('expected_operator_a')}};type('(array)','array');type('(color)','color');type('(function)','function');type('(number)','number',return_this);type('(object)','object');type('(string)','string',return_this);type('(boolean)','boolean',return_this);type('(range)','range');type('(regexp)','regexp',return_this);ultimate('(begin)');ultimate('(end)');ultimate('(error)');postscript(symbol('</'));symbol('<!');symbol('<!--');symbol('-->');postscript(symbol('}'));symbol(')');symbol(']');postscript(symbol('"'));postscript(symbol('\''));symbol(';');symbol(':');symbol(',');symbol('#');symbol('@');symbol('*/');postscript(reserve('case'));reserve('catch');postscript(reserve('default'));reserve('else');reserve('finally');reservevar('arguments',function(x){if(strict_mode&&funct===global_funct){warn('strict',x)}else if(option.safe){warn('adsafe_a',x)}funct['(arguments)']=true});reservevar('eval',function(x){if(option.safe){warn('adsafe_a',x)}});constant('false','boolean');constant('Infinity','number');constant('NaN','number');constant('null','');reservevar('this',function(x){if(option.safe){warn('adsafe_a',x)}else if(strict_mode&&funct['(token)'].arity==='statement'&&funct['(name)'].charAt(0)>'Z'){warn('strict',x)}});constant('true','boolean');constant('undefined','');infix('?',30,function(a,b){step_in('?');b.first=expected_condition(expected_relation(a));b.second=expression(0);spaces();step_out();var c=next_token;advance(':');step_in(':');spaces();b.third=expression(10);b.arity='ternary';if(are_similar(b.second,b.third)){warn('weird_ternary',c)}else if(are_similar(b.first,b.second)){warn('use_or',b)}step_out();return b});infix('||',40,function(b,c){function paren_check(a){if(a.id==='&&'&&!a.paren){warn('and',a)}return a}c.first=paren_check(expected_condition(expected_relation(b)));c.second=paren_check(expected_relation(expression(40)));if(are_similar(c.first,c.second)){warn('weird_condition',c)}return c});infix('&&',50,function(a,b){b.first=expected_condition(expected_relation(a));b.second=expected_relation(expression(50));if(are_similar(b.first,b.second)){warn('weird_condition',b)}return b});prefix('void',function(){this.first=expression(0);this.arity='prefix';if(option.es5){warn('expected_a_b',this,'undefined','void')}else if(this.first.number!==0){warn('expected_a_b',this.first,'0',artifact(this.first))}return this});bitwise('|',70);bitwise('^',80);bitwise('&',90);relation('==','===');relation('===');relation('!=','!==');relation('!==');relation('<');relation('>');relation('<=');relation('>=');bitwise('<<',120);bitwise('>>',120);bitwise('>>>',120);infix('in',120,function(a,b){warn('infix_in',b);b.left=a;b.right=expression(130);return b});infix('instanceof',120);infix('+',130,function(a,b){if(a.id==='(number)'){if(a.number===0){warn('unexpected_a',a,'0')}}else if(a.id==='(string)'){if(a.string===''){warn('expected_a_b',a,'String','\'\'')}}var c=expression(130);if(c.id==='(number)'){if(c.number===0){warn('unexpected_a',c,'0')}}else if(c.id==='(string)'){if(c.string===''){warn('expected_a_b',c,'String','\'\'')}}if(a.id===c.id){if(a.id==='(string)'||a.id==='(number)'){if(a.id==='(string)'){a.string+=c.string;if(jx.test(a.string)){warn('url',a)}}else{a.number+=c.number}a.thru=c.thru;return a}}b.first=a;b.second=c;return b});prefix('+','num');prefix('+++',function(){warn('confusing_a',token);this.first=expression(150);this.arity='prefix';return this});infix('+++',130,function(a){warn('confusing_a',token);this.first=a;this.second=expression(130);return this});infix('-',130,function(a,b){if((a.id==='(number)'&&a.number===0)||a.id==='(string)'){warn('unexpected_a',a)}var c=expression(130);if((c.id==='(number)'&&c.number===0)||c.id==='(string)'){warn('unexpected_a',c)}if(a.id===c.id&&a.id==='(number)'){a.number-=c.number;a.thru=c.thru;return a}b.first=a;b.second=c;return b});prefix('-');prefix('---',function(){warn('confusing_a',token);this.first=expression(150);this.arity='prefix';return this});infix('---',130,function(a){warn('confusing_a',token);this.first=a;this.second=expression(130);return this});infix('*',140,function(a,b){if((a.id==='(number)'&&(a.number===0||a.number===1))||a.id==='(string)'){warn('unexpected_a',a)}var c=expression(140);if((c.id==='(number)'&&(c.number===0||c.number===1))||c.id==='(string)'){warn('unexpected_a',c)}if(a.id===c.id&&a.id==='(number)'){a.number*=c.number;a.thru=c.thru;return a}b.first=a;b.second=c;return b});infix('/',140,function(a,b){if((a.id==='(number)'&&a.number===0)||a.id==='(string)'){warn('unexpected_a',a)}var c=expression(140);if((c.id==='(number)'&&(c.number===0||c.number===1))||c.id==='(string)'){warn('unexpected_a',c)}if(a.id===c.id&&a.id==='(number)'){a.number/=c.number;a.thru=c.thru;return a}b.first=a;b.second=c;return b});infix('%',140,function(a,b){if((a.id==='(number)'&&(a.number===0||a.number===1))||a.id==='(string)'){warn('unexpected_a',a)}var c=expression(140);if((c.id==='(number)'&&c.number===0)||c.id==='(string)'){warn('unexpected_a',c)}if(a.id===c.id&&a.id==='(number)'){a.number%=c.number;a.thru=c.thru;return a}b.first=a;b.second=c;return b});suffix('++');prefix('++');suffix('--');prefix('--');prefix('delete',function(){one_space();var p=expression(0);if(!p||(p.id!=='.'&&p.id!=='[')){warn('deleted')}this.first=p;return this});prefix('~',function(){no_space_only();if(!option.bitwise){warn('unexpected_a',this)}expression(150);return this});prefix('!',function(){no_space_only();this.first=expected_condition(expression(150));this.arity='prefix';if(bang[this.first.id]===true||this.first.assign){warn('confusing_a',this)}return this});prefix('typeof',null);prefix('new',function(){one_space();var c=expression(160),n,p,v;this.first=c;if(c.id!=='function'){if(c.identifier){switch(c.string){case'Object':warn('use_object',token);break;case'Array':if(next_token.id==='('){p=next_token;p.first=this;advance('(');if(next_token.id!==')'){n=expression(0);p.second=[n];if(n.id!=='(number)'||next_token.id===','){warn('use_array',p)}while(next_token.id===','){advance(',');p.second.push(expression(0))}}else{warn('use_array',token)}advance(')',p);return p}warn('use_array',token);break;case'Number':case'String':case'Boolean':case'Math':case'JSON':warn('not_a_constructor',c);break;case'Function':if(!option.evil){warn('function_eval')}break;case'Date':case'RegExp':case'this':break;default:if(c.id!=='function'){v=c.string.charAt(0);if(!option.newcap&&(v<'A'||v>'Z')){warn('constructor_name_a',token)}}}}else{if(c.id!=='.'&&c.id!=='['&&c.id!=='('){warn('bad_constructor',token)}}}else{warn('weird_new',this)}if(next_token.id!=='('){warn('missing_a',next_token,'()')}return this});infix('(',160,function(a,b){var p;if(indent&&indent.mode==='expression'){no_space(prev_token,token)}else{no_space_only(prev_token,token)}if(!a.immed&&a.id==='function'){warn('wrap_immediate')}p=[];if(a.identifier){if(a.string.match(/^[A-Z]([A-Z0-9_$]*[a-z][A-Za-z0-9_$]*)?$/)){if(a.string!=='Number'&&a.string!=='String'&&a.string!=='Boolean'&&a.string!=='Date'){if(a.string==='Math'||a.string==='JSON'){warn('not_a_function',a)}else if(a.string==='Object'){warn('use_object',token)}else if(a.string==='Array'||!option.newcap){warn('missing_a',a,'new')}}}}else if(a.id==='.'){if(option.safe&&a.first.string==='Math'&&a.second==='random'){warn('adsafe_a',a)}else if(a.second.string==='split'&&a.first.id==='(string)'){warn('use_array',a.second)}}step_in();if(next_token.id!==')'){no_space();for(;;){edge();p.push(expression(10));if(next_token.id!==','){break}comma()}}no_space();step_out(')',b);if(typeof a==='object'){if(a.string==='parseInt'&&p.length===1){warn('radix',a)}if(!option.evil){if(a.string==='eval'||a.string==='Function'||a.string==='execScript'){warn('evil',a)}else if(p[0]&&p[0].id==='(string)'&&(a.string==='setTimeout'||a.string==='setInterval')){warn('implied_evil',a)}}if(!a.identifier&&a.id!=='.'&&a.id!=='['&&a.id!=='('&&a.id!=='&&'&&a.id!=='||'&&a.id!=='?'){warn('bad_invocation',a)}}b.first=a;b.second=p;return b},true);prefix('(',function(){step_in('expression');no_space();edge();if(next_token.id==='function'){next_token.immed=true}var a=expression(0);a.paren=true;no_space();step_out(')',this);if(a.id==='function'){switch(next_token.id){case'(':warn('move_invocation');break;case'.':case'[':warn('unexpected_a');break;default:warn('bad_wrap',this)}}return a});infix('.',170,function(a,b){no_space(prev_token,token);no_space();var c=identifier();if(typeof c==='string'){tally_property(c)}b.first=a;b.second=token;if(a&&a.string==='arguments'&&(c==='callee'||c==='caller')){warn('avoid_a',a,'arguments.'+c)}else if(!option.evil&&a&&a.string==='document'&&(c==='write'||c==='writeln')){warn('write_is_wrong',a)}else if(option.adsafe){if(!adsafe_top&&a.string==='ADSAFE'){if(c==='id'||c==='lib'){warn('adsafe_a',b)}else if(c==='go'){if(xmode!=='script'){warn('adsafe_a',b)}else if(adsafe_went||next_token.id!=='('||peek(0).id!=='(string)'||peek(0).string!==k||peek(1).id!==','){stop('adsafe_a',b,'go')}adsafe_went=true;adsafe_may=false}}adsafe_top=false}if(!option.evil&&(c==='eval'||c==='execScript')){warn('evil')}else if(option.safe){for(;;){if(banned[c]===true){warn('adsafe_a',token,c)}if(typeof predefined[a.string]!=='boolean'||next_token.id==='('){break}if(next_token.id!=='.'){warn('adsafe_a',b);break}advance('.');token.first=b;token.second=c;b=token;c=identifier();if(typeof c==='string'){tally_property(c)}}}return b},true);infix('[',170,function(a,b){var e,s;no_space_only(prev_token,token);no_space();step_in();edge();e=expression(0);switch(e.id){case'(number)':if(e.id==='(number)'&&a.id==='arguments'){warn('use_param',a)}break;case'(string)':if(option.safe&&(banned[e.string]||e.string.charAt(0)==='_'||e.string.slice(-1)==='_')){warn('adsafe_subscript_a',e)}else if(!option.evil&&(e.string==='eval'||e.string==='execScript')){warn('evil',e)}else if(!option.sub&&ix.test(e.string)){s=syntax[e.string];if(!s||!s.reserved){warn('subscript',e)}}tally_property(e.string);break;default:if(option.safe){warn('adsafe_subscript_a',e)}}step_out(']',b);no_space(prev_token,token);b.first=a;b.second=e;return b},true);prefix('[',function(){this.arity='prefix';this.first=[];step_in('array');while(next_token.id!=='(end)'){while(next_token.id===','){warn('unexpected_a',next_token);advance(',')}if(next_token.id===']'){break}indent.wrap=false;edge();this.first.push(expression(10));if(next_token.id===','){comma();if(next_token.id===']'&&!option.es5){warn('unexpected_a',token);break}}else{break}}step_out(']',this);return this},170);function property_name(){var a=optional_identifier(true);if(!a){if(next_token.id==='(string)'){a=next_token.string;if(option.safe){if(banned[a]){warn('adsafe_a')}else if(a.charAt(0)==='_'||a.charAt(a.length-1)==='_'){warn('dangling_a')}}advance()}else if(next_token.id==='(number)'){a=next_token.number.toString();advance()}}return a}function function_params(){var a,paren=next_token,params=[];advance('(');step_in();no_space();if(next_token.id===')'){no_space();step_out(')',paren);return params}for(;;){edge();a=identifier();params.push(token);add_label(token,option.unparam?'parameter':'unparam');if(next_token.id===','){comma()}else{no_space();step_out(')',paren);return params}}}function do_function(b,c){var d=funct,old_option=option,old_scope=scope;funct={'(name)':c||'\''+(anonname||'').replace(nx,sanitize)+'\'','(line)':next_token.line,'(context)':d,'(breakage)':0,'(loopage)':0,'(scope)':scope,'(token)':b};option=Object.create(old_option);scope=Object.create(old_scope);functions.push(funct);b.name=c;if(c){add_label(b,'function',c)}b.writeable=false;b.first=funct['(params)']=function_params();one_space();b.block=block(false);if(funct['(arguments)']){b.first.forEach(function(a){if(a.assign){warn('parameter_arguments_a',a,a.string)}})}funct=d;option=old_option;scope=old_scope}assignop('=');assignop('+=','+');assignop('-=','-');assignop('*=','*');assignop('/=','/').nud=function(){stop('slash_equal')};assignop('%=','%');assignop('&=','&');assignop('|=','|');assignop('^=','^');assignop('<<=','<<');assignop('>>=','>>');assignop('>>>=','>>>');prefix('{',function(){var a,i,j,name,p,set,seen={};this.arity='prefix';this.first=[];step_in();while(next_token.id!=='}'){indent.wrap=false;edge();if(next_token.string==='get'&&peek().id!==':'){if(!option.es5){warn('es5')}a=next_token;advance('get');one_space_only();name=next_token;i=property_name();if(!i){stop('missing_property')}a.string='';do_function(a);if(funct['(loopage)']){warn('function_loop',a)}p=a.first;if(p){warn('parameter_a_get_b',p[0],p[0].string,i)}comma();set=next_token;spaces();edge();advance('set');set.string='';one_space_only();j=property_name();if(i!==j){stop('expected_a_b',token,i,j||next_token.string)}do_function(set);if(set.block.length===0){warn('missing_a',token,'throw')}p=set.first;if(!p||p.length!==1){stop('parameter_set_a',set,'value')}else if(p[0].string!=='value'){stop('expected_a_b',p[0],'value',p[0].string)}name.first=[a,set]}else{name=next_token;i=property_name();if(typeof i!=='string'){stop('missing_property')}advance(':');spaces();name.first=expression(10)}this.first.push(name);if(seen[i]===true){warn('duplicate_a',next_token,i)}seen[i]=true;tally_property(i);if(next_token.id!==','){break}for(;;){comma();if(next_token.id!==','){break}warn('unexpected_a',next_token)}if(next_token.id==='}'&&!option.es5){warn('unexpected_a',token)}}step_out('}',this);return this});stmt('{',function(){warn('statement_block');this.arity='statement';this.block=statements();this.disrupt=this.block.disrupt;advance('}',this);return this});stmt('/*global',directive);stmt('/*globals',directive);stmt('/*jslint',directive);stmt('/*member',directive);stmt('/*members',directive);stmt('/*property',directive);stmt('/*properties',directive);stmt('var',function(){var a,id,name;if(funct['(vars)']&&!option.vars){warn('combine_var')}else if(funct!==global_funct){funct['(vars)']=true}this.arity='statement';this.first=[];step_in('var');for(;;){name=next_token;id=identifier();add_label(name,'becoming');if(next_token.id==='='){a=next_token;a.first=name;spaces();advance('=');spaces();if(next_token.id==='undefined'){warn('unnecessary_initialize',token,id)}if(peek(0).id==='='&&next_token.identifier){stop('var_a_not')}a.second=expression(0);a.arity='infix';this.first.push(a)}else{this.first.push(name)}if(funct[id]==='becoming'){funct[id]='unused'}if(next_token.id!==','){break}comma();indent.wrap=false;if(var_mode&&next_token.line===token.line&&this.first.length===1){var_mode=null;indent.open=false;indent.at-=option.indent}spaces();edge()}var_mode=null;step_out();return this});stmt('function',function(){one_space();if(in_block){warn('function_block',token)}var a=next_token,id=identifier();add_label(a,'unction');no_space();this.arity='statement';do_function(this,id);if(next_token.id==='('&&next_token.line===token.line){stop('function_statement')}return this});prefix('function',function(){if(!option.anon){one_space()}var a=optional_identifier();if(a){no_space()}else{a=''}do_function(this,a);if(funct['(loopage)']){warn('function_loop')}switch(next_token.id){case';':case'(':case')':case',':case']':case'}':case':':break;case'.':if(peek().string!=='bind'||peek(1).id!=='('){warn('unexpected_a')}break;default:stop('unexpected_a')}this.arity='function';return this});stmt('if',function(){var a=next_token;one_space();advance('(');step_in('control');no_space();edge();this.arity='statement';this.first=expected_condition(expected_relation(expression(0)));no_space();step_out(')',a);one_space();this.block=block(true);if(next_token.id==='else'){one_space();advance('else');one_space();this['else']=next_token.id==='if'||next_token.id==='switch'?statement(true):block(true);if(this['else'].disrupt&&this.block.disrupt){this.disrupt=true}}return this});stmt('try',function(){var a,old_scope,paren;if(option.adsafe){warn('adsafe_a',this)}one_space();this.arity='statement';this.block=block(false);if(next_token.id==='catch'){one_space();advance('catch');one_space();paren=next_token;advance('(');step_in('control');no_space();edge();old_scope=scope;scope=Object.create(old_scope);a=next_token.string;this.first=a;if(!next_token.identifier){warn('expected_identifier_a',next_token)}else{add_label(next_token,'exception')}advance();no_space();step_out(')',paren);one_space();this.second=block(false);scope=old_scope}if(next_token.id==='finally'){one_space();advance('finally');one_space();this.third=block(false)}else if(!this.second){stop('expected_a_b',next_token,'catch',artifact())}return this});labeled_stmt('while',function(){one_space();var a=next_token;funct['(breakage)']+=1;funct['(loopage)']+=1;advance('(');step_in('control');no_space();edge();this.arity='statement';this.first=expected_relation(expression(0));if(this.first.id!=='true'){expected_condition(this.first,bundle.unexpected_a)}no_space();step_out(')',a);one_space();this.block=block(true);if(this.block.disrupt){warn('strange_loop',prev_token)}funct['(breakage)']-=1;funct['(loopage)']-=1;return this});reserve('with');labeled_stmt('switch',function(){var b=[],old_in_block=in_block,particular,the_case=next_token,unbroken=true;function find_duplicate_case(a){if(are_similar(particular,a)){warn('duplicate_a',a)}}funct['(breakage)']+=1;one_space();advance('(');no_space();step_in();this.arity='statement';this.first=expected_condition(expected_relation(expression(0)));no_space();step_out(')',the_case);one_space();advance('{');step_in();in_block=true;this.second=[];while(next_token.id==='case'){the_case=next_token;b.forEach(find_duplicate_case);the_case.first=[];the_case.arity='case';spaces();edge('case');advance('case');for(;;){one_space();particular=expression(0);b.forEach(find_duplicate_case);b.push(particular);the_case.first.push(particular);if(particular.id==='NaN'){warn('unexpected_a',particular)}no_space_only();advance(':');if(next_token.id!=='case'){break}spaces();edge('case');advance('case')}spaces();the_case.second=statements();if(the_case.second&&the_case.second.length>0){particular=the_case.second[the_case.second.length-1];if(particular.disrupt){if(particular.id==='break'){unbroken=false}}else{warn('missing_a_after_b',next_token,'break','case')}}else{warn('empty_case')}this.second.push(the_case)}if(this.second.length===0){warn('missing_a',next_token,'case')}if(next_token.id==='default'){spaces();the_case=next_token;the_case.arity='case';edge('case');advance('default');no_space_only();advance(':');spaces();the_case.second=statements();if(the_case.second&&the_case.second.length>0){particular=the_case.second[the_case.second.length-1];if(unbroken&&particular.disrupt&&particular.id!=='break'){this.disrupt=true}}this.second.push(the_case)}funct['(breakage)']-=1;spaces();step_out('}',this);in_block=old_in_block;return this});stmt('debugger',function(){if(!option.debug){warn('unexpected_a',this)}this.arity='statement';return this});labeled_stmt('do',function(){funct['(breakage)']+=1;funct['(loopage)']+=1;one_space();this.arity='statement';this.block=block(true);if(this.block.disrupt){warn('strange_loop',prev_token)}one_space();advance('while');var a=next_token;one_space();advance('(');step_in();no_space();edge();this.first=expected_condition(expected_relation(expression(0)),bundle.unexpected_a);no_space();step_out(')',a);funct['(breakage)']-=1;funct['(loopage)']-=1;return this});labeled_stmt('for',function(){var a,filter,ok=false,paren=next_token,value;this.arity='statement';funct['(breakage)']+=1;funct['(loopage)']+=1;advance('(');if(next_token.id===';'){no_space();advance(';');no_space();advance(';');no_space();advance(')');a=block(true)}else{step_in('control');spaces(this,paren);no_space();if(next_token.id==='var'){stop('move_var')}edge();if(peek(0).id==='in'){this.forin=true;value=next_token;switch(funct[value.string]){case'unused':funct[value.string]='var';break;case'closure':case'var':break;default:warn('bad_in_a',value)}advance();advance('in');this.first=value;this.second=expression(20);step_out(')',paren);a=block(true);if(!option.forin){if(a.length===1&&typeof a[0]==='object'&&a[0].string==='if'&&!a[0]['else']){filter=a[0].first;while(filter.id==='&&'){filter=filter.first}switch(filter.id){case'===':case'!==':ok=filter.first.id==='['?filter.first.first.string===this.second.string&&filter.first.second.string===this.first.string:filter.first.id==='typeof'&&filter.first.first.id==='['&&filter.first.first.first.string===this.second.string&&filter.first.first.second.string===this.first.string;break;case'(':ok=filter.first.id==='.'&&((filter.first.first.string===this.second.string&&filter.first.second.string==='hasOwnProperty'&&filter.second[0].string===this.first.string)||(filter.first.first.string==='ADSAFE'&&filter.first.second.string==='has'&&filter.second[0].string===this.second.string&&filter.second[1].string===this.first.string)||(filter.first.first.id==='.'&&filter.first.first.first.id==='.'&&filter.first.first.first.first.string==='Object'&&filter.first.first.first.second.string==='prototype'&&filter.first.first.second.string==='hasOwnProperty'&&filter.first.second.string==='call'&&filter.second[0].string===this.second.string&&filter.second[1].string===this.first.string));break}}if(!ok){warn('for_if',this)}}}else{edge();this.first=[];for(;;){this.first.push(expression(0,'for'));if(next_token.id!==','){break}comma()}semicolon();edge();this.second=expected_relation(expression(0));if(this.second.id!=='true'){expected_condition(this.second,bundle.unexpected_a)}semicolon(token);if(next_token.id===';'){stop('expected_a_b',next_token,')',';')}this.third=[];edge();for(;;){this.third.push(expression(0,'for'));if(next_token.id!==','){break}comma()}no_space();step_out(')',paren);one_space();a=block(true)}}if(a.disrupt){warn('strange_loop',prev_token)}this.block=a;funct['(breakage)']-=1;funct['(loopage)']-=1;return this});disrupt_stmt('break',function(){var a=next_token.string;this.arity='statement';if(funct['(breakage)']===0){warn('unexpected_a',this)}if(next_token.identifier&&token.line===next_token.line){one_space_only();if(funct[a]!=='label'){warn('not_a_label',next_token)}else if(scope[a].funct!==funct){warn('not_a_scope',next_token)}this.first=next_token;advance()}return this});disrupt_stmt('continue',function(){if(!option['continue']){warn('unexpected_a',this)}var a=next_token.string;this.arity='statement';if(funct['(breakage)']===0){warn('unexpected_a',this)}if(next_token.identifier&&token.line===next_token.line){one_space_only();if(funct[a]!=='label'){warn('not_a_label',next_token)}else if(scope[a].funct!==funct){warn('not_a_scope',next_token)}this.first=next_token;advance()}return this});disrupt_stmt('return',function(){if(funct===global_funct&&xmode!=='scriptstring'){warn('unexpected_a',this)}this.arity='statement';if(next_token.id!==';'&&next_token.line===token.line){one_space_only();if(next_token.id==='/'||next_token.id==='(regexp)'){warn('wrap_regexp')}this.first=expression(20)}return this});disrupt_stmt('throw',function(){this.arity='statement';one_space_only();this.first=expression(20);return this});reserve('class');reserve('const');reserve('enum');reserve('export');reserve('extends');reserve('import');reserve('super');reserve('implements');reserve('interface');reserve('let');reserve('package');reserve('private');reserve('protected');reserve('public');reserve('static');reserve('yield');function json_value(){function json_object(){var a=next_token,object={};advance('{');if(next_token.id!=='}'){while(next_token.id!=='(end)'){while(next_token.id===','){warn('unexpected_a',next_token);advance(',')}if(next_token.id!=='(string)'){warn('expected_string_a')}if(object[next_token.string]===true){warn('duplicate_a')}else if(next_token.string==='__proto__'){warn('dangling_a')}else{object[next_token.string]=true}advance();advance(':');json_value();if(next_token.id!==','){break}advance(',');if(next_token.id==='}'){warn('unexpected_a',token);break}}}advance('}',a)}function json_array(){var a=next_token;advance('[');if(next_token.id!==']'){while(next_token.id!=='(end)'){while(next_token.id===','){warn('unexpected_a',next_token);advance(',')}json_value();if(next_token.id!==','){break}advance(',');if(next_token.id===']'){warn('unexpected_a',token);break}}}advance(']',a)}switch(next_token.id){case'{':json_object();break;case'[':json_array();break;case'true':case'false':case'null':case'(number)':case'(string)':advance();break;case'-':advance('-');no_space_only();advance('(number)');break;default:stop('unexpected_a')}}function css_name(){if(next_token.identifier){advance();return true}}function css_number(){if(next_token.id==='-'){advance('-');no_space_only()}if(next_token.id==='(number)'){advance('(number)');return true}}function css_string(){if(next_token.id==='(string)'){advance();return true}}function css_color(){var i,number,paren,value;if(next_token.identifier){value=next_token.string;if(value==='rgb'||value==='rgba'){advance();paren=next_token;advance('(');for(i=0;i<3;i+=1){if(i){comma()}number=next_token.number;if(next_token.id!=='(number)'||number<0){warn('expected_positive_a',next_token);advance()}else{advance();if(next_token.id==='%'){advance('%');if(number>100){warn('expected_percent_a',token,number)}}else{if(number>255){warn('expected_small_a',token,number)}}}}if(value==='rgba'){comma();number=next_token.number;if(next_token.id!=='(number)'||number<0||number>1){warn('expected_fraction_a',next_token)}advance();if(next_token.id==='%'){warn('unexpected_a');advance('%')}}advance(')',paren);return true}else if(css_colorData[next_token.string]===true){advance();return true}}else if(next_token.id==='(color)'){advance();return true}return false}function css_length(){if(next_token.id==='-'){advance('-');no_space_only()}if(next_token.id==='(number)'){advance();if(next_token.id!=='(string)'&&css_lengthData[next_token.string]===true){no_space_only();advance()}else if(+token.number!==0){warn('expected_linear_a')}return true}return false}function css_line_height(){if(next_token.id==='-'){advance('-');no_space_only()}if(next_token.id==='(number)'){advance();if(next_token.id!=='(string)'&&css_lengthData[next_token.string]===true){no_space_only();advance()}return true}return false}function css_width(){if(next_token.identifier){switch(next_token.string){case'thin':case'medium':case'thick':advance();return true}}else{return css_length()}}function css_margin(){if(next_token.identifier){if(next_token.string==='auto'){advance();return true}}else{return css_length()}}function css_attr(){if(next_token.identifier&&next_token.string==='attr'){advance();advance('(');if(!next_token.identifier){warn('expected_name_a')}advance();advance(')');return true}return false}function css_comma_list(){while(next_token.id!==';'){if(!css_name()&&!css_string()){warn('expected_name_a')}if(next_token.id!==','){return true}comma()}}function css_counter(){if(next_token.identifier&&next_token.string==='counter'){advance();advance('(');advance();if(next_token.id===','){comma();if(next_token.id!=='(string)'){warn('expected_string_a')}advance()}advance(')');return true}if(next_token.identifier&&next_token.string==='counters'){advance();advance('(');if(!next_token.identifier){warn('expected_name_a')}advance();if(next_token.id===','){comma();if(next_token.id!=='(string)'){warn('expected_string_a')}advance()}if(next_token.id===','){comma();if(next_token.id!=='(string)'){warn('expected_string_a')}advance()}advance(')');return true}return false}function css_radius(){return css_length()&&(next_token.id!=='(number)'||css_length())}function css_shape(){var i;if(next_token.identifier&&next_token.string==='rect'){advance();advance('(');for(i=0;i<4;i+=1){if(!css_length()){warn('expected_number_a');break}}advance(')');return true}return false}function css_url(){var c,url;if(next_token.identifier&&next_token.string==='url'){next_token=lex.range('(',')');url=next_token.string;c=url.charAt(0);if(c==='"'||c==='\''){if(url.slice(-1)!==c){warn('bad_url_a')}else{url=url.slice(1,-1);if(url.indexOf(c)>=0){warn('bad_url_a')}}}if(!url){warn('missing_url')}if(ux.test(url)){stop('bad_url_a')}urls.push(url);advance();return true}return false}css_any=[css_url,function(){for(;;){if(next_token.identifier){switch(next_token.string.toLowerCase()){case'url':css_url();break;case'expression':warn('unexpected_a');advance();break;default:advance()}}else{if(next_token.id===';'||next_token.id==='!'||next_token.id==='(end)'||next_token.id==='}'){return true}advance()}}}];function font_face(){advance_identifier('font-family');advance(':');if(!css_name()&&!css_string()){stop('expected_name_a')}semicolon();advance_identifier('src');advance(':');while(true){if(next_token.string==='local'){advance_identifier('local');advance('(');if(ux.test(next_token.string)){stop('bad_url_a')}if(!css_name()&&!css_string()){stop('expected_name_a')}advance(')')}else if(!css_url()){stop('expected_a_b',next_token,'url',artifact())}if(next_token.id!==','){break}comma()}semicolon()}css_border_style=['none','dashed','dotted','double','groove','hidden','inset','outset','ridge','solid'];css_break=['auto','always','avoid','left','right'];css_media={'all':true,'braille':true,'embossed':true,'handheld':true,'print':true,'projection':true,'screen':true,'speech':true,'tty':true,'tv':true};css_overflow=['auto','hidden','scroll','visible'];css_attribute_data={background:[true,'background-attachment','background-color','background-image','background-position','background-repeat'],'background-attachment':['scroll','fixed'],'background-color':['transparent',css_color],'background-image':['none',css_url],'background-position':[2,[css_length,'top','bottom','left','right','center']],'background-repeat':['repeat','repeat-x','repeat-y','no-repeat'],'border':[true,'border-color','border-style','border-width'],'border-bottom':[true,'border-bottom-color','border-bottom-style','border-bottom-width'],'border-bottom-color':css_color,'border-bottom-left-radius':css_radius,'border-bottom-right-radius':css_radius,'border-bottom-style':css_border_style,'border-bottom-width':css_width,'border-collapse':['collapse','separate'],'border-color':['transparent',4,css_color],'border-left':[true,'border-left-color','border-left-style','border-left-width'],'border-left-color':css_color,'border-left-style':css_border_style,'border-left-width':css_width,'border-radius':function(){function count(a){var n=1;if(a){advance(a)}if(!css_length()){return false}while(next_token.id==='(number)'){if(!css_length()){return false}n+=1}if(n>4){warn('bad_style')}return true}return count()&&(next_token.id!=='/'||count('/'))},'border-right':[true,'border-right-color','border-right-style','border-right-width'],'border-right-color':css_color,'border-right-style':css_border_style,'border-right-width':css_width,'border-spacing':[2,css_length],'border-style':[4,css_border_style],'border-top':[true,'border-top-color','border-top-style','border-top-width'],'border-top-color':css_color,'border-top-left-radius':css_radius,'border-top-right-radius':css_radius,'border-top-style':css_border_style,'border-top-width':css_width,'border-width':[4,css_width],bottom:[css_length,'auto'],'caption-side':['bottom','left','right','top'],clear:['both','left','none','right'],clip:[css_shape,'auto'],color:css_color,content:['open-quote','close-quote','no-open-quote','no-close-quote',css_string,css_url,css_counter,css_attr],'counter-increment':[css_name,'none'],'counter-reset':[css_name,'none'],cursor:[css_url,'auto','crosshair','default','e-resize','help','move','n-resize','ne-resize','nw-resize','pointer','s-resize','se-resize','sw-resize','w-resize','text','wait'],direction:['ltr','rtl'],display:['block','compact','inline','inline-block','inline-table','list-item','marker','none','run-in','table','table-caption','table-cell','table-column','table-column-group','table-footer-group','table-header-group','table-row','table-row-group'],'empty-cells':['show','hide'],'float':['left','none','right'],font:['caption','icon','menu','message-box','small-caption','status-bar',true,'font-size','font-style','font-weight','font-family'],'font-family':css_comma_list,'font-size':['xx-small','x-small','small','medium','large','x-large','xx-large','larger','smaller',css_length],'font-size-adjust':['none',css_number],'font-stretch':['normal','wider','narrower','ultra-condensed','extra-condensed','condensed','semi-condensed','semi-expanded','expanded','extra-expanded'],'font-style':['normal','italic','oblique'],'font-variant':['normal','small-caps'],'font-weight':['normal','bold','bolder','lighter',css_number],height:[css_length,'auto'],left:[css_length,'auto'],'letter-spacing':['normal',css_length],'line-height':['normal',css_line_height],'list-style':[true,'list-style-image','list-style-position','list-style-type'],'list-style-image':['none',css_url],'list-style-position':['inside','outside'],'list-style-type':['circle','disc','square','decimal','decimal-leading-zero','lower-roman','upper-roman','lower-greek','lower-alpha','lower-latin','upper-alpha','upper-latin','hebrew','katakana','hiragana-iroha','katakana-oroha','none'],margin:[4,css_margin],'margin-bottom':css_margin,'margin-left':css_margin,'margin-right':css_margin,'margin-top':css_margin,'marker-offset':[css_length,'auto'],'max-height':[css_length,'none'],'max-width':[css_length,'none'],'min-height':css_length,'min-width':css_length,opacity:css_number,outline:[true,'outline-color','outline-style','outline-width'],'outline-color':['invert',css_color],'outline-style':['dashed','dotted','double','groove','inset','none','outset','ridge','solid'],'outline-width':css_width,overflow:css_overflow,'overflow-x':css_overflow,'overflow-y':css_overflow,padding:[4,css_length],'padding-bottom':css_length,'padding-left':css_length,'padding-right':css_length,'padding-top':css_length,'page-break-after':css_break,'page-break-before':css_break,position:['absolute','fixed','relative','static'],quotes:[8,css_string],right:[css_length,'auto'],'table-layout':['auto','fixed'],'text-align':['center','justify','left','right'],'text-decoration':['none','underline','overline','line-through','blink'],'text-indent':css_length,'text-shadow':['none',4,[css_color,css_length]],'text-transform':['capitalize','uppercase','lowercase','none'],top:[css_length,'auto'],'unicode-bidi':['normal','embed','bidi-override'],'vertical-align':['baseline','bottom','sub','super','top','text-top','middle','text-bottom',css_length],visibility:['visible','hidden','collapse'],'white-space':['normal','nowrap','pre','pre-line','pre-wrap','inherit'],width:[css_length,'auto'],'word-spacing':['normal',css_length],'word-wrap':['break-word','normal'],'z-index':['auto',css_number]};function style_attribute(){var v;while(next_token.id==='*'||next_token.id==='#'||next_token.string==='_'){if(!option.css){warn('unexpected_a')}advance()}if(next_token.id==='-'){if(!option.css){warn('unexpected_a')}advance('-');if(!next_token.identifier){warn('expected_nonstandard_style_attribute')}advance();return css_any}else{if(!next_token.identifier){warn('expected_style_attribute')}else{if(Object.prototype.hasOwnProperty.call(css_attribute_data,next_token.string)){v=css_attribute_data[next_token.string]}else{v=css_any;if(!option.css){warn('unrecognized_style_attribute_a')}}}advance();return v}}function style_value(v){var i=0,n,once,match,round,start=0,vi;switch(typeof v){case'function':return v();case'string':if(next_token.identifier&&next_token.string===v){advance();return true}return false}for(;;){if(i>=v.length){return false}vi=v[i];i+=1;if(typeof vi==='boolean'){break}else if(typeof vi==='number'){n=vi;vi=v[i];i+=1}else{n=1}match=false;while(n>0){if(style_value(vi)){match=true;n-=1}else{break}}if(match){return true}}start=i;once=[];for(;;){round=false;for(i=start;i<v.length;i+=1){if(!once[i]){if(style_value(css_attribute_data[v[i]])){match=true;round=true;once[i]=true;break}}}if(!round){return match}}}function style_child(){if(next_token.id==='(number)'){advance();if(next_token.string==='n'&&next_token.identifier){no_space_only();advance();if(next_token.id==='+'){no_space_only();advance('+');no_space_only();advance('(number)')}}return}else{if(next_token.identifier&&(next_token.string==='odd'||next_token.string==='even')){advance();return}}warn('unexpected_a')}function substyle(){var v;for(;;){if(next_token.id==='}'||next_token.id==='(end)'||(xquote&&next_token.id===xquote)){return}v=style_attribute();advance(':');if(next_token.identifier&&next_token.string==='inherit'){advance()}else{if(!style_value(v)){warn('unexpected_a');advance()}}if(next_token.id==='!'){advance('!');no_space_only();if(next_token.identifier&&next_token.string==='important'){advance()}else{warn('expected_a_b',next_token,'important',artifact())}}if(next_token.id==='}'||next_token.id===xquote){warn('expected_a_b',next_token,';',artifact())}else{semicolon()}}}function style_selector(){if(next_token.identifier){if(!Object.prototype.hasOwnProperty.call(html_tag,option.cap?next_token.string.toLowerCase():next_token.string)){warn('expected_tagname_a')}advance()}else{switch(next_token.id){case'>':case'+':advance();style_selector();break;case':':advance(':');switch(next_token.string){case'active':case'after':case'before':case'checked':case'disabled':case'empty':case'enabled':case'first-child':case'first-letter':case'first-line':case'first-of-type':case'focus':case'hover':case'last-child':case'last-of-type':case'link':case'only-of-type':case'root':case'target':case'visited':advance_identifier(next_token.string);break;case'lang':advance_identifier('lang');advance('(');if(!next_token.identifier){warn('expected_lang_a')}advance(')');break;case'nth-child':case'nth-last-child':case'nth-last-of-type':case'nth-of-type':advance_identifier(next_token.string);advance('(');style_child();advance(')');break;case'not':advance_identifier('not');advance('(');if(next_token.id===':'&&peek(0).string==='not'){warn('not')}style_selector();advance(')');break;default:warn('expected_pseudo_a')}break;case'#':advance('#');if(!next_token.identifier){warn('expected_id_a')}advance();break;case'*':advance('*');break;case'.':advance('.');if(!next_token.identifier){warn('expected_class_a')}advance();break;case'[':advance('[');if(!next_token.identifier){warn('expected_attribute_a')}advance();if(next_token.id==='='||next_token.string==='~='||next_token.string==='$='||next_token.string==='|='||next_token.id==='*='||next_token.id==='^='){advance();if(next_token.id!=='(string)'){warn('expected_string_a')}advance()}advance(']');break;default:stop('expected_selector_a')}}}function style_pattern(){if(next_token.id==='{'){warn('expected_style_pattern')}for(;;){style_selector();if(next_token.id==='</'||next_token.id==='{'||next_token.id==='}'||next_token.id==='(end)'){return''}if(next_token.id===','){comma()}}}function style_list(){while(next_token.id!=='}'&&next_token.id!=='</'&&next_token.id!=='(end)'){style_pattern();xmode='styleproperty';if(next_token.id===';'){semicolon()}else{advance('{');substyle();xmode='style';advance('}')}}}function styles(){var i;while(next_token.id==='@'){i=peek();advance('@');switch(next_token.string){case'import':advance_identifier('import');if(!css_url()){warn('expected_a_b',next_token,'url',artifact());advance()}semicolon();break;case'media':advance_identifier('media');for(;;){if(!next_token.identifier||css_media[next_token.string]!==true){stop('expected_media_a')}advance();if(next_token.id!==','){break}comma()}advance('{');style_list();advance('}');break;case'font-face':advance_identifier('font-face');advance('{');font_face();advance('}');break;default:stop('expected_at_a')}}style_list()}function do_begin(n){if(n!=='html'&&!option.fragment){if(n==='div'&&option.adsafe){stop('adsafe_fragment')}else{stop('expected_a_b',token,'html',n)}}if(option.adsafe){if(n==='html'){stop('adsafe_html',token)}if(option.fragment){if(n!=='div'){stop('adsafe_div',token)}}else{stop('adsafe_fragment',token)}}option.browser=true}function do_attribute(a,v){var u,x;if(a==='id'){u=typeof v==='string'?v.toUpperCase():'';if(ids[u]===true){warn('duplicate_a',next_token,v)}if(!/^[A-Za-z][A-Za-z0-9._:\-]*$/.test(v)){warn('bad_id_a',next_token,v)}else if(option.adsafe){if(k){if(v.slice(0,k.length)!==k){warn('adsafe_prefix_a',next_token,k)}else if(!/^[A-Z]+_[A-Z]+$/.test(v)){warn('adsafe_bad_id')}}else{k=v;if(!/^[A-Z]+_$/.test(v)){warn('adsafe_bad_id')}}}x=v.search(dx);if(x>=0){warn('unexpected_char_a_b',token,v.charAt(x),a)}ids[u]=true}else if(a==='class'||a==='type'||a==='name'){x=v.search(qx);if(x>=0){warn('unexpected_char_a_b',token,v.charAt(x),a)}ids[u]=true}else if(a==='href'||a==='background'||a==='content'||a==='data'||a.indexOf('src')>=0||a.indexOf('url')>=0){if(option.safe&&ux.test(v)){stop('bad_url_a',next_token,v)}urls.push(v)}else if(a==='for'){if(option.adsafe){if(k){if(v.slice(0,k.length)!==k){warn('adsafe_prefix_a',next_token,k)}else if(!/^[A-Z]+_[A-Z]+$/.test(v)){warn('adsafe_bad_id')}}else{warn('adsafe_bad_id')}}}else if(a==='name'){if(option.adsafe&&v.indexOf('_')>=0){warn('adsafe_name_a',next_token,v)}}}function do_tag(a,b){var i,tag=html_tag[a],script,x;src=false;if(!tag){stop(bundle.unrecognized_tag_a,next_token,a===a.toLowerCase()?a:a+' (capitalization error)')}if(stack.length>0){if(a==='html'){stop('unexpected_a',token,a)}x=tag.parent;if(x){if(x.indexOf(' '+stack[stack.length-1].name+' ')<0){stop('tag_a_in_b',token,a,x)}}else if(!option.adsafe&&!option.fragment){i=stack.length;do{if(i<=0){stop('tag_a_in_b',token,a,'body')}i-=1}while(stack[i].name!=='body')}}switch(a){case'div':if(option.adsafe&&stack.length===1&&!k){warn('adsafe_missing_id')}break;case'script':xmode='script';advance('>');if(b.lang){warn('lang',token)}if(option.adsafe&&stack.length!==1){warn('adsafe_placement',token)}if(b.src){if(option.adsafe&&(!adsafe_may||!approved[b.src])){warn('adsafe_source',token)}}else{step_in(next_token.from);edge();use_strict();adsafe_top=true;script=statements();if(option.adsafe){if(adsafe_went){stop('adsafe_script',token)}if(script.length!==1||aint(script[0],'id','(')||aint(script[0].first,'id','.')||aint(script[0].first.first,'string','ADSAFE')||aint(script[0].second[0],'string',k)){stop('adsafe_id_go')}switch(script[0].first.second.string){case'id':if(adsafe_may||adsafe_went||script[0].second.length!==1){stop('adsafe_id',next_token)}adsafe_may=true;break;case'go':if(adsafe_went){stop('adsafe_go')}if(script[0].second.length!==2||aint(script[0].second[1],'id','function')||!script[0].second[1].first||aint(script[0].second[1].first[0],'string','dom')||script[0].second[1].first.length>2||(script[0].second[1].first.length===2&&aint(script[0].second[1].first[1],'string','lib'))){stop('adsafe_go',next_token)}adsafe_went=true;break;default:stop('adsafe_id_go')}}indent=null}xmode='html';advance('</');advance_identifier('script');xmode='outer';break;case'style':xmode='style';advance('>');styles();xmode='html';advance('</');advance_identifier('style');break;case'input':switch(b.type){case'button':case'checkbox':case'radio':case'reset':case'submit':break;case'file':case'hidden':case'image':case'password':case'text':if(option.adsafe&&b.autocomplete!=='off'){warn('adsafe_autocomplete')}break;default:warn('bad_type')}break;case'applet':case'body':case'embed':case'frame':case'frameset':case'head':case'iframe':case'noembed':case'noframes':case'object':case'param':if(option.adsafe){warn('adsafe_tag',next_token,a)}break}}function closetag(a){return'</'+a+'>'}function html(){var a,attributes,is_empty,name,old_white=option.white,quote,tag_name,tag,wmode;xmode='html';xquote='';stack=null;for(;;){switch(next_token.string){case'<':xmode='html';advance('<');attributes={};tag_name=next_token;name=tag_name.string;advance_identifier(name);if(option.cap){name=name.toLowerCase()}tag_name.name=name;if(!stack){stack=[];do_begin(name)}tag=html_tag[name];if(typeof tag!=='object'){stop('unrecognized_tag_a',tag_name,name)}is_empty=tag.empty;tag_name.type=name;for(;;){if(next_token.id==='/'){advance('/');if(next_token.id!=='>'){warn('expected_a_b',next_token,'>',artifact())}break}if(next_token.id&&next_token.id.charAt(0)==='>'){break}if(!next_token.identifier){if(next_token.id==='(end)'||next_token.id==='(error)'){warn('expected_a_b',next_token,'>',artifact())}warn('bad_name_a')}option.white=false;spaces();a=next_token.string;option.white=old_white;advance();if(!option.cap&&a!==a.toLowerCase()){warn('attribute_case_a',token)}a=a.toLowerCase();xquote='';if(Object.prototype.hasOwnProperty.call(attributes,a)){warn('duplicate_a',token,a)}if(a.slice(0,2)==='on'){if(!option.on){warn('html_handlers')}xmode='scriptstring';advance('=');quote=next_token.id;if(quote!=='"'&&quote!=='\''){stop('expected_a_b',next_token,'"',artifact())}xquote=quote;wmode=option.white;option.white=true;advance(quote);use_strict();statements();option.white=wmode;if(next_token.id!==quote){stop('expected_a_b',next_token,quote,artifact())}xmode='html';xquote='';advance(quote);tag=false}else if(a==='style'){xmode='scriptstring';advance('=');quote=next_token.id;if(quote!=='"'&&quote!=='\''){stop('expected_a_b',next_token,'"',artifact())}xmode='styleproperty';xquote=quote;advance(quote);substyle();xmode='html';xquote='';advance(quote);tag=false}else{if(next_token.id==='='){advance('=');tag=next_token.string;if(!next_token.identifier&&next_token.id!=='"'&&next_token.id!=='\''&&next_token.id!=='(string)'&&next_token.id!=='(string)'&&next_token.id!=='(color)'){warn('expected_attribute_value_a',token,a)}advance()}else{tag=true}}attributes[a]=tag;do_attribute(a,tag)}do_tag(name,attributes);if(!is_empty){stack.push(tag_name)}xmode='outer';advance('>');break;case'</':xmode='html';advance('</');if(!next_token.identifier){warn('bad_name_a')}name=next_token.string;if(option.cap){name=name.toLowerCase()}advance();if(!stack){stop('unexpected_a',next_token,closetag(name))}tag_name=stack.pop();if(!tag_name){stop('unexpected_a',next_token,closetag(name))}if(tag_name.name!==name){stop('expected_a_b',next_token,closetag(tag_name.name),closetag(name))}if(next_token.id!=='>'){stop('expected_a_b',next_token,'>',artifact())}xmode='outer';advance('>');break;case'<!':if(option.safe){warn('adsafe_a')}xmode='html';for(;;){advance();if(next_token.id==='>'||next_token.id==='(end)'){break}if(next_token.string.indexOf('--')>=0){stop('unexpected_a',next_token,'--')}if(next_token.string.indexOf('<')>=0){stop('unexpected_a',next_token,'<')}if(next_token.string.indexOf('>')>=0){stop('unexpected_a',next_token,'>')}}xmode='outer';advance('>');break;case'(end)':return;default:if(next_token.id==='(end)'){stop('missing_a',next_token,'</'+stack[stack.length-1].string+'>')}else{advance()}}if(stack&&stack.length===0&&(option.adsafe||!option.fragment||next_token.id==='(end)')){break}}if(next_token.id!=='(end)'){stop('unexpected_a')}}itself=function JSLint(a,b){var i,predef,tree;JSLINT.errors=[];JSLINT.tree='';begin=prev_token=token=next_token=Object.create(syntax['(begin)']);predefined={};add_to_predefined(standard);property={};if(b){option=Object.create(b);predef=option.predef;if(predef){if(Array.isArray(predef)){for(i=0;i<predef.length;i+=1){predefined[predef[i]]=true}}else if(typeof predef==='object'){add_to_predefined(predef)}}do_safe()}else{option={}}option.indent=+option.indent||4;option.maxerr=+option.maxerr||50;k='';adsafe_may=adsafe_top=adsafe_went=false;approved={};if(option.approved){for(i=0;i<option.approved.length;i+=1){approved[option.approved[i]]=option.approved[i]}}else{approved.test='test'}tab='';for(i=0;i<option.indent;i+=1){tab+=' '}global_scope=scope={};global_funct=funct={'(scope)':scope,'(breakage)':0,'(loopage)':0};functions=[funct];comments_off=false;ids={};in_block=false;indent=null;json_mode=false;lookahead=[];node_js=false;prereg=true;src=false;stack=null;strict_mode=false;urls=[];var_mode=null;warnings=0;xmode='';lex.init(a);assume();try{advance();if(next_token.id==='(number)'){stop('unexpected_a')}else if(next_token.string.charAt(0)==='<'){html();if(option.adsafe&&!adsafe_went){warn('adsafe_go',this)}}else{switch(next_token.id){case'{':case'[':json_mode=true;json_value();break;case'@':case'*':case'#':case'.':case':':xmode='style';advance();if(token.id!=='@'||!next_token.identifier||next_token.string!=='charset'||token.line!==1||token.from!==1){stop('css')}advance();if(next_token.id!=='(string)'&&next_token.string!=='UTF-8'){stop('css')}advance();semicolon();styles();break;default:if(option.adsafe&&option.fragment){stop('expected_a_b',next_token,'<div>',artifact())}step_in(1);if(next_token.id===';'&&!node_js){semicolon()}adsafe_top=true;tree=statements();begin.first=tree;JSLINT.tree=begin;if(option.adsafe&&(tree.length!==1||aint(tree[0],'id','(')||aint(tree[0].first,'id','.')||aint(tree[0].first.first,'string','ADSAFE')||aint(tree[0].first.second,'string','lib')||tree[0].second.length!==2||tree[0].second[0].id!=='(string)'||aint(tree[0].second[1],'id','function'))){stop('adsafe_lib')}if(tree.disrupt){warn('weird_program',prev_token)}}}indent=null;advance('(end)')}catch(e){if(e){JSLINT.errors.push({reason:e.message,line:e.line||next_token.line,character:e.character||next_token.from},null)}}return JSLINT.errors.length===0};itself.data=function(){var b={functions:[]},function_data,globals,i,j,kind,members=[],name,the_function,undef=[],unused=[];if(itself.errors.length){b.errors=itself.errors}if(json_mode){b.json=true}if(urls.length>0){b.urls=urls}globals=Object.keys(global_scope).filter(function(a){return a.charAt(0)!=='('&&typeof standard[a]!=='boolean'});if(globals.length>0){b.globals=globals}for(i=1;i<functions.length;i+=1){the_function=functions[i];function_data={};for(j=0;j<functionicity.length;j+=1){function_data[functionicity[j]]=[]}for(name in the_function){if(Object.prototype.hasOwnProperty.call(the_function,name)){if(name.charAt(0)!=='('){kind=the_function[name];if(kind==='unction'||kind==='unparam'){kind='unused'}if(Array.isArray(function_data[kind])){function_data[kind].push(name);if(kind==='unused'){unused.push({name:name,line:the_function['(line)'],'function':the_function['(name)']})}else if(kind==='undef'){undef.push({name:name,line:the_function['(line)'],'function':the_function['(name)']})}}}}}for(j=0;j<functionicity.length;j+=1){if(function_data[functionicity[j]].length===0){delete function_data[functionicity[j]]}}function_data.name=the_function['(name)'];function_data.params=the_function['(params)'];function_data.line=the_function['(line)'];b.functions.push(function_data)}if(unused.length>0){b.unused=unused}if(undef.length>0){b['undefined']=undef}members=[];for(name in property){if(typeof property[name]==='number'){b.member=property;break}}return b};itself.report=function(d){var e=itself.data(),err,evidence,i,italics,j,key,keys,length,mem='',name,names,not_first,output=[],snippets,the_function,warning;function detail(h,b){var c,singularity;if(Array.isArray(b)){output.push('<div><i>'+h+'</i> ');b.sort().forEach(function(a){if(a!==singularity){singularity=a;output.push((c?', ':'')+singularity);c=true}});output.push('</div>')}else if(b){output.push('<div><i>'+h+'</i> '+b+'</div>')}}if(e.errors||e.unused||e['undefined']){err=true;output.push('<div id=errors><i>Error:</i>');if(e.errors){for(i=0;i<e.errors.length;i+=1){warning=e.errors[i];if(warning){evidence=warning.evidence||'';output.push('<p>Problem'+(isFinite(warning.line)?' at line '+String(warning.line)+' character '+String(warning.character):'')+': '+warning.reason.entityify()+'</p><p class=evidence>'+(evidence&&(evidence.length>80?evidence.slice(0,77)+'...':evidence).entityify())+'</p>')}}}if(e['undefined']){snippets=[];for(i=0;i<e['undefined'].length;i+=1){snippets[i]='<code><u>'+e['undefined'][i].name+'</u></code>&nbsp;<i>'+String(e['undefined'][i].line)+' </i> <small>'+e['undefined'][i]['function']+'</small>'}output.push('<p><i>Undefined variable:</i> '+snippets.join(', ')+'</p>')}if(e.unused){snippets=[];for(i=0;i<e.unused.length;i+=1){snippets[i]='<code><u>'+e.unused[i].name+'</u></code>&nbsp;<i>'+String(e.unused[i].line)+' </i> <small>'+e.unused[i]['function']+'</small>'}output.push('<p><i>Unused variable:</i> '+snippets.join(', ')+'</p>')}if(e.json){output.push('<p>JSON: bad.</p>')}output.push('</div>')}if(!d){output.push('<br><div id=functions>');if(e.urls){detail("URLs<br>",e.urls,'<br>')}if(xmode==='style'){output.push('<p>CSS.</p>')}else if(e.json&&!err){output.push('<p>JSON: good.</p>')}else if(e.globals){output.push('<div><i>Global</i> '+e.globals.sort().join(', ')+'</div>')}else{output.push('<div><i>No new global variables introduced.</i></div>')}for(i=0;i<e.functions.length;i+=1){the_function=e.functions[i];names=[];if(the_function.params){for(j=0;j<the_function.params.length;j+=1){names[j]=the_function.params[j].string}}output.push('<br><div class=function><i>'+String(the_function.line)+'</i> '+the_function.name.entityify()+'('+names.join(', ')+')</div>');detail('<big><b>Undefined</b></big>',the_function['undefined']);detail('<big><b>Unused</b></big>',the_function.unused);detail('Closure',the_function.closure);detail('Variable',the_function['var']);detail('Exception',the_function.exception);detail('Outer',the_function.outer);detail('Global',the_function.global);detail('Label',the_function.label)}if(e.member){keys=Object.keys(e.member);if(keys.length){keys=keys.sort();output.push('<br><pre id=properties>/*properties<br>');mem='    ';italics=0;j=0;not_first=false;for(i=0;i<keys.length;i+=1){key=keys[i];if(e.member[key]>0){if(not_first){mem+=', '}name=ix.test(key)?key:'\''+key.entityify().replace(nx,sanitize)+'\'';length+=name.length+2;if(e.member[key]===1){name='<i>'+name+'</i>';italics+=1;j=1}if(mem.length+name.length-(italics*7)>80){output.push(mem+'<br>');mem='    ';italics=j}mem+=name;j=0;not_first=true}}output.push(mem+'<br>*/</pre>')}output.push('</div>')}}return output.join('')};itself.jslint=itself;itself.edition='2012-02-17';return itself}());