/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.model.factory;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.model.factory.GroovyModelParser;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;

public class GroovyModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyModelFactory.class);
    private static final String DEFAULT_FILE_NAME = "wro.groovy";

    public WroModel create() {
        try {
            Script script = new GroovyShell().parse((Reader)new InputStreamReader(this.getModelResourceAsStream()));
            LOG.debug("Parsing groovy script to build the model");
            WroModel model = GroovyModelParser.parse(script);
            LOG.debug("groovy model: {}", (Object)model);
            if (model == null) {
                throw new WroRuntimeException("Invalid content provided, cannot build model!");
            }
            return model;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Invalid model found!", (Throwable)e);
        }
    }

    protected String getDefaultModelFilename() {
        return DEFAULT_FILE_NAME;
    }
}

