/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support;

import org.apache.commons.lang3.Validate;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import ro.isdc.wro.util.ObjectFactory;

public class ObjectPoolHelper<T> {
    private static final int MAX_IDLE = 1;
    private static final byte EXHAUSTED_ACTION = 2;
    private static final long MAX_WAIT = 5000L;
    private GenericObjectPool<T> objectPool;

    public ObjectPoolHelper(final ObjectFactory<T> objectFactory) {
        Validate.notNull(objectFactory);
        int maxActive = Math.max(2, Runtime.getRuntime().availableProcessors());
        this.objectPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory<T>(){

            public T makeObject() throws Exception {
                return objectFactory.create();
            }
        }, maxActive, 2, 5000L, 1);
    }

    public T getObject() {
        try {
            return (T)this.objectPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }

    public void returnObject(T engine) {
        Validate.notNull(engine);
        try {
            this.objectPool.returnObject(engine);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }
}

