/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.jsonhpack;

import java.io.InputStream;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.extensions.script.RhinoUtils;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class JsonHPack {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHPack.class);
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newClientSideAwareChain().addJSON().evaluateChain(this.getScriptAsStream(), "script.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (Exception e) {
            LOG.error("Processing error:" + e.getMessage(), (Throwable)e);
            throw new WroRuntimeException("Processing error", (Throwable)e);
        }
    }

    protected InputStream getScriptAsStream() {
        return JsonHPack.class.getResourceAsStream("json.hpack.min.js");
    }

    public String unpack(String rawData) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("json.hunpack");
        boolean isEnclosedInDoubleArray = this.isEnclosedInDoubleArray(rawData);
        String data = rawData;
        if (!isEnclosedInDoubleArray) {
            data = "[" + data + "]";
        }
        try {
            String execute = "JSON.stringify(JSON.hunpack(eval(" + WroUtil.toJSMultiLineString((String)data) + ")));";
            Object result = builder.evaluate(execute, "unpack");
            String resultAsString = String.valueOf(result);
            if (!isEnclosedInDoubleArray) {
                resultAsString = this.removeEnclosedArray(resultAsString);
            }
            String string = resultAsString;
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    public String pack(String rawData) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("json.hpack");
        boolean isEnclosedInArray = this.isEnclosedInArray(rawData);
        String data = rawData;
        if (!isEnclosedInArray) {
            data = "[" + data + "]";
        }
        try {
            String execute = "JSON.stringify(JSON.hpack(eval(" + WroUtil.toJSMultiLineString((String)data) + "), 4));";
            Object result = builder.evaluate(execute, "pack");
            String resultAsString = String.valueOf(result);
            if (!isEnclosedInArray) {
                resultAsString = this.removeEnclosedArray(resultAsString);
            }
            String string = resultAsString;
            return string;
        }
        catch (RhinoException e) {
            throw new WroRuntimeException(RhinoUtils.createExceptionMessage(e), (Throwable)e);
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    private String removeEnclosedArray(String resultAsString) {
        resultAsString = resultAsString.replaceFirst("(?ims)\\[", "").replaceFirst("(?ims)\\](?!.*\\])", "");
        return resultAsString;
    }

    private boolean isEnclosedInArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[.*\\]");
    }

    private boolean isEnclosedInDoubleArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[\\[.*\\]\\]");
    }
}

