var KEYWORDS=array_to_hash(["break","case","catch","const","continue","debugger","default","delete","do","else","finally","for","function","if","in","instanceof","new","return","switch","throw","try","typeof","var","void","while","with"]);var RESERVED_WORDS=array_to_hash(["abstract","boolean","byte","char","class","double","enum","export","extends","final","float","goto","implements","import","int","interface","long","native","package","private","protected","public","short","static","super","synchronized","throws","transient","volatile"]);var KEYWORDS_BEFORE_EXPRESSION=array_to_hash(["return","new","delete","throw","else","case"]);var KEYWORDS_ATOM=array_to_hash(["false","null","true","undefined"]);var OPERATOR_CHARS=array_to_hash(characters("+-*&%=<>!?|~^"));var RE_HEX_NUMBER=/^0x[0-9a-f]+$/i;var RE_OCT_NUMBER=/^0[0-7]+$/;var RE_DEC_NUMBER=/^\d*\.?\d*(?:e[+-]?\d*(?:\d\.?|\.?\d)\d*)?$/i;var OPERATORS=array_to_hash(["in","instanceof","typeof","new","void","delete","++","--","+","-","!","~","&","|","^","*","/","%",">>","<<",">>>","<",">","<=",">=","==","===","!=","!==","?","=","+=","-=","/=","*=","%=",">>=","<<=",">>>=","|=","^=","&=","&&","||"]);var WHITESPACE_CHARS=array_to_hash(characters(" \u00a0\n\r\t\f\u000b\u200b\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000"));var PUNC_BEFORE_EXPRESSION=array_to_hash(characters("[{}(,.;:"));var PUNC_CHARS=array_to_hash(characters("[]{}(),;:"));var REGEXP_MODIFIERS=array_to_hash(characters("gmsiy"));var UNICODE={letter:new RegExp("[\\u0041-\\u005A\\u0061-\\u007A\\u00AA\\u00B5\\u00BA\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02C1\\u02C6-\\u02D1\\u02E0-\\u02E4\\u02EC\\u02EE\\u0370-\\u0374\\u0376\\u0377\\u037A-\\u037D\\u0386\\u0388-\\u038A\\u038C\\u038E-\\u03A1\\u03A3-\\u03F5\\u03F7-\\u0481\\u048A-\\u0523\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05D0-\\u05EA\\u05F0-\\u05F2\\u0621-\\u064A\\u066E\\u066F\\u0671-\\u06D3\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u06FC\\u06FF\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1\\u07CA-\\u07EA\\u07F4\\u07F5\\u07FA\\u0904-\\u0939\\u093D\\u0950\\u0958-\\u0961\\u0971\\u0972\\u097B-\\u097F\\u0985-\\u098C\\u098F\\u0990\\u0993-\\u09A8\\u09AA-\\u09B0\\u09B2\\u09B6-\\u09B9\\u09BD\\u09CE\\u09DC\\u09DD\\u09DF-\\u09E1\\u09F0\\u09F1\\u0A05-\\u0A0A\\u0A0F\\u0A10\\u0A13-\\u0A28\\u0A2A-\\u0A30\\u0A32\\u0A33\\u0A35\\u0A36\\u0A38\\u0A39\\u0A59-\\u0A5C\\u0A5E\\u0A72-\\u0A74\\u0A85-\\u0A8D\\u0A8F-\\u0A91\\u0A93-\\u0AA8\\u0AAA-\\u0AB0\\u0AB2\\u0AB3\\u0AB5-\\u0AB9\\u0ABD\\u0AD0\\u0AE0\\u0AE1\\u0B05-\\u0B0C\\u0B0F\\u0B10\\u0B13-\\u0B28\\u0B2A-\\u0B30\\u0B32\\u0B33\\u0B35-\\u0B39\\u0B3D\\u0B5C\\u0B5D\\u0B5F-\\u0B61\\u0B71\\u0B83\\u0B85-\\u0B8A\\u0B8E-\\u0B90\\u0B92-\\u0B95\\u0B99\\u0B9A\\u0B9C\\u0B9E\\u0B9F\\u0BA3\\u0BA4\\u0BA8-\\u0BAA\\u0BAE-\\u0BB9\\u0BD0\\u0C05-\\u0C0C\\u0C0E-\\u0C10\\u0C12-\\u0C28\\u0C2A-\\u0C33\\u0C35-\\u0C39\\u0C3D\\u0C58\\u0C59\\u0C60\\u0C61\\u0C85-\\u0C8C\\u0C8E-\\u0C90\\u0C92-\\u0CA8\\u0CAA-\\u0CB3\\u0CB5-\\u0CB9\\u0CBD\\u0CDE\\u0CE0\\u0CE1\\u0D05-\\u0D0C\\u0D0E-\\u0D10\\u0D12-\\u0D28\\u0D2A-\\u0D39\\u0D3D\\u0D60\\u0D61\\u0D7A-\\u0D7F\\u0D85-\\u0D96\\u0D9A-\\u0DB1\\u0DB3-\\u0DBB\\u0DBD\\u0DC0-\\u0DC6\\u0E01-\\u0E30\\u0E32\\u0E33\\u0E40-\\u0E46\\u0E81\\u0E82\\u0E84\\u0E87\\u0E88\\u0E8A\\u0E8D\\u0E94-\\u0E97\\u0E99-\\u0E9F\\u0EA1-\\u0EA3\\u0EA5\\u0EA7\\u0EAA\\u0EAB\\u0EAD-\\u0EB0\\u0EB2\\u0EB3\\u0EBD\\u0EC0-\\u0EC4\\u0EC6\\u0EDC\\u0EDD\\u0F00\\u0F40-\\u0F47\\u0F49-\\u0F6C\\u0F88-\\u0F8B\\u1000-\\u102A\\u103F\\u1050-\\u1055\\u105A-\\u105D\\u1061\\u1065\\u1066\\u106E-\\u1070\\u1075-\\u1081\\u108E\\u10A0-\\u10C5\\u10D0-\\u10FA\\u10FC\\u1100-\\u1159\\u115F-\\u11A2\\u11A8-\\u11F9\\u1200-\\u1248\\u124A-\\u124D\\u1250-\\u1256\\u1258\\u125A-\\u125D\\u1260-\\u1288\\u128A-\\u128D\\u1290-\\u12B0\\u12B2-\\u12B5\\u12B8-\\u12BE\\u12C0\\u12C2-\\u12C5\\u12C8-\\u12D6\\u12D8-\\u1310\\u1312-\\u1315\\u1318-\\u135A\\u1380-\\u138F\\u13A0-\\u13F4\\u1401-\\u166C\\u166F-\\u1676\\u1681-\\u169A\\u16A0-\\u16EA\\u1700-\\u170C\\u170E-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176C\\u176E-\\u1770\\u1780-\\u17B3\\u17D7\\u17DC\\u1820-\\u1877\\u1880-\\u18A8\\u18AA\\u1900-\\u191C\\u1950-\\u196D\\u1970-\\u1974\\u1980-\\u19A9\\u19C1-\\u19C7\\u1A00-\\u1A16\\u1B05-\\u1B33\\u1B45-\\u1B4B\\u1B83-\\u1BA0\\u1BAE\\u1BAF\\u1C00-\\u1C23\\u1C4D-\\u1C4F\\u1C5A-\\u1C7D\\u1D00-\\u1DBF\\u1E00-\\u1F15\\u1F18-\\u1F1D\\u1F20-\\u1F45\\u1F48-\\u1F4D\\u1F50-\\u1F57\\u1F59\\u1F5B\\u1F5D\\u1F5F-\\u1F7D\\u1F80-\\u1FB4\\u1FB6-\\u1FBC\\u1FBE\\u1FC2-\\u1FC4\\u1FC6-\\u1FCC\\u1FD0-\\u1FD3\\u1FD6-\\u1FDB\\u1FE0-\\u1FEC\\u1FF2-\\u1FF4\\u1FF6-\\u1FFC\\u2071\\u207F\\u2090-\\u2094\\u2102\\u2107\\u210A-\\u2113\\u2115\\u2119-\\u211D\\u2124\\u2126\\u2128\\u212A-\\u212D\\u212F-\\u2139\\u213C-\\u213F\\u2145-\\u2149\\u214E\\u2183\\u2184\\u2C00-\\u2C2E\\u2C30-\\u2C5E\\u2C60-\\u2C6F\\u2C71-\\u2C7D\\u2C80-\\u2CE4\\u2D00-\\u2D25\\u2D30-\\u2D65\\u2D6F\\u2D80-\\u2D96\\u2DA0-\\u2DA6\\u2DA8-\\u2DAE\\u2DB0-\\u2DB6\\u2DB8-\\u2DBE\\u2DC0-\\u2DC6\\u2DC8-\\u2DCE\\u2DD0-\\u2DD6\\u2DD8-\\u2DDE\\u2E2F\\u3005\\u3006\\u3031-\\u3035\\u303B\\u303C\\u3041-\\u3096\\u309D-\\u309F\\u30A1-\\u30FA\\u30FC-\\u30FF\\u3105-\\u312D\\u3131-\\u318E\\u31A0-\\u31B7\\u31F0-\\u31FF\\u3400\\u4DB5\\u4E00\\u9FC3\\uA000-\\uA48C\\uA500-\\uA60C\\uA610-\\uA61F\\uA62A\\uA62B\\uA640-\\uA65F\\uA662-\\uA66E\\uA67F-\\uA697\\uA717-\\uA71F\\uA722-\\uA788\\uA78B\\uA78C\\uA7FB-\\uA801\\uA803-\\uA805\\uA807-\\uA80A\\uA80C-\\uA822\\uA840-\\uA873\\uA882-\\uA8B3\\uA90A-\\uA925\\uA930-\\uA946\\uAA00-\\uAA28\\uAA40-\\uAA42\\uAA44-\\uAA4B\\uAC00\\uD7A3\\uF900-\\uFA2D\\uFA30-\\uFA6A\\uFA70-\\uFAD9\\uFB00-\\uFB06\\uFB13-\\uFB17\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFB36\\uFB38-\\uFB3C\\uFB3E\\uFB40\\uFB41\\uFB43\\uFB44\\uFB46-\\uFBB1\\uFBD3-\\uFD3D\\uFD50-\\uFD8F\\uFD92-\\uFDC7\\uFDF0-\\uFDFB\\uFE70-\\uFE74\\uFE76-\\uFEFC\\uFF21-\\uFF3A\\uFF41-\\uFF5A\\uFF66-\\uFFBE\\uFFC2-\\uFFC7\\uFFCA-\\uFFCF\\uFFD2-\\uFFD7\\uFFDA-\\uFFDC]"),non_spacing_mark:new RegExp("[\\u0300-\\u036F\\u0483-\\u0487\\u0591-\\u05BD\\u05BF\\u05C1\\u05C2\\u05C4\\u05C5\\u05C7\\u0610-\\u061A\\u064B-\\u065E\\u0670\\u06D6-\\u06DC\\u06DF-\\u06E4\\u06E7\\u06E8\\u06EA-\\u06ED\\u0711\\u0730-\\u074A\\u07A6-\\u07B0\\u07EB-\\u07F3\\u0816-\\u0819\\u081B-\\u0823\\u0825-\\u0827\\u0829-\\u082D\\u0900-\\u0902\\u093C\\u0941-\\u0948\\u094D\\u0951-\\u0955\\u0962\\u0963\\u0981\\u09BC\\u09C1-\\u09C4\\u09CD\\u09E2\\u09E3\\u0A01\\u0A02\\u0A3C\\u0A41\\u0A42\\u0A47\\u0A48\\u0A4B-\\u0A4D\\u0A51\\u0A70\\u0A71\\u0A75\\u0A81\\u0A82\\u0ABC\\u0AC1-\\u0AC5\\u0AC7\\u0AC8\\u0ACD\\u0AE2\\u0AE3\\u0B01\\u0B3C\\u0B3F\\u0B41-\\u0B44\\u0B4D\\u0B56\\u0B62\\u0B63\\u0B82\\u0BC0\\u0BCD\\u0C3E-\\u0C40\\u0C46-\\u0C48\\u0C4A-\\u0C4D\\u0C55\\u0C56\\u0C62\\u0C63\\u0CBC\\u0CBF\\u0CC6\\u0CCC\\u0CCD\\u0CE2\\u0CE3\\u0D41-\\u0D44\\u0D4D\\u0D62\\u0D63\\u0DCA\\u0DD2-\\u0DD4\\u0DD6\\u0E31\\u0E34-\\u0E3A\\u0E47-\\u0E4E\\u0EB1\\u0EB4-\\u0EB9\\u0EBB\\u0EBC\\u0EC8-\\u0ECD\\u0F18\\u0F19\\u0F35\\u0F37\\u0F39\\u0F71-\\u0F7E\\u0F80-\\u0F84\\u0F86\\u0F87\\u0F90-\\u0F97\\u0F99-\\u0FBC\\u0FC6\\u102D-\\u1030\\u1032-\\u1037\\u1039\\u103A\\u103D\\u103E\\u1058\\u1059\\u105E-\\u1060\\u1071-\\u1074\\u1082\\u1085\\u1086\\u108D\\u109D\\u135F\\u1712-\\u1714\\u1732-\\u1734\\u1752\\u1753\\u1772\\u1773\\u17B7-\\u17BD\\u17C6\\u17C9-\\u17D3\\u17DD\\u180B-\\u180D\\u18A9\\u1920-\\u1922\\u1927\\u1928\\u1932\\u1939-\\u193B\\u1A17\\u1A18\\u1A56\\u1A58-\\u1A5E\\u1A60\\u1A62\\u1A65-\\u1A6C\\u1A73-\\u1A7C\\u1A7F\\u1B00-\\u1B03\\u1B34\\u1B36-\\u1B3A\\u1B3C\\u1B42\\u1B6B-\\u1B73\\u1B80\\u1B81\\u1BA2-\\u1BA5\\u1BA8\\u1BA9\\u1C2C-\\u1C33\\u1C36\\u1C37\\u1CD0-\\u1CD2\\u1CD4-\\u1CE0\\u1CE2-\\u1CE8\\u1CED\\u1DC0-\\u1DE6\\u1DFD-\\u1DFF\\u20D0-\\u20DC\\u20E1\\u20E5-\\u20F0\\u2CEF-\\u2CF1\\u2DE0-\\u2DFF\\u302A-\\u302F\\u3099\\u309A\\uA66F\\uA67C\\uA67D\\uA6F0\\uA6F1\\uA802\\uA806\\uA80B\\uA825\\uA826\\uA8C4\\uA8E0-\\uA8F1\\uA926-\\uA92D\\uA947-\\uA951\\uA980-\\uA982\\uA9B3\\uA9B6-\\uA9B9\\uA9BC\\uAA29-\\uAA2E\\uAA31\\uAA32\\uAA35\\uAA36\\uAA43\\uAA4C\\uAAB0\\uAAB2-\\uAAB4\\uAAB7\\uAAB8\\uAABE\\uAABF\\uAAC1\\uABE5\\uABE8\\uABED\\uFB1E\\uFE00-\\uFE0F\\uFE20-\\uFE26]"),space_combining_mark:new RegExp("[\\u0903\\u093E-\\u0940\\u0949-\\u094C\\u094E\\u0982\\u0983\\u09BE-\\u09C0\\u09C7\\u09C8\\u09CB\\u09CC\\u09D7\\u0A03\\u0A3E-\\u0A40\\u0A83\\u0ABE-\\u0AC0\\u0AC9\\u0ACB\\u0ACC\\u0B02\\u0B03\\u0B3E\\u0B40\\u0B47\\u0B48\\u0B4B\\u0B4C\\u0B57\\u0BBE\\u0BBF\\u0BC1\\u0BC2\\u0BC6-\\u0BC8\\u0BCA-\\u0BCC\\u0BD7\\u0C01-\\u0C03\\u0C41-\\u0C44\\u0C82\\u0C83\\u0CBE\\u0CC0-\\u0CC4\\u0CC7\\u0CC8\\u0CCA\\u0CCB\\u0CD5\\u0CD6\\u0D02\\u0D03\\u0D3E-\\u0D40\\u0D46-\\u0D48\\u0D4A-\\u0D4C\\u0D57\\u0D82\\u0D83\\u0DCF-\\u0DD1\\u0DD8-\\u0DDF\\u0DF2\\u0DF3\\u0F3E\\u0F3F\\u0F7F\\u102B\\u102C\\u1031\\u1038\\u103B\\u103C\\u1056\\u1057\\u1062-\\u1064\\u1067-\\u106D\\u1083\\u1084\\u1087-\\u108C\\u108F\\u109A-\\u109C\\u17B6\\u17BE-\\u17C5\\u17C7\\u17C8\\u1923-\\u1926\\u1929-\\u192B\\u1930\\u1931\\u1933-\\u1938\\u19B0-\\u19C0\\u19C8\\u19C9\\u1A19-\\u1A1B\\u1A55\\u1A57\\u1A61\\u1A63\\u1A64\\u1A6D-\\u1A72\\u1B04\\u1B35\\u1B3B\\u1B3D-\\u1B41\\u1B43\\u1B44\\u1B82\\u1BA1\\u1BA6\\u1BA7\\u1BAA\\u1C24-\\u1C2B\\u1C34\\u1C35\\u1CE1\\u1CF2\\uA823\\uA824\\uA827\\uA880\\uA881\\uA8B4-\\uA8C3\\uA952\\uA953\\uA983\\uA9B4\\uA9B5\\uA9BA\\uA9BB\\uA9BD-\\uA9C0\\uAA2F\\uAA30\\uAA33\\uAA34\\uAA4D\\uAA7B\\uABE3\\uABE4\\uABE6\\uABE7\\uABE9\\uABEA\\uABEC]"),connector_punctuation:new RegExp("[\\u005F\\u203F\\u2040\\u2054\\uFE33\\uFE34\\uFE4D-\\uFE4F\\uFF3F]")};function is_letter(a){return UNICODE.letter.test(a)};function is_digit(a){a=a.charCodeAt(0);return a>=48&&a<=57};function is_alphanumeric_char(a){return is_digit(a)||is_letter(a)};function is_unicode_combining_mark(a){return UNICODE.non_spacing_mark.test(a)||UNICODE.space_combining_mark.test(a)};function is_unicode_connector_punctuation(a){return UNICODE.connector_punctuation.test(a)};function is_identifier_start(a){return a=="$"||a=="_"||is_letter(a)};function is_identifier_char(a){return is_identifier_start(a)||is_unicode_combining_mark(a)||is_digit(a)||is_unicode_connector_punctuation(a)||a=="\u200c"||a=="\u200d"};function parse_js_number(a){if(RE_HEX_NUMBER.test(a)){return parseInt(a.substr(2),16)}else if(RE_OCT_NUMBER.test(a)){return parseInt(a.substr(1),8)}else if(RE_DEC_NUMBER.test(a)){return parseFloat(a)}};function JS_Parse_Error(a,b,c,d){this.message=a;this.line=b+1;this.col=c+1;this.pos=d+1;this.stack=new Error().stack};JS_Parse_Error.prototype.toString=function(){return this.message+" (line: "+this.line+", col: "+this.col+", pos: "+this.pos+")"+"\n\n"+this.stack};function js_error(a,b,c,d){throw new JS_Parse_Error(a,b,c,d);};function is_token(a,b,c){return a.type==b&&(c==null||a.value==c)};var EX_EOF={};function tokenizer(f){var S={text:f.replace(/\r\n?|[\n\u2028\u2029]/g,"\n").replace(/^\uFEFF/,''),pos:0,tokpos:0,line:0,tokline:0,col:0,tokcol:0,newline_before:false,regex_allowed:false,comments_before:[]};function peek(){return S.text.charAt(S.pos)};function next(a,b){var c=S.text.charAt(S.pos++);if(a&&!c)throw EX_EOF;if(c=="\n"){S.newline_before=S.newline_before||!b;++S.line;S.col=0}else{++S.col}return c};function eof(){return!S.peek()};function find(a,b){var c=S.text.indexOf(a,S.pos);if(b&&c==-1)throw EX_EOF;return c};function start_token(){S.tokline=S.line;S.tokcol=S.col;S.tokpos=S.pos};function token(a,b,c){S.regex_allowed=((a=="operator"&&!HOP(UNARY_POSTFIX,b))||(a=="keyword"&&HOP(KEYWORDS_BEFORE_EXPRESSION,b))||(a=="punc"&&HOP(PUNC_BEFORE_EXPRESSION,b)));var d={type:a,value:b,line:S.tokline,col:S.tokcol,pos:S.tokpos,endpos:S.pos,nlb:S.newline_before};if(!c){d.comments_before=S.comments_before;S.comments_before=[]}S.newline_before=false;return d};function skip_whitespace(){while(HOP(WHITESPACE_CHARS,peek()))next()};function read_while(a){var b="",ch=peek(),i=0;while(ch&&a(ch,i++)){b+=next();ch=peek()}return b};function parse_error(a){js_error(a,S.tokline,S.tokcol,S.tokpos)};function read_num(b){var c=false,after_e=false,has_x=false,has_dot=b==".";var d=read_while(function(a,i){if(a=="x"||a=="X"){if(has_x)return false;return has_x=true}if(!has_x&&(a=="E"||a=="e")){if(c)return false;return c=after_e=true}if(a=="-"){if(after_e||(i==0&&!b))return true;return false}if(a=="+")return after_e;after_e=false;if(a=="."){if(!has_dot&&!has_x)return has_dot=true;return false}return is_alphanumeric_char(a)});if(b)d=b+d;var e=parse_js_number(d);if(!isNaN(e)){return token("num",e)}else{parse_error("Invalid syntax: "+d)}};function read_escaped_char(a){var b=next(true,a);switch(b){case"n":return"\n";case"r":return"\r";case"t":return"\t";case"b":return"\b";case"v":return"\u000b";case"f":return"\f";case"0":return"\0";case"x":return String.fromCharCode(hex_bytes(2));case"u":return String.fromCharCode(hex_bytes(4));case"\n":return"";default:return b}};function hex_bytes(n){var a=0;for(;n>0;--n){var b=parseInt(next(true),16);if(isNaN(b))parse_error("Invalid hex-character pattern in string");a=(a<<4)|b}return a};function read_string(){return with_eof_error("Unterminated string constant",function(){var b=next(),ret="";for(;;){var c=next(true);if(c=="\\"){var d=0,first=null;c=read_while(function(a){if(a>="0"&&a<="7"){if(!first){first=a;return++d}else if(first<="3"&&d<=2)return++d;else if(first>="4"&&d<=1)return++d}return false});if(d>0)c=String.fromCharCode(parseInt(c,8));else c=read_escaped_char(true)}else if(c==b)break;ret+=c}return token("string",ret)})};function read_line_comment(){next();var i=find("\n"),ret;if(i==-1){ret=S.text.substr(S.pos);S.pos=S.text.length}else{ret=S.text.substring(S.pos,i);S.pos=i}return token("comment1",ret,true)};function read_multiline_comment(){next();return with_eof_error("Unterminated multiline comment",function(){var i=find("*/",true),text=S.text.substring(S.pos,i);S.pos=i+2;S.line+=text.split("\n").length-1;S.newline_before=text.indexOf("\n")>=0;if(/^@cc_on/i.test(text)){warn("WARNING: at line "+S.line);warn("*** Found \"conditional comment\": "+text);warn("*** UglifyJS DISCARDS ALL COMMENTS.  This means your code might no longer work properly in Internet Explorer.")}return token("comment2",text,true)})};function read_name(){var a=false,name="",ch;while((ch=peek())!=null){if(!a){if(ch=="\\")a=true,next();else if(is_identifier_char(ch))name+=next();else break}else{if(ch!="u")parse_error("Expecting UnicodeEscapeSequence -- uXXXX");ch=read_escaped_char();if(!is_identifier_char(ch))parse_error("Unicode char: "+ch.charCodeAt(0)+" is not valid in identifier");name+=ch;a=false}}return name};function read_regexp(c){return with_eof_error("Unterminated regular expression",function(){var a=false,ch,in_class=false;while((ch=next(true)))if(a){c+="\\"+ch;a=false}else if(ch=="["){in_class=true;c+=ch}else if(ch=="]"&&in_class){in_class=false;c+=ch}else if(ch=="/"&&!in_class){break}else if(ch=="\\"){a=true}else{c+=ch}var b=read_name();return token("regexp",[c,b])})};function read_operator(c){function grow(a){if(!peek())return a;var b=a+peek();if(HOP(OPERATORS,b)){next();return grow(b)}else{return a}};return token("operator",grow(c||next()))};function handle_slash(){next();var a=S.regex_allowed;switch(peek()){case"/":S.comments_before.push(read_line_comment());S.regex_allowed=a;return next_token();case"*":S.comments_before.push(read_multiline_comment());S.regex_allowed=a;return next_token()}return S.regex_allowed?read_regexp(""):read_operator("/")};function handle_dot(){next();return is_digit(peek())?read_num("."):token("punc",".")};function read_word(){var a=read_name();return!HOP(KEYWORDS,a)?token("name",a):HOP(OPERATORS,a)?token("operator",a):HOP(KEYWORDS_ATOM,a)?token("atom",a):token("keyword",a)};function with_eof_error(a,b){try{return b()}catch(ex){if(ex===EX_EOF)parse_error(a);else throw ex;}};function next_token(a){if(a!=null)return read_regexp(a);skip_whitespace();start_token();var b=peek();if(!b)return token("eof");if(is_digit(b))return read_num();if(b=='"'||b=="'")return read_string();if(HOP(PUNC_CHARS,b))return token("punc",next());if(b==".")return handle_dot();if(b=="/")return handle_slash();if(HOP(OPERATOR_CHARS,b))return read_operator();if(b=="\\"||is_identifier_start(b))return read_word();parse_error("Unexpected character '"+b+"'")};next_token.context=function(a){if(a)S=a;return S};return next_token};var UNARY_PREFIX=array_to_hash(["typeof","void","delete","--","++","!","~","-","+"]);var UNARY_POSTFIX=array_to_hash(["--","++"]);var ASSIGNMENT=(function(a,b,i){while(i<a.length){b[a[i]]=a[i].substr(0,a[i].length-1);i++}return b})(["+=","-=","/=","*=","%=",">>=","<<=",">>>=","|=","^=","&="],{"=":true},0);var PRECEDENCE=(function(a,c){for(var i=0,n=1;i<a.length;++i,++n){var b=a[i];for(var j=0;j<b.length;++j){c[b[j]]=n}}return c})([["||"],["&&"],["|"],["^"],["&"],["==","===","!=","!=="],["<",">","<=",">=","in","instanceof"],[">>","<<",">>>"],["+","-"],["*","/","%"]],{});var STATEMENTS_WITH_LABELS=array_to_hash(["for","do","while","switch"]);var ATOMIC_START_TOKEN=array_to_hash(["atom","num","string","regexp","name"]);function NodeWithToken(a,b,c){this.name=a;this.start=b;this.end=c};NodeWithToken.prototype.toString=function(){return this.name};function parse(g,h,i){var S={input:typeof g=="string"?tokenizer(g,true):g,token:null,prev:null,peeked:null,in_function:0,in_loop:0,labels:[]};S.token=next();function is(a,b){return is_token(S.token,a,b)};function peek(){return S.peeked||(S.peeked=S.input())};function next(){S.prev=S.token;if(S.peeked){S.token=S.peeked;S.peeked=null}else{S.token=S.input()}return S.token};function prev(){return S.prev};function croak(a,b,c,d){var e=S.input.context();js_error(a,b!=null?b:e.tokline,c!=null?c:e.tokcol,d!=null?d:e.tokpos)};function token_error(a,b){croak(b,a.line,a.col)};function unexpected(a){if(a==null)a=S.token;token_error(a,"Unexpected token: "+a.type+" ("+a.value+")")};function expect_token(a,b){if(is(a,b)){return next()}token_error(S.token,"Unexpected token "+S.token.type+", expected "+a)};function expect(a){return expect_token("punc",a)};function can_insert_semicolon(){return!h&&(S.token.nlb||is("eof")||is("punc","}"))};function semicolon(){if(is("punc",";"))next();else if(!can_insert_semicolon())unexpected()};function as(){return slice(arguments)};function parenthesised(){expect("(");var a=n();expect(")");return a};function add_tokens(a,b,c){return a instanceof NodeWithToken?a:new NodeWithToken(a,b,c)};function maybe_embed_tokens(c){if(i)return function(){var a=S.token;var b=c.apply(this,arguments);b[0]=add_tokens(b[0],a,prev());return b};else return c};var j=maybe_embed_tokens(function(){if(is("operator","/")||is("operator","/=")){S.peeked=null;S.token=S.input(S.token.value.substr(1))}switch(S.token.type){case"num":case"string":case"regexp":case"operator":case"atom":return simple_statement();case"name":return is_token(peek(),"punc",":")?labeled_statement(prog1(S.token.value,next,next)):simple_statement();case"punc":switch(S.token.value){case"{":return as("block",block_());case"[":case"(":return simple_statement();case";":next();return as("block");default:unexpected()}case"keyword":switch(prog1(S.token.value,next)){case"break":return break_cont("break");case"continue":return break_cont("continue");case"debugger":semicolon();return as("debugger");case"do":return(function(a){expect_token("keyword","while");return as("do",prog1(parenthesised,semicolon),a)})(in_loop(j));case"for":return for_();case"function":return k(true);case"if":return if_();case"return":if(S.in_function==0)croak("'return' outside of function");return as("return",is("punc",";")?(next(),null):can_insert_semicolon()?null:prog1(n,semicolon));case"switch":return as("switch",parenthesised(),l());case"throw":if(S.token.nlb)croak("Illegal newline after 'throw'");return as("throw",prog1(n,semicolon));case"try":return try_();case"var":return prog1(var_,semicolon);case"const":return prog1(const_,semicolon);case"while":return as("while",parenthesised(),in_loop(j));case"with":return as("with",parenthesised(),j());default:unexpected()}}});function labeled_statement(a){S.labels.push(a);var b=S.token,stat=j();if(h&&!HOP(STATEMENTS_WITH_LABELS,stat[0]))unexpected(b);S.labels.pop();return as("label",a,stat)};function simple_statement(){return as("stat",prog1(n,semicolon))};function break_cont(a){var b;if(!can_insert_semicolon()){b=is("name")?S.token.value:null}if(b!=null){next();if(!member(b,S.labels))croak("Label "+b+" without matching loop or statement")}else if(S.in_loop==0)croak(a+" not inside a loop or switch");semicolon();return as(a,b)};function for_(){expect("(");var a=null;if(!is("punc",";")){a=is("keyword","var")?(next(),var_(true)):n(true,true);if(is("operator","in")){if(a[0]=="var"&&a[1].length>1)croak("Only one variable declaration allowed in for..in loop");return for_in(a)}}return regular_for(a)};function regular_for(a){expect(";");var b=is("punc",";")?null:n();expect(";");var c=is("punc",")")?null:n();expect(")");return as("for",a,b,c,in_loop(j))};function for_in(a){var b=a[0]=="var"?as("name",a[1][0]):a;next();var c=n();expect(")");return as("for-in",a,b,c,in_loop(j))};var k=function(c){var d=is("name")?prog1(S.token.value,next):null;if(c&&!d)unexpected();expect("(");return as(c?"defun":"function",d,(function(b,a){while(!is("punc",")")){if(b)b=false;else expect(",");if(!is("name"))unexpected();a.push(S.token.value);next()}next();return a})(true,[]),(function(){++S.in_function;var b=S.in_loop;S.in_loop=0;var a=block_();--S.in_function;S.in_loop=b;return a})())};function if_(){var a=parenthesised(),body=j(),belse;if(is("keyword","else")){next();belse=j()}return as("if",a,body,belse)};function block_(){expect("{");var a=[];while(!is("punc","}")){if(is("eof"))unexpected();a.push(j())}next();return a};var l=curry(in_loop,function(){expect("{");var a=[],cur=null;while(!is("punc","}")){if(is("eof"))unexpected();if(is("keyword","case")){next();cur=[];a.push([n(),cur]);expect(":")}else if(is("keyword","default")){next();expect(":");cur=[];a.push([null,cur])}else{if(!cur)unexpected();cur.push(j())}}next();return a});function try_(){var a=block_(),bcatch,bfinally;if(is("keyword","catch")){next();expect("(");if(!is("name"))croak("Name expected");var b=S.token.value;next();expect(")");bcatch=[b,block_()]}if(is("keyword","finally")){next();bfinally=block_()}if(!bcatch&&!bfinally)croak("Missing catch/finally blocks");return as("try",a,bcatch,bfinally)};function vardefs(b){var a=[];for(;;){if(!is("name"))unexpected();var c=S.token.value;next();if(is("operator","=")){next();a.push([c,n(false,b)])}else{a.push([c])}if(!is("punc",","))break;next()}return a};function var_(a){return as("var",vardefs(a))};function const_(){return as("const",vardefs())};function new_(){var a=m(false),args;if(is("punc","(")){next();args=expr_list(")")}else{args=[]}return subscripts(as("new",a,args),true)};var m=maybe_embed_tokens(function(a){if(is("operator","new")){next();return new_()}if(is("punc")){switch(S.token.value){case"(":next();return subscripts(prog1(n,curry(expect,")")),a);case"[":next();return subscripts(array_(),a);case"{":next();return subscripts(object_(),a)}unexpected()}if(is("keyword","function")){next();return subscripts(k(false),a)}if(HOP(ATOMIC_START_TOKEN,S.token.type)){var b=S.token.type=="regexp"?as("regexp",S.token.value[0],S.token.value[1]):as(S.token.type,S.token.value);return subscripts(prog1(b,next),a)}unexpected()});function expr_list(b,c,d){var e=true,a=[];while(!is("punc",b)){if(e)e=false;else expect(",");if(c&&is("punc",b))break;if(is("punc",",")&&d){a.push(["atom","undefined"])}else{a.push(n(false))}}next();return a};function array_(){return as("array",expr_list("]",!h,true))};function object_(){var b=true,a=[];while(!is("punc","}")){if(b)b=false;else expect(",");if(!h&&is("punc","}"))break;var c=S.token.type;var d=as_property_name();if(c=="name"&&(d=="get"||d=="set")&&!is("punc",":")){a.push([as_name(),k(false),d])}else{expect(":");a.push([d,n(false)])}}next();return as("object",a)};function as_property_name(){switch(S.token.type){case"num":case"string":return prog1(S.token.value,next)}return as_name()};function as_name(){switch(S.token.type){case"name":case"operator":case"keyword":case"atom":return prog1(S.token.value,next);default:unexpected()}};function subscripts(a,b){if(is("punc",".")){next();return subscripts(as("dot",a,as_name()),b)}if(is("punc","[")){next();return subscripts(as("sub",a,prog1(n,curry(expect,"]"))),b)}if(b&&is("punc","(")){next();return subscripts(as("call",a,expr_list(")")),true)}return a};function maybe_unary(a){if(is("operator")&&HOP(UNARY_PREFIX,S.token.value)){return make_unary("unary-prefix",prog1(S.token.value,next),maybe_unary(a))}var b=m(a);while(is("operator")&&HOP(UNARY_POSTFIX,S.token.value)&&!S.token.nlb){b=make_unary("unary-postfix",S.token.value,b);next()}return b};function make_unary(a,b,c){if((b=="++"||b=="--")&&!is_assignable(c))croak("Invalid use of "+b+" operator");return as(a,b,c)};function expr_op(a,b,c){var d=is("operator")?S.token.value:null;if(d&&d=="in"&&c)d=null;var e=d!=null?PRECEDENCE[d]:null;if(e!=null&&e>b){next();var f=expr_op(maybe_unary(true),e,c);return expr_op(as("binary",d,a,f),b,c)}return a};function expr_ops(a){return expr_op(maybe_unary(true),0,a)};function maybe_conditional(a){var b=expr_ops(a);if(is("operator","?")){next();var c=n(false);expect(":");return as("conditional",b,c,n(false,a))}return b};function is_assignable(a){if(!h)return true;switch(a[0]+""){case"dot":case"sub":case"new":case"call":return true;case"name":return a[1]!="this"}};function maybe_assign(a){var b=maybe_conditional(a),val=S.token.value;if(is("operator")&&HOP(ASSIGNMENT,val)){if(is_assignable(b)){next();return as("assign",ASSIGNMENT[val],b,maybe_assign(a))}croak("Invalid assignment")}return b};var n=maybe_embed_tokens(function(a,b){if(arguments.length==0)a=true;var c=maybe_assign(b);if(a&&is("punc",",")){next();return as("seq",c,n(true,b))}return c});function in_loop(a){try{++S.in_loop;return a()}finally{--S.in_loop}};return as("toplevel",(function(a){while(!is("eof"))a.push(j());return a})([]))};function curry(f){var a=slice(arguments,1);return function(){return f.apply(this,a.concat(slice(arguments)))}};function prog1(a){if(a instanceof Function)a=a();for(var i=1,n=arguments.length;--n>0;++i)arguments[i]();return a};function array_to_hash(a){var b={};for(var i=0;i<a.length;++i)b[a[i]]=true;return b};function slice(a,b){return Array.prototype.slice.call(a,b||0)};function characters(a){return a.split("")};function member(a,b){for(var i=b.length;--i>=0;)if(b[i]==a)return true;return false};function HOP(a,b){return Object.prototype.hasOwnProperty.call(a,b)};var warn=function(){};exports.tokenizer=tokenizer;exports.parse=parse;exports.slice=slice;exports.curry=curry;exports.member=member;exports.array_to_hash=array_to_hash;exports.PRECEDENCE=PRECEDENCE;exports.KEYWORDS_ATOM=KEYWORDS_ATOM;exports.RESERVED_WORDS=RESERVED_WORDS;exports.KEYWORDS=KEYWORDS;exports.ATOMIC_START_TOKEN=ATOMIC_START_TOKEN;exports.OPERATORS=OPERATORS;exports.is_alphanumeric_char=is_alphanumeric_char;exports.set_logger=function(a){warn=a};var jsp=require("./parse-js"),slice=jsp.slice,member=jsp.member,PRECEDENCE=jsp.PRECEDENCE,OPERATORS=jsp.OPERATORS;function ast_walker(){function _vardefs(c){return[this[0],MAP(c,function(b){var a=[b[0]];if(b.length>1)a[1]=walk(b[1]);return a})]};function _block(a){var b=[this[0]];if(a!=null)b.push(MAP(a,walk));return b};var g={"string":function(a){return[this[0],a]},"num":function(a){return[this[0],a]},"name":function(a){return[this[0],a]},"toplevel":function(a){return[this[0],MAP(a,walk)]},"block":_block,"splice":_block,"var":_vardefs,"const":_vardefs,"try":function(t,c,f){return[this[0],MAP(t,walk),c!=null?[c[0],MAP(c[1],walk)]:null,f!=null?MAP(f,walk):null]},"throw":function(a){return[this[0],walk(a)]},"new":function(a,b){return[this[0],walk(a),MAP(b,walk)]},"switch":function(b,c){return[this[0],walk(b),MAP(c,function(a){return[a[0]?walk(a[0]):null,MAP(a[1],walk)]})]},"break":function(a){return[this[0],a]},"continue":function(a){return[this[0],a]},"conditional":function(a,t,e){return[this[0],walk(a),walk(t),walk(e)]},"assign":function(a,b,c){return[this[0],a,walk(b),walk(c)]},"dot":function(a){return[this[0],walk(a)].concat(slice(arguments,1))},"call":function(a,b){return[this[0],walk(a),MAP(b,walk)]},"function":function(a,b,c){return[this[0],a,b.slice(),MAP(c,walk)]},"debugger":function(){return[this[0]]},"defun":function(a,b,c){return[this[0],a,b.slice(),MAP(c,walk)]},"if":function(a,t,e){return[this[0],walk(a),walk(t),walk(e)]},"for":function(a,b,c,d){return[this[0],walk(a),walk(b),walk(c),walk(d)]},"for-in":function(a,b,c,d){return[this[0],walk(a),walk(b),walk(c),walk(d)]},"while":function(a,b){return[this[0],walk(a),walk(b)]},"do":function(a,b){return[this[0],walk(a),walk(b)]},"return":function(a){return[this[0],walk(a)]},"binary":function(a,b,c){return[this[0],a,walk(b),walk(c)]},"unary-prefix":function(a,b){return[this[0],a,walk(b)]},"unary-postfix":function(a,b){return[this[0],a,walk(b)]},"sub":function(a,b){return[this[0],walk(a),walk(b)]},"object":function(a){return[this[0],MAP(a,function(p){return p.length==2?[p[0],walk(p[1])]:[p[0],walk(p[1]),p[2]]})]},"regexp":function(a,b){return[this[0],a,b]},"array":function(a){return[this[0],MAP(a,walk)]},"stat":function(a){return[this[0],walk(a)]},"seq":function(){return[this[0]].concat(MAP(slice(arguments),walk))},"label":function(a,b){return[this[0],a,walk(b)]},"with":function(a,b){return[this[0],walk(a),walk(b)]},"atom":function(a){return[this[0],a]}};var h={};var j=[];function walk(a){if(a==null)return null;try{j.push(a);var b=a[0];var c=h[b];if(c){var d=c.apply(a,a.slice(1));if(d!=null)return d}c=g[b];return c.apply(a,a.slice(1))}finally{j.pop()}};function dive(a){if(a==null)return null;try{j.push(a);return g[a[0]].apply(a,a.slice(1))}finally{j.pop()}};function with_walkers(a,b){var c={},i;for(i in a)if(HOP(a,i)){c[i]=h[i];h[i]=a[i]}var d=b();for(i in c)if(HOP(c,i)){if(!c[i])delete h[i];else h[i]=c[i]}return d};return{walk:walk,dive:dive,with_walkers:with_walkers,parent:function(){return j[j.length-2]},stack:function(){return j}}};function Scope(a){this.names={};this.mangled={};this.rev_mangled={};this.cname=-1;this.refs={};this.uses_with=false;this.uses_eval=false;this.parent=a;this.children=[];if(a){this.level=a.level+1;a.children.push(this)}else{this.level=0}};var base54=(function(){var c="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_";return function(a){var b="";do{b=c.charAt(a%54)+b;a=Math.floor(a/54)}while(a>0);return b}})();Scope.prototype={has:function(a){for(var s=this;s;s=s.parent)if(HOP(s.names,a))return s},has_mangled:function(a){for(var s=this;s;s=s.parent)if(HOP(s.rev_mangled,a))return s},toJSON:function(){return{names:this.names,uses_eval:this.uses_eval,uses_with:this.uses_with}},next_mangled:function(){for(;;){var m=base54(++this.cname),prior;prior=this.has_mangled(m);if(prior&&this.refs[prior.rev_mangled[m]]===prior)continue;prior=this.has(m);if(prior&&prior!==this&&this.refs[m]===prior&&!prior.has_mangled(m))continue;if(HOP(this.refs,m)&&this.refs[m]==null)continue;if(!is_identifier(m))continue;return m}},set_mangle:function(a,m){this.rev_mangled[m]=a;return this.mangled[a]=m},get_mangled:function(a,b){if(this.uses_eval||this.uses_with)return a;var s=this.has(a);if(!s)return a;if(HOP(s.mangled,a))return s.mangled[a];if(!b)return a;return s.set_mangle(a,s.next_mangled())},references:function(a){return a&&!this.parent||this.uses_with||this.uses_eval||this.refs[a]},define:function(a,b){if(a!=null){if(b=="var"||!HOP(this.names,a))this.names[a]=b||"var";return a}}};function ast_add_scope(g){var h=null;var w=ast_walker(),walk=w.walk;var j=[];function with_new_scope(a){h=new Scope(h);h.labels=new Scope();var b=h.body=a();b.scope=h;h=h.parent;return b};function define(a,b){return h.define(a,b)};function reference(a){h.refs[a]=true};function _lambda(b,c,d){var e=this[0]=="defun";return[this[0],e?define(b,"defun"):b,c,with_new_scope(function(){if(!e)define(b,"lambda");MAP(c,function(a){define(a,"arg")});return MAP(d,walk)})]};function _vardefs(b){return function(a){MAP(a,function(d){define(d[0],b);if(d[1])reference(d[0])})}};function _breacont(a){if(a)h.labels.refs[a]=true};return with_new_scope(function(){var d=w.with_walkers({"function":_lambda,"defun":_lambda,"label":function(a,b){h.labels.define(a)},"break":_breacont,"continue":_breacont,"with":function(a,b){for(var s=h;s;s=s.parent)s.uses_with=true},"var":_vardefs("var"),"const":_vardefs("const"),"try":function(t,c,f){if(c!=null)return[this[0],MAP(t,walk),[define(c[0],"catch"),MAP(c[1],walk)],f!=null?MAP(f,walk):null]},"name":function(a){if(a=="eval")j.push(h);reference(a)}},function(){return walk(g)});MAP(j,function(a){if(!a.has("eval"))while(a){a.uses_eval=true;a=a.parent}});function fixrefs(a,i){for(i=a.children.length;--i>=0;)fixrefs(a.children[i]);for(i in a.refs)if(HOP(a.refs,i)){for(var b=a.has(i),s=a;s;s=s.parent){s.refs[i]=b;if(s===b)break}}};fixrefs(h);return d})};function ast_mangle(g,h){var w=ast_walker(),walk=w.walk,scope;h=h||{};function get_mangled(a,b){if(!h.toplevel&&!scope.parent)return a;if(h.except&&member(a,h.except))return a;return scope.get_mangled(a,b)};function get_define(a){if(h.defines){if(!scope.has(a)){if(HOP(h.defines,a)){return h.defines[a]}}return null}};function _lambda(b,c,d){if(!h.no_functions){var e=this[0]=="defun",extra;if(b){if(e)b=get_mangled(b);else if(d.scope.references(b)){extra={};if(!(scope.uses_eval||scope.uses_with))b=extra[b]=scope.next_mangled();else extra[b]=b}else b=null}}d=with_scope(d.scope,function(){c=MAP(c,function(a){return get_mangled(a)});return MAP(d,walk)},extra);return[this[0],b,c,d]};function with_scope(s,a,b){var c=scope;scope=s;if(b)for(var i in b)if(HOP(b,i)){s.set_mangle(i,b[i])}for(var i in s.names)if(HOP(s.names,i)){get_mangled(i,true)}var d=a();d.scope=s;scope=c;return d};function _vardefs(a){return[this[0],MAP(a,function(d){return[get_mangled(d[0]),walk(d[1])]})]};function _breacont(a){if(a)return[this[0],scope.labels.get_mangled(a)]};return w.with_walkers({"function":_lambda,"defun":function(){var a=_lambda.apply(this,arguments);switch(w.parent()[0]){case"toplevel":case"function":case"defun":return MAP.at_top(a)}return a},"label":function(a,b){if(scope.labels.refs[a])return[this[0],scope.labels.get_mangled(a,true),walk(b)];return walk(b)},"break":_breacont,"continue":_breacont,"var":_vardefs,"const":_vardefs,"name":function(a){return get_define(a)||[this[0],get_mangled(a)]},"try":function(t,c,f){return[this[0],MAP(t,walk),c!=null?[get_mangled(c[0]),MAP(c[1],walk)]:null,f!=null?MAP(f,walk):null]},"toplevel":function(a){var b=this;return with_scope(b.scope,function(){return[b[0],MAP(a,walk)]})}},function(){return walk(ast_add_scope(g))})};var warn=function(){};function best_of(a,b){return gen_code(a).length>gen_code(b[0]=="stat"?b[1]:b).length?b:a};function last_stat(b){if(b[0]=="block"&&b[1]&&b[1].length>0)return b[1][b[1].length-1];return b}function aborts(t){if(t)switch(last_stat(t)[0]){case"return":case"break":case"continue":case"throw":return true}};function boolean_expr(a){return((a[0]=="unary-prefix"&&member(a[1],["!","delete"]))||(a[0]=="binary"&&member(a[1],["in","instanceof","==","!=","===","!==","<","<=",">=",">"]))||(a[0]=="binary"&&member(a[1],["&&","||"])&&boolean_expr(a[2])&&boolean_expr(a[3]))||(a[0]=="conditional"&&boolean_expr(a[2])&&boolean_expr(a[3]))||(a[0]=="assign"&&a[1]===true&&boolean_expr(a[3]))||(a[0]=="seq"&&boolean_expr(a[a.length-1])))};function empty(b){return!b||(b[0]=="block"&&(!b[1]||b[1].length==0))};function is_string(a){return(a[0]=="string"||a[0]=="unary-prefix"&&a[1]=="typeof"||a[0]=="binary"&&a[1]=="+"&&(is_string(a[2])||is_string(a[3])))};var when_constant=(function(){var f={};function evaluate(a){switch(a[0]){case"string":case"num":return a[1];case"name":case"atom":switch(a[1]){case"true":return true;case"false":return false;case"null":return null}break;case"unary-prefix":switch(a[1]){case"!":return!evaluate(a[2]);case"typeof":return typeof evaluate(a[2]);case"~":return~evaluate(a[2]);case"-":return-evaluate(a[2]);case"+":return+evaluate(a[2])}break;case"binary":var b=a[2],right=a[3];switch(a[1]){case"&&":return evaluate(b)&&evaluate(right);case"||":return evaluate(b)||evaluate(right);case"|":return evaluate(b)|evaluate(right);case"&":return evaluate(b)&evaluate(right);case"^":return evaluate(b)^evaluate(right);case"+":return evaluate(b)+evaluate(right);case"*":return evaluate(b)*evaluate(right);case"/":return evaluate(b)/evaluate(right);case"%":return evaluate(b)%evaluate(right);case"-":return evaluate(b)-evaluate(right);case"<<":return evaluate(b)<<evaluate(right);case">>":return evaluate(b)>>evaluate(right);case">>>":return evaluate(b)>>>evaluate(right);case"==":return evaluate(b)==evaluate(right);case"===":return evaluate(b)===evaluate(right);case"!=":return evaluate(b)!=evaluate(right);case"!==":return evaluate(b)!==evaluate(right);case"<":return evaluate(b)<evaluate(right);case"<=":return evaluate(b)<=evaluate(right);case">":return evaluate(b)>evaluate(right);case">=":return evaluate(b)>=evaluate(right);case"in":return evaluate(b)in evaluate(right);case"instanceof":return evaluate(b)instanceof evaluate(right)}}throw f;};return function(a,b,c){try{var d=evaluate(a),ast;switch(typeof d){case"string":ast=["string",d];break;case"number":ast=["num",d];break;case"boolean":ast=["name",String(d)];break;default:throw new Error("Can't handle constant of type: "+(typeof d));}return b.call(a,ast,d)}catch(ex){if(ex===f){if(a[0]=="binary"&&(a[1]=="==="||a[1]=="!==")&&((is_string(a[2])&&is_string(a[3]))||(boolean_expr(a[2])&&boolean_expr(a[3])))){a[1]=a[1].substr(0,2)}else if(c&&a[0]=="binary"&&(a[1]=="||"||a[1]=="&&")){try{var e=evaluate(a[2]);a=((a[1]=="&&"&&(e?a[3]:e))||(a[1]=="||"&&(e?e:a[3]))||a)}catch(ex2){}}return c?c.call(a,a):null}else throw ex;}}})();function warn_unreachable(a){if(!empty(a))warn("Dropping unreachable code: "+gen_code(a,true))};function prepare_ifs(g){var w=ast_walker(),walk=w.walk;function redo_if(a){a=MAP(a,walk);for(var i=0;i<a.length;++i){var b=a[i];if(b[0]!="if")continue;if(b[3]&&walk(b[3]))continue;var t=walk(b[2]);if(!aborts(t))continue;var c=walk(b[1]);var d=redo_if(a.slice(i+1));var e=d.length==1?d[0]:["block",d];return a.slice(0,i).concat([[b[0],c,t,e]])}return a};function redo_if_lambda(a,b,c){c=redo_if(c);return[this[0],a,b,c]};function redo_if_block(a){return[this[0],a!=null?redo_if(a):null]};return w.with_walkers({"defun":redo_if_lambda,"function":redo_if_lambda,"block":redo_if_block,"splice":redo_if_block,"toplevel":function(a){return[this[0],redo_if(a)]},"try":function(t,c,f){return[this[0],redo_if(t),c!=null?[c[0],redo_if(c[1])]:null,f!=null?redo_if(f):null]}},function(){return walk(g)})};function for_side_effects(b,c){var w=ast_walker(),walk=w.walk;var d={},$restart={};function stop(){throw d};function restart(){throw $restart};function found(){return c.call(this,this,w,stop,restart)};function unary(a){if(a=="++"||a=="--")return found.apply(this,arguments)};return w.with_walkers({"try":found,"throw":found,"return":found,"new":found,"switch":found,"break":found,"continue":found,"assign":found,"call":found,"if":found,"for":found,"for-in":found,"while":found,"do":found,"return":found,"unary-prefix":unary,"unary-postfix":unary,"defun":found},function(){while(true)try{walk(b);break}catch(ex){if(ex===d)break;if(ex===$restart)continue;throw ex;}})};function ast_lift_variables(k){var w=ast_walker(),walk=w.walk,scope;function do_body(f,g){var h=scope;scope=g;f=MAP(f,walk);var j={},names=MAP(g.names,function(a,b){if(a!="var")return MAP.skip;if(!g.references(b))return MAP.skip;j[b]=true;return[b]});if(names.length>0){for_side_effects(["block",f],function(b,c,d,e){if(b[0]=="assign"&&b[1]===true&&b[2][0]=="name"&&HOP(j,b[2][1])){for(var i=names.length;--i>=0;){if(names[i][0]==b[2][1]){if(names[i][1])d();names[i][1]=b[3];names.push(names.splice(i,1)[0]);break}}var p=c.parent();if(p[0]=="seq"){var a=p[2];a.unshift(0,p.length);p.splice.apply(p,a)}else if(p[0]=="stat"){p.splice(0,p.length,"block")}else{d()}e()}d()});f.unshift(["var",names])}scope=h;return f};function _vardefs(a){var b=null;for(var i=a.length;--i>=0;){var d=a[i];if(!d[1])continue;d=["assign",true,["name",d[0]],d[1]];if(b==null)b=d;else b=["seq",d,b]}if(b==null){if(w.parent()[0]=="for-in")return["name",a[0][0]];return MAP.skip}return["stat",b]};function _toplevel(a){return[this[0],do_body(a,this.scope)]};return w.with_walkers({"function":function(a,b,c){for(var i=b.length;--i>=0&&!c.scope.references(b[i]);)b.pop();if(!c.scope.references(a))a=null;return[this[0],a,b,do_body(c,c.scope)]},"defun":function(a,b,c){if(!scope.references(a))return MAP.skip;for(var i=b.length;--i>=0&&!c.scope.references(b[i]);)b.pop();return[this[0],a,b,do_body(c,c.scope)]},"var":_vardefs,"toplevel":_toplevel},function(){return walk(ast_add_scope(k))})};function ast_squeeze(g,h){h=defaults(h,{make_seqs:true,dead_code:true,no_warnings:false,keep_comps:true});var w=ast_walker(),walk=w.walk;function negate(c){var a=["unary-prefix","!",c];switch(c[0]){case"unary-prefix":return c[1]=="!"&&boolean_expr(c[2])?c[2]:a;case"seq":c=slice(c);c[c.length-1]=negate(c[c.length-1]);return c;case"conditional":return best_of(a,["conditional",c[1],negate(c[2]),negate(c[3])]);case"binary":var b=c[1],left=c[2],right=c[3];if(!h.keep_comps)switch(b){case"<=":return["binary",">",left,right];case"<":return["binary",">=",left,right];case">=":return["binary","<",left,right];case">":return["binary","<=",left,right]}switch(b){case"==":return["binary","!=",left,right];case"!=":return["binary","==",left,right];case"===":return["binary","!==",left,right];case"!==":return["binary","===",left,right];case"&&":return best_of(a,["binary","||",negate(left),negate(right)]);case"||":return best_of(a,["binary","&&",negate(left),negate(right)])}break}return a};function make_conditional(c,t,e){var d=function(){if(c[0]=="unary-prefix"&&c[1]=="!"){return e?["conditional",c[2],e,t]:["binary","||",c[2],t]}else{return e?best_of(["conditional",c,t,e],["conditional",negate(c),e,t]):["binary","&&",c,t]}};return when_constant(c,function(a,b){warn_unreachable(b?e:t);return(b?t:e)},d)};function rmblock(a){if(a!=null&&a[0]=="block"&&a[1]){if(a[1].length==1)a=a[1][0];else if(a[1].length==0)a=["block"]}return a};function _lambda(a,b,c){return[this[0],a,b,tighten(c,"lambda")]};function tighten(d,e){d=MAP(d,walk);d=d.reduce(function(a,b){if(b[0]=="block"){if(b[1]){a.push.apply(a,b[1])}}else{a.push(b)}return a},[]);d=(function(a,c){d.forEach(function(b){if(c&&((b[0]=="var"&&c[0]=="var")||(b[0]=="const"&&c[0]=="const"))){c[1]=c[1].concat(b[1])}else{a.push(b);c=b}});return a})([]);if(h.dead_code)d=(function(a,c){d.forEach(function(b){if(c){if(b[0]=="function"||b[0]=="defun"){a.push(b)}else if(b[0]=="var"||b[0]=="const"){if(!h.no_warnings)warn("Variables declared in unreachable code");b[1]=MAP(b[1],function(a){if(a[1]&&!h.no_warnings)warn_unreachable(["assign",true,["name",a[0]],a[1]]);return[a[0]]});a.push(b)}else if(!h.no_warnings)warn_unreachable(b)}else{a.push(b);if(member(b[0],["return","throw","break","continue"]))c=true}});return a})([]);if(h.make_seqs)d=(function(a,c){d.forEach(function(b){if(c&&c[0]=="stat"&&b[0]=="stat"){c[1]=["seq",c[1],b[1]]}else{a.push(b);c=b}});if(a.length>=2&&a[a.length-2][0]=="stat"&&(a[a.length-1][0]=="return"||a[a.length-1][0]=="throw")&&a[a.length-1][1]){a.splice(a.length-2,2,[a[a.length-1][0],["seq",a[a.length-2][1],a[a.length-1][1]]])}return a})([]);return d};function make_if(c,t,e){return when_constant(c,function(a,b){if(b){t=walk(t);warn_unreachable(e);return t||["block"]}else{e=walk(e);warn_unreachable(t);return e||["block"]}},function(){return make_real_if(c,t,e)})};function abort_else(c,t,e){var a=[["if",negate(c),e]];if(t[0]=="block"){if(t[1])a=a.concat(t[1])}else{a.push(t)}return walk(["block",a])};function make_real_if(c,t,e){c=walk(c);t=walk(t);e=walk(e);if(empty(t)){c=negate(c);t=e;e=null}else if(empty(e)){e=null}else{(function(){var a=gen_code(c);var n=negate(c);var b=gen_code(n);if(b.length<a.length){var d=t;t=e;e=d;c=n}})()}if(empty(e)&&empty(t))return["stat",c];var f=["if",c,t,e];if(t[0]=="if"&&empty(t[3])&&empty(e)){f=best_of(f,walk(["if",["binary","&&",c,t[1]],t[2]]))}else if(t[0]=="stat"){if(e){if(e[0]=="stat")f=best_of(f,["stat",make_conditional(c,t[1],e[1])]);else if(aborts(e))f=abort_else(c,t,e)}else{f=best_of(f,["stat",make_conditional(c,t[1])])}}else if(e&&t[0]==e[0]&&(t[0]=="return"||t[0]=="throw")&&t[1]&&e[1]){f=best_of(f,[t[0],make_conditional(c,t[1],e[1])])}else if(e&&aborts(t)){f=[["if",c,t]];if(e[0]=="block"){if(e[1])f=f.concat(e[1])}else{f.push(e)}f=walk(["block",f])}else if(t&&aborts(e)){f=abort_else(c,t,e)}return f};function _do_while(c,d){return when_constant(c,function(a,b){if(!b){warn_unreachable(d);return["block"]}else{return["for",null,null,null,walk(d)]}})};return w.with_walkers({"sub":function(a,b){if(b[0]=="string"){var c=b[1];if(is_identifier(c))return["dot",walk(a),c];else if(/^[1-9][0-9]*$/.test(c)||c==="0")return["sub",walk(a),["num",parseInt(c,10)]]}},"if":make_if,"toplevel":function(a){return["toplevel",tighten(a)]},"switch":function(d,e){var f=e.length-1;return["switch",walk(d),MAP(e,function(a,i){var b=tighten(a[1]);if(i==f&&b.length>0){var c=b[b.length-1];if(c[0]=="break"&&!c[1])b.pop()}return[a[0]?walk(a[0]):null,b]})]},"function":_lambda,"defun":_lambda,"block":function(a){if(a)return rmblock(["block",tighten(a)])},"binary":function(a,b,d){return when_constant(["binary",a,walk(b),walk(d)],function yes(c){return best_of(walk(c),this)},function no(){return function(){if(a!="=="&&a!="!=")return;var l=walk(b),r=walk(d);if(l&&l[0]=="unary-prefix"&&l[1]=="!"&&l[2][0]=="num")b=['num',+!l[2][1]];else if(r&&r[0]=="unary-prefix"&&r[1]=="!"&&r[2][0]=="num")d=['num',+!r[2][1]];return["binary",a,b,d]}()||this})},"conditional":function(c,t,e){return make_conditional(walk(c),walk(t),walk(e))},"try":function(t,c,f){return["try",tighten(t),c!=null?[c[0],tighten(c[1])]:null,f!=null?tighten(f):null]},"unary-prefix":function(c,d){d=walk(d);var e=["unary-prefix",c,d];if(c=="!")e=best_of(e,negate(d));return when_constant(e,function(a,b){return walk(a)},function(){return e})},"name":function(a){switch(a){case"true":return["unary-prefix","!",["num",0]];case"false":return["unary-prefix","!",["num",1]]}},"while":_do_while,"assign":function(a,b,c){b=walk(b);c=walk(c);var d=['+','-','/','*','%','>>','<<','>>>','|','^','&'];if(a===true&&b[0]==="name"&&c[0]==="binary"&&~d.indexOf(c[1])&&c[2][0]==="name"&&c[2][1]===b[1]){return[this[0],c[1],b,c[3]]}return[this[0],a,b,c]}},function(){for(var i=0;i<2;++i){g=prepare_ifs(g);g=walk(g)}return g})};var DOT_CALL_NO_PARENS=jsp.array_to_hash(["name","array","object","string","dot","sub","call","regexp","defun"]);function make_string(a,b){var c=0,sq=0;a=a.replace(/[\\\b\f\n\r\t\x22\x27\u2028\u2029\0]/g,function(s){switch(s){case"\\":return"\\\\";case"\b":return"\\b";case"\f":return"\\f";case"\n":return"\\n";case"\r":return"\\r";case"\t":return"\\t";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";case'"':++c;return'"';case"'":++sq;return"'";case"\0":return"\\0"}return s});if(b)a=to_ascii(a);if(c>sq)return"'"+a.replace(/\x27/g,"\\'")+"'";else return'"'+a.replace(/\x22/g,'\\"')+'"'};function to_ascii(c){return c.replace(/[\u0080-\uffff]/g,function(a){var b=a.charCodeAt(0).toString(16);while(b.length<4)b="0"+b;return"\\u"+b})};var SPLICE_NEEDS_BRACKETS=jsp.array_to_hash(["if","while","do","for","for-in","with"]);function gen_code(g,h){h=defaults(h,{indent_start:0,indent_level:4,quote_keys:false,space_colon:false,beautify:false,ascii_only:false,inline_script:false});var j=!!h.beautify;var k=0,newline=j?"\n":"",space=j?" ":"";function encode_string(a){var b=make_string(a,h.ascii_only);if(h.inline_script)b=b.replace(/<\x2fscript([>\/\t\n\f\r ])/gi,"<\\/script$1");return b};function make_name(a){a=a.toString();if(h.ascii_only)a=to_ascii(a);return a};function indent(a){if(a==null)a="";if(j)a=repeat_string(" ",h.indent_start+k*h.indent_level)+a;return a};function with_indent(a,b){if(b==null)b=1;k+=b;try{return a.apply(null,slice(arguments,1))}finally{k-=b}};function add_spaces(a){if(j)return a.join(" ");var b=[];for(var i=0;i<a.length;++i){var c=a[i+1];b.push(a[i]);if(c&&((/[a-z0-9_\x24]$/i.test(a[i].toString())&&/^[a-z0-9_\x24]/i.test(c.toString()))||(/[\+\-]$/.test(a[i].toString())&&/^[\+\-]/.test(c.toString())))){b.push(" ")}}return b.join("")};function add_commas(a){return a.join(","+space)};function parenthesize(a){var b=l(a);for(var i=1;i<arguments.length;++i){var c=arguments[i];if((c instanceof Function&&c(a))||a[0]==c)return"("+b+")"}return b};function best_of(a){if(a.length==1){return a[0]}if(a.length==2){var b=a[1];a=a[0];return a.length<=b.length?a:b}return best_of([a[0],best_of(a.slice(1))])};function needs_parens(b){if(b[0]=="function"||b[0]=="object"){var a=slice(w.stack()),self=a.pop(),p=a.pop();while(p){if(p[0]=="stat")return true;if(((p[0]=="seq"||p[0]=="call"||p[0]=="dot"||p[0]=="sub"||p[0]=="conditional")&&p[1]===self)||((p[0]=="binary"||p[0]=="assign"||p[0]=="unary-postfix")&&p[2]===self)){self=p;p=a.pop()}else{return false}}}return!HOP(DOT_CALL_NO_PARENS,b[0])};function make_num(b){var c=b.toString(10),a=[c.replace(/^0\./,".")],m;if(Math.floor(b)===b){if(b>=0){a.push("0x"+b.toString(16).toLowerCase(),"0"+b.toString(8))}else{a.push("-0x"+(-b).toString(16).toLowerCase(),"-0"+(-b).toString(8))}if((m=/^(.*?)(0+)$/.exec(b))){a.push(m[1]+"e"+m[2].length)}}else if((m=/^0?\.(0+)(.*)$/.exec(b))){a.push(m[2]+"e-"+(m[1].length+m[2].length),c.substr(c.indexOf(".")))}return best_of(a)};var w=ast_walker();var l=w.walk;return w.with_walkers({"string":encode_string,"num":make_num,"name":make_name,"debugger":function(){return"debugger"},"toplevel":function(a){return make_block_statements(a).join(newline+newline)},"splice":function(b){var c=w.parent();if(HOP(SPLICE_NEEDS_BRACKETS,c)){return make_block.apply(this,arguments)}else{return MAP(make_block_statements(b,true),function(a,i){return i>0?indent(a):a}).join(newline)}},"block":make_block,"var":function(a){return"var "+add_commas(MAP(a,make_1vardef))+";"},"const":function(a){return"const "+add_commas(MAP(a,make_1vardef))+";"},"try":function(a,b,c){var d=["try",make_block(a)];if(b)d.push("catch","("+b[0]+")",make_block(b[1]));if(c)d.push("finally",make_block(c));return add_spaces(d)},"throw":function(a){return add_spaces(["throw",l(a)])+";"},"new":function(b,c){c=c.length>0?"("+add_commas(MAP(c,function(a){return parenthesize(a,"seq")}))+")":"";return add_spaces(["new",parenthesize(b,"seq","binary","conditional","assign",function(a){var w=ast_walker(),has_call={};try{w.with_walkers({"call":function(){throw has_call},"function":function(){return this}},function(){w.walk(a)})}catch(ex){if(ex===has_call)return true;throw ex;}})+c])},"switch":function(a,b){return add_spaces(["switch","("+l(a)+")",make_switch_block(b)])},"break":function(a){var b="break";if(a!=null)b+=" "+make_name(a);return b+";"},"continue":function(a){var b="continue";if(a!=null)b+=" "+make_name(a);return b+";"},"conditional":function(a,b,c){return add_spaces([parenthesize(a,"assign","seq","conditional"),"?",parenthesize(b,"seq"),":",parenthesize(c,"seq")])},"assign":function(a,b,c){if(a&&a!==true)a+="=";else a="=";return add_spaces([l(b),a,parenthesize(c,"seq")])},"dot":function(a){var b=l(a),i=1;if(a[0]=="num"){if(!/\./.test(a[1]))b+="."}else if(needs_parens(a))b="("+b+")";while(i<arguments.length)b+="."+make_name(arguments[i++]);return b},"call":function(b,c){var f=l(b);if(f.charAt(0)!="("&&needs_parens(b))f="("+f+")";return f+"("+add_commas(MAP(c,function(a){return parenthesize(a,"seq")}))+")"},"function":make_function,"defun":make_function,"if":function(a,b,c){var d=["if","("+l(a)+")",c?make_then(b):l(b)];if(c){d.push("else",l(c))}return add_spaces(d)},"for":function(a,b,c,d){var e=["for"];a=(a!=null?l(a):"").replace(/;*\s*$/,";"+space);b=(b!=null?l(b):"").replace(/;*\s*$/,";"+space);c=(c!=null?l(c):"").replace(/;*\s*$/,"");var f=a+b+c;if(f=="; ; ")f=";;";e.push("("+f+")",l(d));return add_spaces(e)},"for-in":function(a,b,c,d){return add_spaces(["for","("+(a?l(a).replace(/;+$/,""):l(b)),"in",l(c)+")",l(d)])},"while":function(a,b){return add_spaces(["while","("+l(a)+")",l(b)])},"do":function(a,b){return add_spaces(["do",l(b),"while","("+l(a)+")"])+";"},"return":function(a){var b=["return"];if(a!=null)b.push(l(a));return add_spaces(b)+";"},"binary":function(a,b,c){var d=l(b),right=l(c);if(member(b[0],["assign","conditional","seq"])||b[0]=="binary"&&PRECEDENCE[a]>PRECEDENCE[b[1]]||b[0]=="function"&&needs_parens(this)){d="("+d+")"}if(member(c[0],["assign","conditional","seq"])||c[0]=="binary"&&PRECEDENCE[a]>=PRECEDENCE[c[1]]&&!(c[1]==a&&member(a,["&&","||","*"]))){right="("+right+")"}else if(!j&&h.inline_script&&(a=="<"||a=="<<")&&c[0]=="regexp"&&/^script/i.test(c[1])){right=" "+right}return add_spaces([d,a,right])},"unary-prefix":function(a,b){var c=l(b);if(!(b[0]=="num"||(b[0]=="unary-prefix"&&!HOP(OPERATORS,a+b[1]))||!needs_parens(b)))c="("+c+")";return a+(jsp.is_alphanumeric_char(a.charAt(0))?" ":"")+c},"unary-postfix":function(a,b){var c=l(b);if(!(b[0]=="num"||(b[0]=="unary-postfix"&&!HOP(OPERATORS,a+b[1]))||!needs_parens(b)))c="("+c+")";return c+a},"sub":function(a,b){var c=l(a);if(needs_parens(a))c="("+c+")";return c+"["+l(b)+"]"},"object":function(b){var c=needs_parens(this);if(b.length==0)return c?"({})":"{}";var d="{"+newline+with_indent(function(){return MAP(b,function(p){if(p.length==3){return indent(make_function(p[0],p[1][2],p[1][3],p[2]))}var a=p[0],val=parenthesize(p[1],"seq");if(h.quote_keys){a=encode_string(a)}else if((typeof a=="number"||!j&&+a+""==a)&&parseFloat(a)>=0){a=make_num(+a)}else if(!is_identifier(a)){a=encode_string(a)}return indent(add_spaces(j&&h.space_colon?[a,":",val]:[a+":",val]))}).join(","+newline)})+newline+indent("}");return c?"("+d+")":d},"regexp":function(a,b){return"/"+a+"/"+b},"array":function(b){if(b.length==0)return"[]";return add_spaces(["[",add_commas(MAP(b,function(a,i){if(!j&&a[0]=="atom"&&a[1]=="undefined")return i===b.length-1?",":"";return parenthesize(a,"seq")})),"]"])},"stat":function(a){return l(a).replace(/;*\s*$/,";")},"seq":function(){return add_commas(MAP(slice(arguments),l))},"label":function(a,b){return add_spaces([make_name(a),":",l(b)])},"with":function(a,b){return add_spaces(["with","("+l(a)+")",l(b)])},"atom":function(a){return make_name(a)}},function(){return l(g)});function make_then(a){if(a==null)return";";if(a[0]=="do"){return make_block([a])}var b=a;while(true){var c=b[0];if(c=="if"){if(!b[3])return l(["block",[a]]);b=b[3]}else if(c=="while"||c=="do")b=b[2];else if(c=="for"||c=="for-in")b=b[4];else break}return l(a)};function make_function(a,b,c,d){var e=d||"function";if(a){e+=" "+make_name(a)}e+="("+add_commas(MAP(b,make_name))+")";e=add_spaces([e,make_block(c)]);return needs_parens(this)?"("+e+")":e};function must_has_semicolon(a){switch(a[0]){case"with":case"while":return empty(a[2]);case"for":case"for-in":return empty(a[4]);case"if":if(empty(a[2])&&!a[3])return true;if(a[3]){if(empty(a[3]))return true;return must_has_semicolon(a[3])}return must_has_semicolon(a[2])}};function make_block_statements(b,c){for(var a=[],last=b.length-1,i=0;i<=last;++i){var d=b[i];var e=l(d);if(e!=";"){if(!j&&i==last&&!must_has_semicolon(d)){e=e.replace(/;+\s*$/,"")}a.push(e)}}return c?a:MAP(a,indent)};function make_switch_block(c){var n=c.length;if(n==0)return"{}";return"{"+newline+MAP(c,function(a,i){var b=a[1].length>0,code=with_indent(function(){return indent(a[0]?add_spaces(["case",l(a[0])+":"]):"default:")},0.5)+(b?newline+with_indent(function(){return make_block_statements(a[1]).join(newline)}):"");if(!j&&b&&i<n-1)code+=";";return code}).join(newline)+newline+indent("}")};function make_block(a){if(!a)return";";if(a.length==0)return"{}";return"{"+newline+with_indent(function(){return make_block_statements(a).join(newline)})+newline+indent("}")};function make_1vardef(a){var b=a[0],val=a[1];if(val!=null)b=add_spaces([make_name(b),"=",parenthesize(val,"seq")]);return b}};function split_lines(e,f){var g=[0];jsp.parse(function(){var b=jsp.tokenizer(e);var c=0;var d;function current_length(a){return a.pos-c};function split_here(a){c=a.pos;g.push(c)};function custom(){var a=b.apply(this,arguments);out:{if(d){if(d.type=="keyword")break out}if(current_length(a)>f){switch(a.type){case"keyword":case"atom":case"name":case"punc":split_here(a);break out}}}d=a;return a};custom.context=function(){return b.context.apply(this,arguments)};return custom}());return g.map(function(a,i){return e.substring(a,g[i+1]||e.length)}).join("\n")};function repeat_string(a,i){if(i<=0)return"";if(i==1)return a;var d=repeat_string(a,i>>1);d+=d;if(i&1)d+=a;return d};function defaults(a,b){var c={};if(a===true)a={};for(var i in b)if(HOP(b,i)){c[i]=(a&&HOP(a,i))?a[i]:b[i]}return c};function is_identifier(b){return/^[a-z_$][a-z0-9_$]*$/i.test(b)&&b!="this"&&!HOP(jsp.KEYWORDS_ATOM,b)&&!HOP(jsp.RESERVED_WORDS,b)&&!HOP(jsp.KEYWORDS,b)};function HOP(a,b){return Object.prototype.hasOwnProperty.call(a,b)};var MAP;(function(){MAP=function(a,f,o){var c=[],top=[],i;function doit(){var b=f.call(o,a[i],i);if(b instanceof AtTop){b=b.v;if(b instanceof Splice){top.push.apply(top,b.v)}else{top.push(b)}}else if(b!=d){if(b instanceof Splice){c.push.apply(c,b.v)}else{c.push(b)}}};if(a instanceof Array)for(i=0;i<a.length;++i)doit();else for(i in a)if(HOP(a,i))doit();return top.concat(c)};MAP.at_top=function(a){return new AtTop(a)};MAP.splice=function(a){return new Splice(a)};var d=MAP.skip={};function AtTop(a){this.v=a};function Splice(a){this.v=a}})();exports.ast_walker=ast_walker;exports.ast_mangle=ast_mangle;exports.ast_squeeze=ast_squeeze;exports.ast_lift_variables=ast_lift_variables;exports.gen_code=gen_code;exports.ast_add_scope=ast_add_scope;exports.set_logger=function(a){warn=a};exports.make_string=make_string;exports.split_lines=split_lines;exports.MAP=MAP;exports.ast_squeeze_more=require("./squeeze-more").ast_squeeze_more;