/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.maven.plugin.AbstractWro4jMojo;
import ro.isdc.wro.maven.plugin.support.AggregatedFolderPathResolver;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.io.UnclosableBufferedInputStream;

public class Wro4jMojo
extends AbstractWro4jMojo {
    private File destinationFolder;
    private File cssDestinationFolder;
    private File jsDestinationFolder;
    private File buildDirectory;
    private File buildFinalName;
    private File groupNameMappingFile;
    private String contextPath;
    private final Properties groupNames = new Properties();

    @Override
    protected void validate() throws MojoExecutionException {
        super.validate();
        if (this.destinationFolder == null) {
            throw new MojoExecutionException("destinationFolder was not set!");
        }
    }

    @Override
    protected void onBeforeExecute() {
        this.groupNames.clear();
        if (this.groupNameMappingFile != null && this.isIncrementalBuild()) {
            try {
                this.groupNames.load((InputStream)new AutoCloseInputStream((InputStream)new FileInputStream(this.groupNameMappingFile)));
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Cannot load " + this.groupNameMappingFile.getPath()));
            }
        }
    }

    @Override
    protected void doExecute() throws Exception {
        if (this.contextPath != null) {
            this.getLog().info((CharSequence)("contextPath: " + this.contextPath));
        }
        this.getLog().info((CharSequence)("destinationFolder: " + this.destinationFolder));
        if (this.jsDestinationFolder != null) {
            this.getLog().info((CharSequence)("jsDestinationFolder: " + this.jsDestinationFolder));
        }
        if (this.cssDestinationFolder != null) {
            this.getLog().info((CharSequence)("cssDestinationFolder: " + this.cssDestinationFolder));
        }
        if (this.groupNameMappingFile != null) {
            this.getLog().info((CharSequence)("groupNameMappingFile: " + this.groupNameMappingFile));
        }
        List<String> groupsAsList = this.getTargetGroupsAsList();
        StopWatch watch = new StopWatch();
        watch.start("processGroups: " + groupsAsList);
        ArrayList<Callable> callables = new ArrayList<Callable>();
        for (String group : groupsAsList) {
            for (ResourceType resourceType : ResourceType.values()) {
                final File destinationFolder = this.computeDestinationFolder(resourceType);
                final String groupWithExtension = group + "." + resourceType.name().toLowerCase();
                if (this.isParallelProcessing()) {
                    callables.add(Context.decorate((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Wro4jMojo.this.processGroup(groupWithExtension, destinationFolder);
                            return null;
                        }
                    }));
                    continue;
                }
                this.processGroup(groupWithExtension, destinationFolder);
            }
        }
        if (this.isParallelProcessing()) {
            this.getTaskExecutor().submit(callables);
        }
        watch.stop();
        this.getLog().debug((CharSequence)watch.prettyPrint());
        this.writeGroupNameMap();
    }

    @Override
    protected boolean isIncrementalCheckRequired() {
        return super.isIncrementalCheckRequired() && this.destinationFolder.exists();
    }

    private void writeGroupNameMap() throws Exception {
        if (this.groupNameMappingFile != null) {
            File mappingFileParent = new File(this.groupNameMappingFile.getParent());
            mappingFileParent.mkdirs();
            try (FileOutputStream outputStream = new FileOutputStream(this.groupNameMappingFile);){
                this.groupNames.store(outputStream, "Mapping of defined group name to renamed group name");
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Unable to save group name mapping file", (Exception)ex);
            }
        }
    }

    private String rename(String group, InputStream input) throws Exception {
        try {
            String newName = ((WroManager)this.getManagerFactory().create()).getNamingStrategy().rename(group, input);
            this.groupNames.setProperty(group, newName);
            return newName;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error occured during renaming", (Exception)e);
        }
    }

    private File computeDestinationFolder(ResourceType resourceType) throws MojoExecutionException {
        File folder = this.destinationFolder;
        if (resourceType == ResourceType.JS && this.jsDestinationFolder != null) {
            folder = this.jsDestinationFolder;
        }
        if (resourceType == ResourceType.CSS && this.cssDestinationFolder != null) {
            folder = this.cssDestinationFolder;
        }
        this.getLog().info((CharSequence)("folder: " + folder));
        if (folder == null) {
            throw new MojoExecutionException("Couldn't compute destination folder for resourceType: " + resourceType + ". That means that you didn't define one of the following parameters: destinationFolder, cssDestinationFolder, jsDestinationFolder");
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroup(String group, File parentFoder) throws Exception {
        ByteArrayOutputStream resultOutputStream = null;
        InputStream resultInputStream = null;
        try {
            this.getLog().info((CharSequence)("processing group: " + group));
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getContextPath()).thenReturn((Object)this.normalizeContextPath(this.contextPath));
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            resultOutputStream = new ByteArrayOutputStream();
            Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)resultOutputStream));
            WroConfiguration config = Context.get().getConfig();
            config.setIgnoreEmptyGroup(Boolean.valueOf(true));
            Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))), (WroConfiguration)config);
            Context.get().setAggregatedFolderPath(this.getAggregatedPathResolver().resolve());
            ((WroManager)this.getManagerFactory().create()).process();
            resultInputStream = new UnclosableBufferedInputStream(resultOutputStream.toByteArray());
            File destinationFile = new File(parentFoder, this.rename(group, resultInputStream));
            File parentFolder = destinationFile.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            destinationFile.createNewFile();
            resultInputStream.reset();
            this.getLog().debug((CharSequence)("Created file: " + destinationFile.getName()));
            FileOutputStream fos = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)resultInputStream, (OutputStream)fos);
            ((OutputStream)fos).close();
            if (destinationFile.length() == 0L) {
                this.getLog().debug((CharSequence)("No content found for group: " + group));
                destinationFile.delete();
            } else {
                this.getLog().info((CharSequence)("file size: " + destinationFile.getName() + " -> " + destinationFile.length() + " bytes"));
                this.getLog().info((CharSequence)(destinationFile.getAbsolutePath() + " (" + destinationFile.length() + " bytes)"));
            }
        }
        finally {
            if (this.getBuildContext() != null) {
                this.getBuildContext().refresh(parentFoder);
            }
            if (resultOutputStream != null) {
                resultOutputStream.close();
            }
            if (resultInputStream != null) {
                resultInputStream.close();
            }
        }
    }

    private String normalizeContextPath(String contextPath) {
        String separator = "/";
        StringBuffer sb = new StringBuffer("/");
        if (contextPath != null) {
            String normalizedContextPath = contextPath;
            normalizedContextPath = StringUtils.removeStart((String)normalizedContextPath, (String)"/");
            normalizedContextPath = StringUtils.removeEnd((String)normalizedContextPath, (String)"/");
            sb.append(normalizedContextPath);
        }
        return sb.toString();
    }

    private AggregatedFolderPathResolver getAggregatedPathResolver() {
        return new AggregatedFolderPathResolver().setBuildDirectory(this.buildDirectory).setBuildFinalName(this.buildFinalName).setContextFoldersAsCSV(this.getContextFoldersAsCSV()).setCssDestinationFolder(this.cssDestinationFolder).setDestinationFolder(this.destinationFolder).setLog(this.getLog());
    }

    void setDestinationFolder(File destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    void setCssDestinationFolder(File cssDestinationFolder) {
        this.cssDestinationFolder = cssDestinationFolder;
    }

    void setJsDestinationFolder(File jsDestinationFolder) {
        this.jsDestinationFolder = jsDestinationFolder;
    }

    void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setBuildFinalName(File buildFinalName) {
        this.buildFinalName = buildFinalName;
    }

    void setGroupNameMappingFile(File groupNameMappingFile) {
        this.groupNameMappingFile = groupNameMappingFile;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

