/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.DelegatingServletOutputStream;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAwareManagerFactory;
import ro.isdc.wro.maven.plugin.AbstractWro4jMojo;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;

public abstract class AbstractSingleProcessorMojo
extends AbstractWro4jMojo {
    private String options;
    private boolean failNever;

    public final void doExecute() throws Exception {
        this.getLog().info((CharSequence)("options: " + this.options));
        this.getLog().info((CharSequence)("failNever: " + this.failNever));
        List<String> groupsAsList = this.getTargetGroupsAsList();
        for (String group : groupsAsList) {
            for (ResourceType resourceType : ResourceType.values()) {
                String groupWithExtension = group + "." + resourceType.name().toLowerCase();
                this.processGroup(groupWithExtension);
            }
        }
    }

    private void processGroup(String group) throws Exception {
        this.getLog().info((CharSequence)("processing group: " + group));
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)new ByteArrayOutputStream()));
        WroConfiguration config = Context.get().getConfig();
        Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))), (WroConfiguration)config);
        this.getLog().info((CharSequence)("ManagerFactory: " + this.getManagerFactory().create()));
        ((WroManager)this.getManagerFactory().create()).process();
        this.getLog().info((CharSequence)("Success processing group: " + group));
    }

    protected StandaloneContextAwareManagerFactory getManagerFactory() throws Exception {
        StandaloneContextAwareManagerFactory factory = super.getManagerFactory();
        factory.setProcessorsFactory(this.createSingleProcessorsFactory());
        return factory;
    }

    private ProcessorsFactory createSingleProcessorsFactory() {
        SimpleProcessorsFactory factory = new SimpleProcessorsFactory();
        ResourcePreProcessor processor = this.createResourceProcessor();
        factory.addPreProcessor(processor);
        return factory;
    }

    protected abstract ResourcePreProcessor createResourceProcessor();

    public String[] getOptions() {
        return StringUtils.isEmpty((CharSequence)this.options) ? new String[]{} : this.options.split(",");
    }

    void setOptions(String options) {
        this.options = options;
    }

    public void setFailNever(boolean failNever) {
        this.failNever = failNever;
    }

    public boolean isFailNever() {
        return this.failNever;
    }
}

