/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.manager.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.manager.ExtensionsConfigurableWroManagerFactory;
import ro.isdc.wro.extensions.model.factory.SmartWroModelFactory;
import ro.isdc.wro.manager.factory.standalone.ConfigurableStandaloneContextAwareManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.resource.processor.ProcessorsUtils;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableWroManagerFactory
extends ConfigurableStandaloneContextAwareManagerFactory
implements ExtraConfigFileAware {
    private StandaloneContext standaloneContext;
    private File configProperties;

    public void initialize(StandaloneContext standaloneContext) {
        super.initialize(standaloneContext);
        this.standaloneContext = standaloneContext;
    }

    protected WroModelFactory newModelFactory() {
        return SmartWroModelFactory.createFromStandaloneContext((StandaloneContext)this.standaloneContext);
    }

    protected Map<String, ResourcePreProcessor> createPreProcessorsMap() {
        Map map = ProcessorsUtils.createPreProcessorsMap();
        ExtensionsConfigurableWroManagerFactory.pupulateMapWithExtensionsProcessors((Map)map);
        return map;
    }

    protected Map<String, ResourcePostProcessor> createPostProcessorsMap() {
        Map map = ProcessorsUtils.createPostProcessorsMap();
        ExtensionsConfigurableWroManagerFactory.pupulateMapWithExtensionsProcessors((Map)map);
        return map;
    }

    protected Properties createProperties() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.configProperties));
            return properties;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while loading properties file from " + this.configProperties.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void setExtraConfigFile(File extraProperties) {
        this.configProperties = extraProperties;
    }
}

