/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractSingleProcessorMojo;
import ro.isdc.wro.maven.plugin.support.ProgressIndicator;
import ro.isdc.wro.model.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinterMojo<T>
extends AbstractSingleProcessorMojo {
    private boolean failNever;
    private boolean failFast = true;
    private int failThreshold = 0;
    private LintReport<T> lintReport;
    private ProgressIndicator progressIndicator;

    protected final void addReport(ResourceLintReport<T> report) {
        this.lintReport.addReport(report);
    }

    @Override
    protected void onBeforeExecute() {
        this.progressIndicator = new ProgressIndicator(this.getLog());
        this.getLog().info((CharSequence)("failNever: " + this.failNever));
        this.progressIndicator.reset();
        this.validateReportFormat();
        this.lintReport = new LintReport();
        FileUtils.deleteQuietly((File)this.getReportFile());
    }

    @Override
    protected void onAfterExecute() {
        super.onAfterExecute();
        this.progressIndicator.logSummary();
        this.generateReport();
        this.checkFailStatus();
    }

    private void generateReport() {
        if (this.shouldGenerateReport()) {
            FileOutputStream reportFileStream = null;
            try {
                this.getReportFile().getParentFile().mkdirs();
                this.getReportFile().createNewFile();
                this.getLog().debug((CharSequence)("creating report at location: " + this.getReportFile()));
                ReportXmlFormatter.FormatterType type = ReportXmlFormatter.FormatterType.getByFormat((String)this.getReportFormat());
                if (type != null) {
                    reportFileStream = new FileOutputStream(this.getReportFile());
                    this.createXmlFormatter(this.lintReport, type).write((OutputStream)reportFileStream);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not create report file: " + this.getReportFile()), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(reportFileStream);
            }
        }
    }

    private void checkFailStatus() {
        if (!this.failFast && this.isStatusFailed()) {
            throw new WroRuntimeException("Build status: failed.");
        }
    }

    protected abstract ReportXmlFormatter createXmlFormatter(LintReport<T> var1, ReportXmlFormatter.FormatterType var2);

    protected final void onProcessingResource(Resource resource) {
        this.progressIndicator.onProcessingResource(resource);
    }

    protected final boolean isFailAllowed() {
        return this.failFast && this.isStatusFailed();
    }

    protected abstract File getReportFile();

    protected abstract String getReportFormat();

    protected final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    private boolean isStatusFailed() {
        int foundErrors = this.progressIndicator.getTotalFoundErrors();
        return !this.failNever && foundErrors > 0 && foundErrors >= this.failThreshold;
    }

    private void validateReportFormat() {
        if (ReportXmlFormatter.FormatterType.getByFormat((String)this.getReportFormat()) == null) {
            throw new WroRuntimeException("Usupported report format: " + this.getReportFormat() + ". Valid formats are: " + ReportXmlFormatter.FormatterType.getSupportedFormatsAsCSV());
        }
    }

    private boolean shouldGenerateReport() {
        return this.getReportFile() != null;
    }

    void onException(Exception e) {
    }

    @Override
    public void setFailNever(boolean failNever) {
        this.failNever = failNever;
    }

    public void setFailThreshold(int failThreshold) {
        this.failThreshold = failThreshold;
    }

    @Override
    public boolean isFailNever() {
        return this.failNever;
    }

    boolean isFailFast() {
        return this.failFast;
    }

    LintReport<T> getLintReport() {
        return this.lintReport;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }
}

