/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerRegistry;
import ro.pippo.controller.ControllerRouteFactory;
import ro.pippo.controller.DefaultControllerRouteFactory;
import ro.pippo.core.Application;
import ro.pippo.core.PippoSettings;

public class ControllerApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(ControllerApplication.class);
    private ControllerRouteFactory controllerRouteFactory;

    public ControllerApplication() {
    }

    public ControllerApplication(PippoSettings settings) {
        super(settings);
    }

    public ControllerRouteFactory getControllerRouteFactory() {
        if (this.controllerRouteFactory == null) {
            this.controllerRouteFactory = new DefaultControllerRouteFactory().setContentTypeEngines(this.getContentTypeEngines());
        }
        return this.controllerRouteFactory;
    }

    public ControllerApplication setControllerRouteFactory(ControllerRouteFactory controllerRouteFactory) {
        this.controllerRouteFactory = controllerRouteFactory;
        log.debug("Controller route factory is '{}'", (Object)controllerRouteFactory.getClass().getName());
        return this;
    }

    public ControllerApplication addControllers(String ... packageNames) {
        ControllerRegistry controllerRegistry = new ControllerRegistry().setControllerRouteFactory(this.getControllerRouteFactory());
        controllerRegistry.register(packageNames);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Package ... packages) {
        ControllerRegistry controllerRegistry = new ControllerRegistry().setControllerRouteFactory(this.getControllerRouteFactory());
        controllerRegistry.register(packages);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Class<? extends Controller> ... controllerClasses) {
        ControllerRegistry controllerRegistry = new ControllerRegistry().setControllerRouteFactory(this.getControllerRouteFactory());
        controllerRegistry.register(controllerClasses);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public ControllerApplication addControllers(Controller ... controllers) {
        ControllerRegistry controllerRegistry = new ControllerRegistry().setControllerRouteFactory(this.getControllerRouteFactory());
        controllerRegistry.register(controllers);
        controllerRegistry.getRoutes().forEach(arg_0 -> ((ControllerApplication)this).addRoute(arg_0));
        return this;
    }

    public static ControllerApplication get() {
        return (ControllerApplication)Application.get();
    }
}

