/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.Consumes;
import ro.pippo.controller.Controller;
import ro.pippo.controller.ControllerFactory;
import ro.pippo.controller.DefaultControllerFactory;
import ro.pippo.controller.Interceptor;
import ro.pippo.controller.MethodParameter;
import ro.pippo.controller.NoCache;
import ro.pippo.controller.Produces;
import ro.pippo.controller.extractor.MethodParameterExtractor;
import ro.pippo.controller.util.ClassUtils;
import ro.pippo.controller.util.ControllerUtils;
import ro.pippo.core.ContentTypeEngines;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Request;
import ro.pippo.core.route.DefaultRouteContext;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;
import ro.pippo.core.route.RouteMatch;
import ro.pippo.core.util.LangUtils;
import ro.pippo.core.util.ServiceLocator;
import ro.pippo.core.util.StringUtils;

public class ControllerHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerHandler.class);
    private final Class<? extends Controller> controllerClass;
    private final Method controllerMethod;
    private ControllerFactory controllerFactory;
    private final List<String> declaredConsumes;
    private final List<String> declaredProduces;
    private final boolean isNoCache;
    private List<RouteHandler<?>> interceptors;
    private List<MethodParameterExtractor> availableExtractors;
    private MethodParameterExtractor[] extractors;
    private Controller controller;

    public ControllerHandler(ContentTypeEngines contentTypeEngines, Method controllerMethod) {
        this.controllerClass = controllerMethod.getDeclaringClass();
        this.controllerMethod = controllerMethod;
        this.declaredConsumes = ControllerUtils.getConsumes(controllerMethod);
        this.validateConsumes(contentTypeEngines.getContentTypes());
        this.declaredProduces = ControllerUtils.getProduces(controllerMethod);
        this.validateProduces(contentTypeEngines.getContentTypes());
        this.isNoCache = ClassUtils.getAnnotation(controllerMethod, NoCache.class) != null;
        this.initInterceptors();
        this.initExtractors();
    }

    public void handle(RouteContext routeContext) {
        try {
            if (!this.canConsume(routeContext)) {
                routeContext.next();
                return;
            }
            log.trace("Processing '{}' interceptors", (Object)LangUtils.toString((Method)this.controllerMethod));
            int preInterceptStatus = routeContext.getResponse().getStatus();
            this.processRouteInterceptors(routeContext);
            int postInterceptStatus = routeContext.getResponse().getStatus();
            if (routeContext.getResponse().isCommitted()) {
                log.debug("Response committed by interceptor");
                routeContext.next();
                return;
            }
            if (preInterceptStatus != postInterceptStatus && postInterceptStatus >= 300) {
                log.debug("Interceptor set status code to {}, committing response", (Object)routeContext.getResponse().getStatus());
                routeContext.getResponse().commit();
                routeContext.next();
                return;
            }
            log.trace("Preparing '{}' parameters from request", (Object)LangUtils.toString((Method)this.controllerMethod));
            Object[] values = this.prepareMethodParameters(routeContext);
            log.trace("Invoking '{}'", (Object)LangUtils.toString((Method)this.controllerMethod));
            Controller controller = this.getController();
            this.specifyCacheControls(routeContext);
            this.specifyContentType(routeContext);
            Object result = this.controllerMethod.invoke((Object)controller, values);
            if (routeContext.getResponse().isCommitted()) {
                log.debug("Response committed in {}", (Object)LangUtils.toString((Method)this.controllerMethod));
            } else if (!this.controllerMethod.getReturnType().equals(Void.TYPE)) {
                if (result == null) {
                    routeContext.getResponse().notFound();
                } else if (result instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)result;
                    routeContext.send(charSequence);
                } else if (result instanceof File) {
                    File file = (File)result;
                    routeContext.send(file);
                } else {
                    routeContext.send(result);
                }
            }
            routeContext.next();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                Exception target = (Exception)t;
                this.handleDeclaredThrownException(target, routeContext);
            } else {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                log.error("Failed to handle controller method exception", t);
            }
        }
        catch (Exception e) {
            this.handleDeclaredThrownException(e, routeContext);
        }
    }

    public List<MethodParameterExtractor> getMethodParameterExtractors() {
        if (this.availableExtractors == null) {
            this.availableExtractors = ServiceLocator.locateAll(MethodParameterExtractor.class);
        }
        return this.availableExtractors;
    }

    public ControllerHandler setMethodParameterExtractors(List<MethodParameterExtractor> extractors) {
        this.availableExtractors = extractors;
        return this;
    }

    public ControllerFactory getControllerFactory() {
        if (this.controllerFactory == null) {
            this.controllerFactory = new DefaultControllerFactory();
        }
        return this.controllerFactory;
    }

    public ControllerHandler setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
        return this;
    }

    protected Controller getController() {
        if (this.controller == null) {
            return this.getControllerFactory().createController(this.controllerClass);
        }
        return this.controller;
    }

    protected void setController(Controller controller) {
        this.controller = controller;
    }

    protected void initInterceptors() {
        this.interceptors = new ArrayList();
        ControllerUtils.collectRouteInterceptors(this.controllerMethod).forEach(handlerClass -> {
            try {
                this.interceptors.add((RouteHandler<?>)handlerClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PippoRuntimeException((Throwable)e);
            }
        });
    }

    protected void initExtractors() {
        Parameter[] parameters = this.controllerMethod.getParameters();
        this.extractors = new MethodParameterExtractor[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = new MethodParameter(this.controllerMethod, i);
            MethodParameterExtractor extractor = this.getMethodParameterExtractors().stream().filter(e -> e.isApplicable(parameter)).findFirst().orElse(null);
            if (extractor == null) {
                throw new PippoRuntimeException("Method '{}' parameter {} of type '{}' does not specify a extractor", new Object[]{LangUtils.toString((Method)this.controllerMethod), i + 1, parameter.getParameterType()});
            }
            this.extractors[i] = extractor;
        }
    }

    protected void validateConsumes(Collection<String> contentTypes) {
        TreeSet<String> ignoreConsumes = new TreeSet<String>();
        ignoreConsumes.add("*/*");
        ignoreConsumes.add("text/html");
        ignoreConsumes.add("text/xhtml");
        ignoreConsumes.add("application/x-www-form-urlencoded");
        ignoreConsumes.add("multipart/form-data");
        for (String declaredConsume : this.declaredConsumes) {
            if (ignoreConsumes.contains(declaredConsume)) continue;
            String consume = declaredConsume;
            int fuzz = consume.indexOf(42);
            if (fuzz > -1) {
                consume = consume.substring(0, fuzz);
            }
            if (contentTypes.contains(consume)) continue;
            if (consume.equals(declaredConsume)) {
                throw new PippoRuntimeException("{} declares @{}(\"{}\") but there is no registered ContentTypeEngine for that type!", new Object[]{LangUtils.toString((Method)this.controllerMethod), Consumes.class.getSimpleName(), declaredConsume});
            }
            throw new PippoRuntimeException("{} declares @{}(\"{}\") but there is no registered ContentTypeEngine for \"{}\"!", new Object[]{LangUtils.toString((Method)this.controllerMethod), Consumes.class.getSimpleName(), declaredConsume, consume});
        }
    }

    protected void validateProduces(Collection<String> contentTypes) {
        TreeSet<String> ignoreProduces = new TreeSet<String>();
        ignoreProduces.add("text/plain");
        ignoreProduces.add("text/html");
        ignoreProduces.add("text/xhtml");
        for (String produces : this.declaredProduces) {
            if (ignoreProduces.contains(produces) || contentTypes.contains(produces)) continue;
            throw new PippoRuntimeException("{} declares @{}(\"{}\") but there is no registered ContentTypeEngine for that type!", new Object[]{LangUtils.toString((Method)this.controllerMethod), Produces.class.getSimpleName(), produces});
        }
    }

    protected boolean canConsume(RouteContext routeContext) {
        Set<String> contentTypes = this.getContentTypes(routeContext.getRequest());
        if (!this.declaredConsumes.isEmpty()) {
            if (this.declaredConsumes.contains("*/*")) {
                log.debug("{} will handle Request because it consumes '{}'", (Object)LangUtils.toString((Method)this.controllerMethod), (Object)"*/*");
                return true;
            }
            LinkedHashSet<String> types = new LinkedHashSet<String>(contentTypes);
            if (types.isEmpty()) {
                types.addAll(this.getAcceptTypes(routeContext.getRequest()));
                if (types.contains("*") || types.contains("*/*")) {
                    log.debug("{} will handle Request because it consumes '{}'", (Object)LangUtils.toString((Method)this.controllerMethod), (Object)"*/*");
                    return true;
                }
            }
            for (String type : types) {
                if (this.declaredConsumes.contains(type)) {
                    log.debug("{} will handle Request because it consumes '{}'", (Object)LangUtils.toString((Method)this.controllerMethod), (Object)type);
                    return true;
                }
                for (String declaredType : this.declaredConsumes) {
                    String fuzzyType;
                    int fuzz = declaredType.indexOf(42);
                    if (fuzz <= -1 || !type.startsWith(fuzzyType = declaredType.substring(0, fuzz))) continue;
                    log.debug("{} will handle Request because it consumes '{}'", (Object)LangUtils.toString((Method)this.controllerMethod), (Object)type);
                    return true;
                }
            }
            if (types.isEmpty()) {
                log.warn("{} can not handle Request because neither 'Accept' nor 'Content-Type' are set and Route @Consumes '{}'", (Object)LangUtils.toString((Method)this.controllerMethod), this.declaredConsumes);
            } else {
                log.warn("{} can not handle Request for '{}' because Route @Consumes '{}'", new Object[]{LangUtils.toString((Method)this.controllerMethod), types, this.declaredConsumes});
            }
            return false;
        }
        return true;
    }

    protected void processRouteInterceptors(RouteContext routeContext) {
        if (this.interceptors.isEmpty()) {
            return;
        }
        ArrayList<RouteMatch> chain = new ArrayList<RouteMatch>();
        for (RouteHandler<?> interceptor : this.interceptors) {
            Route route = new Route(routeContext.getRequestMethod(), routeContext.getRequestUri(), interceptor);
            route.setName(StringUtils.format((String)"{}<{}>", (Object[])new Object[]{Interceptor.class.getSimpleName(), route.getRouteHandler().getClass().getSimpleName()}));
            route.bindAll(routeContext.getRoute().getAttributes());
            RouteMatch match = new RouteMatch(route, null);
            chain.add(match);
        }
        DefaultRouteContext context = new DefaultRouteContext(routeContext.getApplication(), routeContext.getRequest(), routeContext.getResponse(), chain);
        context.next();
    }

    protected Object[] prepareMethodParameters(RouteContext routeContext) {
        Parameter[] parameters = this.controllerMethod.getParameters();
        if (parameters.length == 0) {
            return new Object[0];
        }
        Object[] values = new Object[parameters.length];
        for (int i = 0; i < values.length; ++i) {
            MethodParameter parameter = new MethodParameter(this.controllerMethod, i);
            Class<?> type = parameter.getParameterType();
            MethodParameterExtractor extractor = this.extractors[i];
            Object value = extractor.extract(parameter, routeContext);
            if (value != null && !ClassUtils.isAssignable(value, type)) {
                String parameterName = parameter.getParameterName();
                throw new PippoRuntimeException("Type for '{}' is actually '{}' but was specified as '{}'!", new Object[]{parameterName, value.getClass().getName(), type.getName()});
            }
            values[i] = value;
        }
        return values;
    }

    protected void specifyCacheControls(RouteContext routeContext) {
        if (this.isNoCache) {
            log.debug("NoCache detected, response may not be cached");
            routeContext.getResponse().noCache();
        }
    }

    protected void specifyContentType(RouteContext routeContext) {
        if (!this.declaredProduces.isEmpty()) {
            String defaultContentType = this.declaredProduces.get(0);
            routeContext.getResponse().contentType(defaultContentType);
            if (this.declaredProduces.size() > 1) {
                routeContext.negotiateContentType();
            }
        }
    }

    protected void handleDeclaredThrownException(Exception e, RouteContext routeContext) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new PippoRuntimeException((Throwable)e);
    }

    private Set<String> getAcceptTypes(Request request) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.addAll(this.getContentTypes(request.getAcceptType()));
        types.addAll(this.getContentTypes(request.getHttpServletRequest().getHeader("Accept")));
        return types;
    }

    private Set<String> getContentTypes(Request request) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.addAll(this.getContentTypes(request.getContentType()));
        types.addAll(this.getContentTypes(request.getHttpServletRequest().getContentType()));
        return types;
    }

    private Set<String> getContentTypes(String contentType) {
        String[] types;
        if (StringUtils.isNullOrEmpty((String)contentType)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String type : types = contentType.split(",")) {
            if (type.contains(";")) {
                type = type.substring(0, type.indexOf(59));
            }
            set.add(type.trim().toLowerCase());
        }
        return set;
    }
}

