/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.controller.ControllerFactory;
import ro.pippo.controller.ControllerHandler;
import ro.pippo.controller.ControllerRouteFactory;
import ro.pippo.controller.DefaultControllerFactory;
import ro.pippo.core.ContentTypeEngines;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteHandler;

public class DefaultControllerRouteFactory
implements ControllerRouteFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultControllerRouteFactory.class);
    private ContentTypeEngines contentTypeEngines;
    private ControllerFactory controllerFactory;

    @Override
    public Route createRoute(String requestMethod, String uriPattern, Method controllerMethod) {
        RouteHandler<?> handler = this.createRouteHandler(controllerMethod);
        Route route = new Route(requestMethod, uriPattern, handler).bind("__controllerClass", controllerMethod.getDeclaringClass()).bind("__controllerMethod", (Object)controllerMethod);
        log.debug("Created route '{}' for '{}'", (Object)route, (Object)controllerMethod);
        return route;
    }

    protected RouteHandler<?> createRouteHandler(Method controllerMethod) {
        return new ControllerHandler(this.getContentTypeEngines(), controllerMethod).setControllerFactory(this.getControllerFactory());
    }

    public ContentTypeEngines getContentTypeEngines() {
        if (this.contentTypeEngines == null) {
            return new ContentTypeEngines();
        }
        return this.contentTypeEngines;
    }

    public DefaultControllerRouteFactory setContentTypeEngines(ContentTypeEngines contentTypeEngines) {
        this.contentTypeEngines = contentTypeEngines;
        return this;
    }

    public ControllerFactory getControllerFactory() {
        if (this.controllerFactory == null) {
            this.controllerFactory = new DefaultControllerFactory();
        }
        return this.controllerFactory;
    }

    public DefaultControllerRouteFactory setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
        return this;
    }
}

