/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.controller.extractor;

import java.lang.reflect.Method;
import java.util.Collection;
import ro.pippo.controller.MethodParameter;
import ro.pippo.controller.extractor.MethodParameterExtractor;
import ro.pippo.controller.extractor.Param;
import ro.pippo.core.FileItem;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.util.LangUtils;
import ro.pippo.core.util.StringUtils;

public class ParamExtractor
implements MethodParameterExtractor {
    @Override
    public boolean isApplicable(MethodParameter parameter) {
        return parameter.isAnnotationPresent(Param.class);
    }

    @Override
    public Object extract(MethodParameter parameter, RouteContext routeContext) {
        Param annotation = parameter.getAnnotation(Param.class);
        String name = this.getParameterName(parameter, annotation);
        String pattern = annotation.pattern();
        ParameterValue parameterValue = routeContext.getParameter(name);
        Class<?> parameterType = parameter.getParameterType();
        if (Collection.class.isAssignableFrom(parameterType)) {
            Class<?> collectionType = parameterType;
            Class<?> objectType = parameter.getParameterGenericType();
            return parameterValue.toCollection(collectionType, objectType, pattern);
        }
        if (FileItem.class.isAssignableFrom(parameterType)) {
            return routeContext.getRequest().getFile(name);
        }
        return parameterValue.to(parameterType, pattern);
    }

    private String getParameterName(MethodParameter parameter, Param annotation) {
        String name = annotation.value();
        if (StringUtils.isNullOrEmpty((String)name)) {
            name = parameter.getParameterName();
        }
        if (name == null) {
            throw new PippoRuntimeException("Method '{}' parameter {} does not specify a name!", new Object[]{LangUtils.toString((Method)parameter.getMethod()), parameter.getParameterIndex()});
        }
        return name;
    }
}

