/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class CountedHandler
implements RouteHandler {
    final String counterName;
    final boolean isActive;
    final MetricRegistry metricRegistry;
    final RouteHandler routeHandler;

    public CountedHandler(String counterName, boolean isActive, RouteHandler routeHandler) {
        this(counterName, isActive, SharedMetricRegistries.getDefault(), routeHandler);
    }

    public CountedHandler(String counterName, boolean isActive, MetricRegistry metricRegistry, RouteHandler routeHandler) {
        this.counterName = counterName;
        this.isActive = isActive;
        this.metricRegistry = metricRegistry;
        this.routeHandler = routeHandler;
    }

    public void handle(RouteContext routeContext) {
        Counter counter = this.metricRegistry.counter(this.counterName);
        counter.inc();
        try {
            this.routeHandler.handle(routeContext);
        }
        finally {
            if (this.isActive) {
                counter.dec();
            }
        }
    }
}

