/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.SortedMap;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class HealthCheckHandler
implements RouteHandler {
    final HealthCheckRegistry healthCheckRegistry;

    public HealthCheckHandler(HealthCheckRegistry healthCheckRegistry) {
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public void handle(RouteContext routeContext) {
        Response response = routeContext.getResponse().noCache().text();
        SortedMap healthChecks = this.healthCheckRegistry.runHealthChecks();
        if (healthChecks.isEmpty()) {
            response.notImplemented().send((CharSequence)"The health checks are empty");
        } else {
            boolean notHealthy = healthChecks.values().stream().anyMatch(hc -> !hc.isHealthy());
            if (notHealthy) {
                response.internalError().send((CharSequence)"The health is bad");
            } else {
                response.ok().send((CharSequence)"The health is good");
            }
        }
    }
}

