/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.route.RoutePostDispatchListener;
import ro.pippo.core.route.RoutePreDispatchListener;

public class MetricsDispatchListener
implements RoutePreDispatchListener,
RoutePostDispatchListener {
    protected Meter allRequestsMeter;
    protected Counter activeRequests;
    protected Meter badRequests;
    protected Meter unauthorizedRequests;
    protected Meter forbiddenRequests;
    protected Meter routesNotFound;
    protected Meter conflictRequests;
    protected Meter internalServerErrors;

    public MetricsDispatchListener(MetricRegistry metricRegistry) {
        this.allRequestsMeter = metricRegistry.meter("dispatcher.requests.allRequests");
        this.activeRequests = metricRegistry.counter("dispatcher.requests.activeRequests");
        this.badRequests = metricRegistry.meter("dispatcher.requests.400BadRequests");
        this.unauthorizedRequests = metricRegistry.meter("dispatcher.requests.401Unauthorized");
        this.forbiddenRequests = metricRegistry.meter("dispatcher.requests.403Forbidden");
        this.routesNotFound = metricRegistry.meter("dispatcher.requests.404NotFound");
        this.conflictRequests = metricRegistry.meter("dispatcher.requests.409Conflict");
        this.internalServerErrors = metricRegistry.meter("dispatcher.requests.500InternalError");
    }

    public void onPreDispatch(Request request, Response response) {
        this.activeRequests.inc();
    }

    public void onPostDispatch(Request request, Response response) {
        this.updateStatusCodeMetrics(response);
        this.activeRequests.dec();
    }

    protected void updateStatusCodeMetrics(Response response) {
        this.allRequestsMeter.mark();
        switch (response.getStatus()) {
            case 400: {
                this.badRequests.mark();
                break;
            }
            case 401: {
                this.unauthorizedRequests.mark();
                break;
            }
            case 403: {
                this.forbiddenRequests.mark();
                break;
            }
            case 404: {
                this.routesNotFound.mark();
                break;
            }
            case 409: {
                this.conflictRequests.mark();
                break;
            }
            case 500: {
                this.internalServerErrors.mark();
                break;
            }
        }
    }
}

