/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class MetricsHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(MetricsHandler.class);
    public static final TimeUnit DEFAULT_RATE_UNIT = TimeUnit.SECONDS;
    public static final TimeUnit DEFAULT_DURATION_UNIT = TimeUnit.MILLISECONDS;
    public static final double DEFAULT_RATE_FACTOR = DEFAULT_RATE_UNIT.toSeconds(1L);
    public static final double DEFAULT_DURATION_FACTOR = 1.0 / (double)DEFAULT_DURATION_UNIT.toNanos(1L);
    final MetricRegistry metricRegistry;
    TimeUnit durationUnit = DEFAULT_DURATION_UNIT;
    double durationFactor = DEFAULT_DURATION_FACTOR;
    TimeUnit rateUnit = DEFAULT_RATE_UNIT;
    double rateFactor = DEFAULT_RATE_FACTOR;

    public MetricsHandler() {
        this(SharedMetricRegistries.getDefault());
    }

    public MetricsHandler(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public MetricsHandler withRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public MetricsHandler withDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    public void handle(RouteContext routeContext) {
        Response response = routeContext.getResponse().noCache().text();
        try (BufferedWriter writer = new BufferedWriter(response.getWriter());){
            SortedMap timers;
            SortedMap meters;
            SortedMap histograms;
            SortedMap counters;
            SortedMap gauges = this.metricRegistry.getGauges();
            if (gauges.size() > 0) {
                this.writeGauges(gauges, writer);
                writer.newLine();
            }
            if ((counters = this.metricRegistry.getCounters()).size() > 0) {
                this.writeCounters(counters, writer);
                writer.newLine();
            }
            if ((histograms = this.metricRegistry.getHistograms()).size() > 0) {
                this.writeHistograms(histograms, writer);
                writer.newLine();
            }
            if ((meters = this.metricRegistry.getMeters()).size() > 0) {
                this.writeMeters(meters, writer);
                writer.newLine();
            }
            if ((timers = this.metricRegistry.getTimers()).size() > 0) {
                this.writeTimers(timers, writer);
            }
            writer.flush();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeGauges(SortedMap<String, Gauge> gauges, BufferedWriter writer) throws IOException {
        this.writeBanner("Gauges", writer);
        for (String key : gauges.keySet()) {
            writer.write(key + " = " + ((Gauge)gauges.get(key)).getValue());
            writer.newLine();
        }
    }

    protected void writeCounters(SortedMap<String, Counter> counters, BufferedWriter writer) throws IOException {
        this.writeBanner("Counters", writer);
        for (String key : counters.keySet()) {
            writer.write(key + " = " + ((Counter)counters.get(key)).getCount());
            writer.newLine();
        }
    }

    protected void writeHistograms(SortedMap<String, Histogram> histograms, BufferedWriter writer) throws IOException {
        this.writeBanner("Histograms", writer);
        for (String key : histograms.keySet()) {
            writer.write(key);
            writer.newLine();
            this.writeHistogram((Histogram)histograms.get(key), writer);
            writer.newLine();
        }
    }

    protected void writeHistogram(Histogram histogram, BufferedWriter writer) throws IOException {
        writer.write("   count = " + histogram.getCount());
        writer.newLine();
        this.writeSnapshot(histogram.getSnapshot(), false, writer);
    }

    protected void writeMeters(SortedMap<String, Meter> meters, BufferedWriter writer) throws IOException {
        this.writeBanner("Meters", writer);
        for (String key : meters.keySet()) {
            writer.write(key);
            writer.newLine();
            this.writeMeter((Meter)meters.get(key), writer);
        }
    }

    protected void writeMeter(Meter meter, BufferedWriter writer) throws IOException {
        this.writeMetered((Metered)meter, writer);
    }

    protected void writeTimers(SortedMap<String, Timer> timers, BufferedWriter writer) throws IOException {
        this.writeBanner("Timers", writer);
        for (String key : timers.keySet()) {
            writer.write(key);
            writer.newLine();
            this.writeTimer((Timer)timers.get(key), writer);
            writer.newLine();
        }
    }

    protected void writeTimer(Timer timer, BufferedWriter writer) throws IOException {
        this.writeMetered((Metered)timer, writer);
        this.writeSnapshot(timer.getSnapshot(), true, writer);
    }

    protected void writeMetered(Metered metered, BufferedWriter writer) throws IOException {
        this.writeWithIndent("count = " + metered.getCount(), writer);
        this.writeWithIndent("mean rate = " + this.getRateString(metered.getMeanRate()), writer);
        this.writeWithIndent("1-minute rate = " + this.getRateString(metered.getOneMinuteRate()), writer);
        this.writeWithIndent("5-minute rate = " + this.getRateString(metered.getFiveMinuteRate()), writer);
        this.writeWithIndent("15-minute rate = " + this.getRateString(metered.getFifteenMinuteRate()), writer);
        this.writeWithIndent("rate unit = " + (Object)((Object)this.rateUnit), writer);
    }

    protected void writeSnapshot(Snapshot snapshot, boolean duration, BufferedWriter writer) throws IOException {
        this.writeWithIndent("min = " + this.getSnapshotValueString(snapshot.getMin(), duration), writer);
        this.writeWithIndent("max = " + this.getSnapshotValueString(snapshot.getMax(), duration), writer);
        this.writeWithIndent("mean = " + this.getSnapshotValueString(snapshot.getMean(), duration), writer);
        this.writeWithIndent("stdDev = " + this.getSnapshotValueString(snapshot.getStdDev(), duration), writer);
        this.writeWithIndent("median = " + this.getSnapshotValueString(snapshot.getMedian(), duration), writer);
        this.writeWithIndent("75%% <= " + this.getSnapshotValueString(snapshot.get75thPercentile(), duration), writer);
        this.writeWithIndent("95%% <= " + this.getSnapshotValueString(snapshot.get95thPercentile(), duration), writer);
        this.writeWithIndent("98%% <= " + this.getSnapshotValueString(snapshot.get98thPercentile(), duration), writer);
        this.writeWithIndent("99%% <= " + this.getSnapshotValueString(snapshot.get99thPercentile(), duration), writer);
        this.writeWithIndent("99.9%% <= " + this.getSnapshotValueString(snapshot.get999thPercentile(), duration), writer);
        if (duration) {
            this.writeWithIndent("duration unit = " + (Object)((Object)this.durationUnit), writer);
        }
    }

    protected String getRateString(double value) {
        return this.toString(value * this.rateFactor);
    }

    protected String getSnapshotValueString(double value, boolean duration) {
        return duration ? this.getDurationString(value) : String.valueOf(value);
    }

    protected String getDurationString(double value) {
        return this.toString(value * this.durationFactor);
    }

    protected String toString(double value) {
        return String.format("%.2f", value);
    }

    protected void writeBanner(String banner, BufferedWriter writer) throws IOException {
        writer.write("### " + banner + " ###");
        writer.newLine();
    }

    protected void writeWithIndent(String text, BufferedWriter writer) throws IOException {
        writer.write("   " + text);
        writer.newLine();
    }
}

