/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.Initializer;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.route.RouteTransformer;
import ro.pippo.core.util.ServiceLocator;
import ro.pippo.metrics.MetricsDispatchListener;
import ro.pippo.metrics.MetricsReporter;
import ro.pippo.metrics.MetricsTransformer;

public class MetricsInitializer
implements Initializer {
    private static final Logger log = LoggerFactory.getLogger(MetricsInitializer.class);
    private MetricRegistry metricRegistry;
    private List<Closeable> reporters;

    public void init(Application application) {
        this.metricRegistry = (MetricRegistry)application.getLocals().get("metricRegistry");
        if (this.metricRegistry == null) {
            this.metricRegistry = new MetricRegistry();
        }
        SharedMetricRegistries.setDefault((String)"pippo", (MetricRegistry)this.metricRegistry);
        this.reporters = new ArrayList<Closeable>();
        PippoSettings pippoSettings = application.getPippoSettings();
        String applicationName = pippoSettings.getString("application.name", "Pippo");
        if (pippoSettings.getBoolean("metrics.jvm.enabled", false)) {
            this.registerAll("jvm.gc", (MetricSet)new GarbageCollectorMetricSet());
            this.registerAll("jvm.memory", (MetricSet)new MemoryUsageGaugeSet());
            this.registerAll("jvm.threads", (MetricSet)new ThreadStatesGaugeSet());
            this.registerAll("jvm.classes", (MetricSet)new ClassLoadingGaugeSet());
            log.debug("Registered JVM-Metrics integration");
        }
        if (pippoSettings.getBoolean("metrics.mbeans.enabled", false)) {
            JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain(applicationName).build();
            reporter.start();
            this.reporters.add((Closeable)reporter);
            log.debug("Started Pippo Metrics MBeans reporter");
        }
        for (MetricsReporter reporter : ServiceLocator.locateAll(MetricsReporter.class)) {
            reporter.start(pippoSettings, this.metricRegistry);
            this.reporters.add(reporter);
        }
        MetricsDispatchListener metricsDispatchListener = new MetricsDispatchListener(this.metricRegistry);
        application.getRoutePreDispatchListeners().add((Object)metricsDispatchListener);
        application.getRoutePostDispatchListeners().add((Object)metricsDispatchListener);
        MetricsTransformer transformer = new MetricsTransformer(this.metricRegistry);
        application.addRouteTransformer((RouteTransformer)transformer);
    }

    public void destroy(Application application) {
        for (Closeable reporter : this.reporters) {
            log.debug("Stopping '{}'", (Object)reporter.getClass().getName());
            try {
                reporter.close();
            }
            catch (IOException e) {
                log.error("Failed to stop Metrics reporter", (Throwable)e);
            }
        }
    }

    private void registerAll(String prefix, MetricSet metrics) throws IllegalArgumentException {
        for (Map.Entry entry : metrics.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()}), (MetricSet)entry.getValue());
                continue;
            }
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()}), (Metric)entry.getValue());
        }
    }
}

