/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteTransformer;
import ro.pippo.core.util.LangUtils;
import ro.pippo.core.util.StringUtils;
import ro.pippo.metrics.Counted;
import ro.pippo.metrics.CountedHandler;
import ro.pippo.metrics.Metered;
import ro.pippo.metrics.MeteredHandler;
import ro.pippo.metrics.Timed;
import ro.pippo.metrics.TimedHandler;

public class MetricsTransformer
implements RouteTransformer {
    private static final Logger log = LoggerFactory.getLogger(MetricsTransformer.class);
    private MetricRegistry metricRegistry;

    public MetricsTransformer(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public Route transform(Route route) {
        Method method = (Method)route.getAttribute("__controllerMethod");
        if (method == null) {
            try {
                method = route.getRouteHandler().getClass().getMethod("handle", RouteContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new PippoRuntimeException((Throwable)e);
            }
        }
        Object handler = null;
        if (method.isAnnotationPresent(Metered.class)) {
            log.debug("Found '{}' annotation on method '{}'", (Object)Metered.class.getSimpleName(), (Object)LangUtils.toString((Method)method));
            Metered metered = method.getAnnotation(Metered.class);
            String metricName = !metered.value().isEmpty() ? metered.value() : this.getMetricName(route, method);
            handler = new MeteredHandler(metricName, this.metricRegistry, route.getRouteHandler());
        } else if (method.isAnnotationPresent(Timed.class)) {
            log.debug("Found '{}' annotation on method '{}'", (Object)Timed.class.getSimpleName(), (Object)LangUtils.toString((Method)method));
            Timed timed = method.getAnnotation(Timed.class);
            String metricName = !timed.value().isEmpty() ? timed.value() : this.getMetricName(route, method);
            handler = new TimedHandler(metricName, this.metricRegistry, route.getRouteHandler());
        } else if (method.isAnnotationPresent(Counted.class)) {
            log.debug("Found '{}' annotation on method '{}'", (Object)Counted.class.getSimpleName(), (Object)LangUtils.toString((Method)method));
            Counted counted = method.getAnnotation(Counted.class);
            String metricName = !counted.value().isEmpty() ? counted.value() : this.getMetricName(route, method);
            handler = new CountedHandler(metricName, counted.active(), this.metricRegistry, route.getRouteHandler());
        }
        if (handler != null) {
            route.setRouteHandler(handler);
        }
        return route;
    }

    private String getMetricName(Route route, Method method) {
        String metricName = route.getName();
        if (StringUtils.isNullOrEmpty((String)metricName)) {
            metricName = MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName()});
        }
        return metricName;
    }
}

