/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.jvm.ThreadDump;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class ThreadDumpHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumpHandler.class);
    private ThreadDump threadDump;

    public ThreadDumpHandler() {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (NoClassDefFoundError e) {
            log.warn("Thread dump isn't available", (Throwable)e);
        }
    }

    public void handle(RouteContext routeContext) {
        Response response = routeContext.getResponse().noCache().text();
        if (this.threadDump != null) {
            this.threadDump.dump((OutputStream)response.getOutputStream());
        } else {
            response.internalError().send((CharSequence)"Sorry your runtime environment does not allow to dump threads");
        }
    }
}

