/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public class TimedHandler
implements RouteHandler {
    final String timerName;
    final MetricRegistry metricRegistry;
    final RouteHandler routeHandler;

    public TimedHandler(String timerName, RouteHandler routeHandler) {
        this(timerName, SharedMetricRegistries.getDefault(), routeHandler);
    }

    public TimedHandler(String timerName, MetricRegistry metricRegistry, RouteHandler routeHandler) {
        this.timerName = timerName;
        this.metricRegistry = metricRegistry;
        this.routeHandler = routeHandler;
    }

    public void handle(RouteContext routeContext) {
        Timer.Context timerContext = this.metricRegistry.timer(this.timerName).time();
        try {
            this.routeHandler.handle(routeContext);
        }
        finally {
            timerContext.stop();
        }
    }
}

