/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.test;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.mapper.ObjectMapperDeserializationContext;
import com.jayway.restassured.mapper.ObjectMapperSerializationContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;
import ro.pippo.core.Pippo;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.test.AvailablePortFinder;

public class PippoRule
implements TestRule {
    private final Pippo pippo;

    public PippoRule(Application application) {
        this(application, (Integer)AvailablePortFinder.findAvailablePort());
    }

    public PippoRule(Application application, Integer port) {
        this(new Pippo(application), port);
    }

    public PippoRule(Pippo pippo) {
        this(pippo, (Integer)AvailablePortFinder.findAvailablePort());
    }

    public PippoRule(Pippo pippo, Integer port) {
        this.pippo = pippo;
        pippo.getServer().setPort(port.intValue());
    }

    public Application getApplication() {
        return this.pippo.getApplication();
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PippoRule.this.startPippo();
                try {
                    statement.evaluate();
                }
                finally {
                    PippoRule.this.stopPippo();
                }
            }
        };
    }

    public void startPippo() {
        this.pippo.start();
        this.initRestAssured();
    }

    public void stopPippo() {
        this.pippo.stop();
    }

    protected void initRestAssured() {
        RestAssured.port = this.pippo.getServer().getPort();
        RestAssured.objectMapper((ObjectMapper)new ObjectMapper(){

            public Object deserialize(ObjectMapperDeserializationContext context) {
                ContentTypeEngine engine = PippoRule.this.pippo.getApplication().getContentTypeEngine(context.getContentType());
                if (engine == null) {
                    throw new PippoRuntimeException("No ContentTypeEngine registered for {}", new Object[]{context.getContentType()});
                }
                return engine.fromString(context.getDataToDeserialize().asString(), context.getType());
            }

            public Object serialize(ObjectMapperSerializationContext context) {
                ContentTypeEngine engine = PippoRule.this.pippo.getApplication().getContentTypeEngine(context.getContentType());
                if (engine == null) {
                    throw new PippoRuntimeException("No ContentTypeEngine registered for {}", new Object[]{context.getContentType()});
                }
                return engine.toString(context.getObjectToSerialize());
            }
        });
    }
}

