/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.net.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.compress.CompressionMethod;

public abstract class ConnectionConfiguration {
    private final String hostname;
    private final int port;
    private final Proxy proxy;
    private final boolean secure;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final int connectTimeout;
    private final List<CompressionMethod> compressionMethods;

    protected ConnectionConfiguration(Builder<? extends Builder> builder) {
        this.hostname = builder.hostname;
        this.port = builder.port;
        this.proxy = builder.proxy;
        this.secure = builder.secure;
        this.sslContext = builder.sslContext;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.connectTimeout = builder.connectTimeout;
        this.compressionMethods = builder.compressionMethods;
    }

    public abstract Connection createConnection(XmppSession var1);

    public final String getHostname() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final Proxy getProxy() {
        return this.proxy;
    }

    public final boolean isSecure() {
        return this.secure;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final List<CompressionMethod> getCompressionMethods() {
        return this.compressionMethods;
    }

    public String toString() {
        return this.hostname + ':' + this.port;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String hostname;
        protected int port;
        protected Proxy proxy;
        protected boolean secure;
        protected SSLContext sslContext;
        protected HostnameVerifier hostnameVerifier;
        protected int connectTimeout;
        protected List<CompressionMethod> compressionMethods = Collections.emptyList();

        protected Builder() {
        }

        protected abstract T self();

        public final T hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public final T port(int port) {
            this.port = port;
            return this.self();
        }

        public final T proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.self();
        }

        public final T secure(boolean secure) {
            this.secure = secure;
            return this.self();
        }

        public final T sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this.self();
        }

        public final T hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this.self();
        }

        public final T connectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("connectionTimeout cannot be negative.");
            }
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public final T compressionMethods(CompressionMethod ... compressionMethods) {
            this.compressionMethods = Arrays.asList(compressionMethods);
            return this.self();
        }

        public abstract ConnectionConfiguration build();
    }
}

