/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureListener;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

final class SecurityManager
extends StreamFeatureNegotiator {
    private final boolean isSecure;

    public SecurityManager(XmppSession xmppSession, StreamFeatureListener streamFeatureListener, boolean isSecure) {
        super(xmppSession, StartTls.class);
        this.isSecure = isSecure;
        this.addFeatureListener(streamFeatureListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StreamFeatureNegotiator.Status processNegotiation(Object element) throws StreamNegotiationException {
        if (element instanceof StartTls) {
            StartTls startTls = (StartTls)element;
            if (startTls.isMandatory() && !this.isSecure) {
                throw new StreamNegotiationException("The server requires TLS, but you disabled it.");
            }
            if (!this.isSecure) return StreamFeatureNegotiator.Status.IGNORE;
            this.xmppSession.send((StreamElement)new StartTls());
            return StreamFeatureNegotiator.Status.INCOMPLETE;
        } else {
            if (element instanceof Proceed) {
                this.notifyFeatureNegotiated();
                return StreamFeatureNegotiator.Status.SUCCESS;
            }
            if (!(element instanceof Failure)) return StreamFeatureNegotiator.Status.INCOMPLETE;
            throw new StreamNegotiationException("Failure during TLS negotiation.");
        }
    }

    @Override
    public boolean needsRestart() {
        return true;
    }

    @Override
    public boolean canProcess(Object element) {
        return element instanceof Proceed || element instanceof Failure;
    }
}

