/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import javax.net.SocketFactory;
import rocks.xmpp.core.session.Connection;
import rocks.xmpp.core.session.ConnectionConfiguration;
import rocks.xmpp.core.session.TcpConnection;
import rocks.xmpp.core.session.XmppSession;

public final class TcpConnectionConfiguration
extends ConnectionConfiguration {
    private static volatile TcpConnectionConfiguration defaultConfiguration;
    private final int keepAliveInterval;
    private final SocketFactory socketFactory;

    private TcpConnectionConfiguration(Builder builder) {
        super(builder);
        this.keepAliveInterval = builder.keepAliveInterval;
        this.socketFactory = builder.socketFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcpConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<TcpConnectionConfiguration> clazz = TcpConnectionConfiguration.class;
        synchronized (TcpConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = TcpConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TcpConnectionConfiguration configuration) {
        Class<TcpConnectionConfiguration> clazz = TcpConnectionConfiguration.class;
        synchronized (TcpConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final Connection createConnection(XmppSession xmppSession) {
        TcpConnection connection = new TcpConnection(xmppSession, this);
        connection.initialize();
        return connection;
    }

    public final int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public final SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public final String toString() {
        return "TCP connection configuration: " + super.toString();
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder> {
        private int keepAliveInterval;
        private SocketFactory socketFactory;

        private Builder() {
            this.secure(true);
            this.port(5222);
            this.keepAliveInterval(30);
        }

        public Builder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TcpConnectionConfiguration build() {
            return new TcpConnectionConfiguration(this);
        }
    }
}

